<?php
/** 
 * The SlashCreative Base Class  
 *
 * @author     SlashCreative
 * @copyright  (c) Copyright by SlashCreative
 * @link       http://slashcreative.co
 * @package    Moppers
 * @subpackage Core
 * @since      1.0.0
 */

if( !defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}
 
 /**
 * Handle Base Values.
 */
class Slcr_Base {
 	
 	/**
	 * Hold an instance of Slcr_Base class.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 * @var string
	 */
	protected static $instance = null;

	/**
	 *  Main Slcr_Base instance.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 * @var string
	 * @return Slcr_Base - Main instance.
	 */
	public static function slcr_instance() {
        if(null == self::$instance) {
            self::$instance = new Slcr_Base();
        }

        return self::$instance;
    }

	/**
	 * Constructor.
	 *
	 * @access private 
	 */
	private function __construct() {
		//load redux data files
		if ( !class_exists( 'ReduxFramework' )) {
			$this->slcr_init_hooks();
		}
	}

	/**
	 * @access private
	 * @since 1.0.0 
	 * @return  void
	 */
	private function slcr_init_hooks() { 
		
	    $myJSON = '{"last_tab":"0","general_settings_fav_icon_main":{"url":"","id":"","height":"","width":"","thumbnail":"","title":"","caption":"","alt":"","description":""},"general_settings_fav_icon_72":{"url":"","id":"","height":"","width":"","thumbnail":"","title":"","caption":"","alt":"","description":""},"general_settings_fav_icon_114":{"url":"","id":"","height":"","width":"","thumbnail":"","title":"","caption":"","alt":"","description":""},"general_settings_fav_icon_144":{"url":"","id":"","height":"","width":"","thumbnail":"","title":"","caption":"","alt":"","description":""},"general_settings_main_content_width":"1170","general_settings_main_content_padding_top":"50","general_settings_main_content_padding_bottom":"50","general_settings_main_body_border":"","general_settings_main_body_border_width":"","general_settings_color_main_border_color":"","general_settings_functionality_back_to_top":"1","general_settings_functionality_back_to_top_mobile":"1","general_settings_functionality_search_resulte_type":"default","general_settings_functionality_scroll_to_div_animation":"1","general_settings_functionality_fade_exit_animation":"1","general_settings_functionality_preloader":"1","general_settings_functionality_preloader_type":"loader","general_settings_functionality_preloader_color_1":"#6382f7","general_settings_functionality_preloader_color_2":"#6382f7","general_settings_functionality_preloader_color_3":"#6382f7","general_settings_functionality_preloader_image":{"url":"","id":"","height":"","width":"","thumbnail":"","title":"","caption":"","alt":"","description":""},"general_settings_functionality_preloader_image_height":"30","general_settings_functionality_preloader_background":"#ffffff","general_settings_functionality_preloader_position":"center","general_settings_functionality_map_api":"","general_settings_typography_body_main_typography_link":"https:\/\/fonts.googleapis.com\/css?family=Open+Sans:300,400,400i,600,700","general_settings_typography_body_main_typography_name":"\"Open Sans\", sans-serif","general_settings_typography_body_main_typography_link_switch_p":"","general_settings_typography_body_main_typography_link_p":"","general_settings_typography_body_main_typography_name_p":"","general_settings_typography_body_main_typography_link_switch_h":"1","general_settings_typography_body_main_typography_link_h":"https:\/\/fonts.googleapis.com\/css?family=Poppins:300,400,400i,600","general_settings_typography_body_main_typography_name_h":"\'Poppins\", sans-serif","general_settings_typography_body":{"font-family":"","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","text-align":"","font-size":"","line-height":"","color":"#565656"},"general_settings_typography_h1":{"font-family":"","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","text-align":"","font-size":"","line-height":"","color":"#001837"},"general_settings_typography_h2":{"font-family":"","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","text-align":"","font-size":"","line-height":"","color":"#001837"},"general_settings_typography_h3":{"font-family":"","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","text-align":"","font-size":"","line-height":"","color":"#001837"},"general_settings_typography_h4":{"font-family":"","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","text-align":"","font-size":"","line-height":"","color":"#001837"},"general_settings_typography_h5":{"font-family":"","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","text-align":"","font-size":"","line-height":"","color":"#001837"},"general_settings_typography_h6":{"font-family":"","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","text-align":"","font-size":"","line-height":"","color":"#001837"},"general_settings_typography_p_tag":{"font-family":"","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","text-align":"","font-size":"","line-height":"","color":"#565656"},"general_settings_color_main_color":"#6382f7","general_settings_color_second_color":"#fba311","general_settings_color_main_text_color":"#001837","general_settings_color_second_text_color":"#565656","general_settings_color_third_text_color":"#999999","general_settings_color_main_background_color":"#ffffff","general_settings_color_main_link_all_color":"#6382f7","general_settings_color_main_link_all_color_hover":"#6382f7","general_settings_color_main_gradient_1":"linear-gradient(to right, #1c1958 0%, #6484f7 100%);","general_settings_color_main_gradient_2":"linear-gradient(225deg,#2899f9,#0059fc)","general_settings_color_body_selection_color":"#6382f7","general_custom_css_custom_css":"","general_custom_google_analytics":"","general_custom_google_webmaster_other":"","general_settings_privacy_cookie_days":"30","general_settings_privacy_consent":"","general_settings_privacy_consent_types":["youtube","insta"],"general_settings_privacy_bar":"","general_settings_privacy_bar_text":"This website needs you to allow the use of cookies as described in our","general_settings_privacy_bar_desc":"Privacy Policy<\/a>","general_settings_privacy_bar_button_text":"I Agree","general_settings_privacy_bar_google_analytics":"1","general_settings_privacy_bar_custom_script":"","general_settings_privacy_bar_bg_color":"","general_settings_privacy_bar_text_color":"","general_settings_privacy_bar_link_color":"","general_settings_privacy_bar_button_bg_color":"","general_settings_privacy_bar_button_text_color":"","blog-settings-blog-layout":"type_2","blog-settings-blog-layout-type-one":"5","blog-settings-blog-layout-type-two":"3","blog-settings-blog-pagination":"num","blog-settings-blog-single-featured-image":"1","blog-settings-blog-single-featured-image-type":"full_width","blog-settings-blog-single-sidebar-show":"false","blog-settings-blog-single-sidebar-archive-show":"1","blog-settings-blog-single-social-link":"1","blog-settings-blog-single-author-info":"1","blog-settings-blog-single-related-post":"1","blog-settings-blog-single-biohs-slcr":"1","blog-settings-typography-single-post":{"font-family":"","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","text-align":"","font-size":"","line-height":"","color":""},"blog-settings-typography-single-post-blog-content":{"font-family":"","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","text-align":"","font-size":"","line-height":"","color":""},"blog-settings-typography-single-post-blog-paragraph":{"font-family":"","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","text-align":"","font-size":"","line-height":"","color":""},"blog-settings-typography-blog-card-heading":{"font-family":"","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","text-align":"","font-size":"","line-height":"","color":""},"blog-settings-typography-blog-card-category":{"font-family":"","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","text-align":"","font-size":"","line-height":"","color":""},"blog-settings-typography-blog-card-author-name":{"font-family":"","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","text-align":"","font-size":"","line-height":"","color":""},"blog-settings-typography-blog-card-author-description":{"font-family":"","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","text-align":"","font-size":"","line-height":"","color":""},"blog-settings-color-title-hover-color":"","blog-settings-color-pagination-color":"","blog-settings-color-loadmore-color":"","blog-settings-color-comment-author-color":"","blog-settings-color-comment-date-color":"","blog-settings-color-comment-color":"","blog-settings-color-blog-cart-header-color":"","header_navigation_logo":{"url":"","id":"","height":"","width":"","thumbnail":"","title":"","caption":"","alt":"","description":""},"header_navigation_sticky_logo":{"url":"","id":"","height":"","width":"","thumbnail":"","title":"","caption":"","alt":"","description":""},"header_navigation_logo_height":"40","header_navigation_logo_height_mobile":"","header_navigation_height":"85","header_navigation_height_mobile":"","header_navigation_background_color":{"color":"","alpha":"1","rgba":""},"header_navigation_header_scheme":"light","header_navigation_fixed_header":"","header_navigation_fixed_header_mobile":"","header_navigation_header_shadow":"small","header_navigation_sticky_header":"","header_navigation_sticky_header_mobile":"","header_navigation_height_sticky_header":"","header_navigation_background_color_sticky_header":{"color":"","alpha":"1","rgba":""},"header_navigation_sticky_header_shadow":"shadow__none","header_navigation_sticky_header_scheme":"light","header_navigation_hover_border":"expanding","header_navigation_nav_main_spacing":"30","header_navigation_nav_secondary_spacing":"5","header-navigation-settings-layout-type":"first","header-navigation-settings-layout-type-first-position":"left","header-navigation-settings-layout-third-sidebar-type":"regular","header-navigation-settings-layout-container":"1","header-navigation-settings-layout-search":"","header-navigation-settings-layout-top-bar":"","header_navigation_top_bar_background_color":{"color":"","alpha":"1","rgba":""},"header-navigation-settings-layout-top-bar-text":"","header-navigation-settings-typography-primary-icon-font-size":"17","header-navigation-settings-typography-primary-icon-spacing":"8","facebook-url":"","twitter-url":"","google-plus-url":"","vimeo-url":"","dribbble-url":"","pinterest-url":"","youtube-url":"","tumblr-url":"","linkedin-url":"","rss-url":"","behance-url":"","flickr-url":"","spotify-url":"","instagram-url":"","github-url":"","stackexchange-url":"","soundcloud-url":"","vk-url":"","vine-url":"","houzz-url":"","yelp-url":"","email-url":"","phone-url":"","header-navigation-settings-typography-main":{"font-family":"","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","text-align":"","font-size":"","line-height":"","color":"#001837"},"header-navigation-settings-typography-secondary":{"font-family":"","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","text-align":"","font-size":"","line-height":"","color":"#001837"},"header-navigation-settings-typography-top-bar-text":{"font-family":"","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","text-align":"","font-size":"","line-height":"","color":""},"header-navigation-settings-typography-dropdown":{"font-family":"","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","text-align":"","font-size":"","line-height":"","color":"#001837"},"header-navigation-settings-typography-dropdown-title":{"font-family":"","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","text-align":"","font-size":"","line-height":"","color":"#001837"},"header-navigation-settings-typography-type-mobile":"simple","header-navigation-settings-typography-background-color-mobile":"","header-navigation-settings-typography-close-color-mobile":"","header-navigation-settings-typography-top-bar-icon-color-mobile":"","header-navigation-settings-typography-top-bar-icon-font-size-mobile":"","header-navigation-settings-typography-top-bar-icon-spacing-mobile":"","header-navigation-settings-typography-main-mobile":{"font-family":"","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","text-align":"","font-size":"","line-height":"","color":""},"header-navigation-settings-typography-dropdown-mobile":{"font-family":"","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","text-align":"","font-size":"","line-height":"","color":""},"header-navigation-settings-typography-top-bar-text-mobile":{"font-family":"","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","text-align":"","font-size":"","line-height":"","color":""},"header-navigation-settings-li-hover-color-main":"#6382f7","header-navigation-settings-typography-mega-dropdown-color":"","header-navigation-settings-typography-dropdown-color":"","header-navigation-settings-typography-mega-dropdown-li-hover-color":"#6382f7","header-navigation-settings-typography-mega-dropdown-text-hover-color":"#ffffff","header-navigation-settings-typography-primary-main-icon-color":"#001837","header-navigation-settings-typography-primary-icon-color":"#001837","header-navigation-settings-typography-primary-icon-color-social":"#001837","header-navigation-settings-button-simple_button":{"font-family":"","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","text-align":"","font-size":"","line-height":"","color":""},"header-navigation-settings-button-simple_button-text-color-hover":"","header-navigation-settings-button-simple_button-color":"","header-navigation-settings-button-simple_button-color-hover":"","header-navigation-settings-button-simple_button-top-padding":"","header-navigation-settings-button-simple_button-left-padding":"","header-navigation-settings-button-simple_button-border-radius":"","header-navigation-settings-button-bordered_button":{"font-family":"","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","text-align":"","font-size":"","line-height":"","color":""},"header-navigation-settings-button-bordered_button-text-hover-color":"","header-navigation-settings-button-bordered_button-color":"","header-navigation-settings-button-bordered_button-color-hover":"","header-navigation-settings-button-bordered_button-border-color":"","header-navigation-settings-button-bordered_button-border-color-hover":"","header-navigation-settings-button-bordered_button-top-padding":"","header-navigation-settings-button-bordered_button-left-padding":"","header-navigation-settings-button-bordered_button-border-radius":"","footer-settings_logo":{"url":"","id":"","height":"","width":"","thumbnail":"","title":"","caption":"","alt":"","description":""},"footer_settings_logo_height":"40","footer-settings-copyright-text":"","footer-settings-copyright-down-text":"","footer-settings-copyright-text-default":"","footer-settings-copyright-text-on-off":"","footer-settings-footer-backgroud-type":"color","footer-settings-footer-background-image":{"url":"","id":"","height":"","width":"","thumbnail":"","title":"","caption":"","alt":"","description":""},"footer-settings-background-image-overlay":"8","footer-settings-footer-background-image-background-color-overlay":"","footer-settings-footer-background-image-background-color":"#1c1959","footer-settings-footer-background-image-background-color-copyright":"#1c1959","footer-settings-footer-background-color-scheme":"dark","footer-facebook-url":"","footer-twitter-url":"","footer-google-plus-url":"","footer-vimeo-url":"","footer-dribbble-url":"","footer-pinterest-url":"","footer-youtube-url":"","footer-tumblr-url":"","footer-linkedin-url":"","footer-rss-url":"","footer-behance-url":"","footer-flickr-url":"","footer-spotify-url":"","footer-instagram-url":"","footer-github-url":"","footer-stackexchange-url":"","footer-soundcloud-url":"","footer-vk-url":"","footer-vine-url":"","footer-houzz-url":"","footer-yelp-url":"","footer-email-url":"","footer-phone-url":"","footer-settings-type":"grid","footer-settings-layout-type":"4_col","footer-settings-layout-type-wider":"none","footer-settings-layout-type-wider-4-col":"4","footer-settings-layout-type-wider-5-col":"none","footer-settings-layout-widget-align":"left","footer-settings-layout-content-align":"left","footer-settings-layout-footer-meta-position-2-col":"1","footer-settings-layout-footer-meta-position-3-col":"1","footer-settings-layout-footer-meta-position-4-col":"1","footer-settings-layout-footer-meta-position-5-col":"1","footer-settings-footer-main-footer-padding":"100","footer-settings-footer-main-footer-padding-small":"20","footer-settings-layout-footer-social-position":"default","footer-settings-footer-primary-icon-color":"","footer-settings-footer-primary-icon-color-hover":"","footer-settings-footer-primary-icon-font-size":"","footer-settings-footer-primary-icon-spacing":"","header-navigation-settings-widget-text":{"font-family":"","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","text-align":"","font-size":"","line-height":"","color":""},"header-navigation-settings-description":{"font-family":"","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","text-align":"","font-size":"","line-height":"","color":""},"header-navigation-settings-copyright":{"font-family":"","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","text-align":"","font-size":"","line-height":"","color":""},"header-navigation-settings-title":{"font-family":"","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","text-align":"","font-size":"","line-height":"","color":""},"header-navigation-settings-link":{"font-family":"","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","text-align":"","font-size":"","line-height":"","color":""},"header-navigation-settings-menu-link":{"font-family":"","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","text-align":"","font-size":"","line-height":"","color":""},"page-header-settings-header-height":"250","page-header-settings-breadcrumb-show":"1","page-header-settings-background-type":"color","page-header-settings-breadcrumb-image-url":{"url":"","id":"","height":"","width":"","thumbnail":"","title":"","caption":"","alt":"","description":""},"page-header-settings-background-color":"#f7f7f7","page-header-settings-background-gradient":"","page-header-settings-breadcrumb-image-overlay":"","page-header-settings-overlay-opacity":"5","page-header-settings-content-color":"dark","page-header-settings-content-vertical":"middle","page-header-settings-content-horizontal":"left","page-header-settings-title-typography":{"font-family":"","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","text-align":"","font-size":"","line-height":"","color":""},"page-header-settings-description-typography":{"font-family":"","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","text-align":"","font-size":"","line-height":"","color":""},"page-header-settings-breadcrumb-color":"","page-header-settings-breadcrumb-color-hover":"","social-media-facebook-url":"","social-media-twitter-url":"","social-media-google-plus-url":"","social-media-vimeo-url":"","social-media-dribbble-url":"","social-media-pinterest-url":"","social-media-youtube-url":"","social-media-tumblr-url":"","social-media-linkedin-url":"","social-media-rss-url":"","social-media-behance-url":"","social-media-flickr-url":"","social-media-spotify-url":"","social-media-instagram-url":"","social-media-github-url":"","social-media-stackexchange-url":"","social-media-soundcloud-url":"","social-media-vk-url":"","social-media-vine-url":"","social-media-houzz-url":"","social-media-yelp-url":"","social-media-email-url":"","social-media-phone-url":"","form_styling_settings_height":"48","form_styling_settings_text_margin_top":"5","form_styling_settings_text_border_radius":"5","form_styling_settings_text_size":"14","form_styling_settings_background_color":"#f7f7f7","form_styling_settings_border_color":"#eeeeee","form_styling_settings_border_color_focuse":"#6382f7","form_styling_settings_text_color":"#001837","form_styling_settings_submit_button_padding_top":"12","form_styling_settings_submit_button_padding_left":"20","form_styling_settings_submit_button_border_radius":"4","form_styling_settings_submit_button_border_width":"0","form_styling_settings_submit_button_color":"#6382f7","form_styling_settings_submit_button_color_hover":"#6382f7","form_styling_settings_submit_button_text_color":"#ffffff","form_styling_settings_submit_button_text_color_hover":"#ffffff","form_styling_settings_submit_button_border_color":"#6382f7","form_styling_settings_submit_button_border_color_hover":"#6382f7","form_styling_settings_label_typography":{"font-family":"","font-options":"","google":"1","font-weight":"","font-style":"","subsets":"","text-align":"","font-size":"","line-height":"","color":""},"custom_font":[],"general_settings_functionality_minify_theme":false,"documentation_settings_docs":false,"woocommerce-settings-grid-type":"3","woocommerce-settings-sidebar-on-off":false,"woocommerce-settings-sidebar-position":"left","woocommerce-settings-layout-type":"modern","woocommerce-settings-type-1-text-align":"left","woocommerce-settings-gallery-category-on-off":true,"woocommerce-settings-type-2-hover-image":true,"woocommerce-settings-type-2-cart-icon":true,"woocommerce-settings-archive-header-on-off":true,"woocommerce-settings-archive-background-type":"color","woocommerce-settings-archive-background-image-overlay":5,"REDUX_last_saved":1557307938,"REDUX_LAST_SAVE":1557307938}';
	    global $slcr_redux;
		$slcr_redux = json_decode($myJSON, true); 
		 
	}
 
}

/**
 * Main instance of Slcr_Base.
 *
 * Returns the main instance of Slcr_Base to prevent the need to use globals.
 *
 * @return Slcr_Base 
 * @since 1.0.0 
 */
function slcr_base() {
	return Slcr_Base::slcr_instance();
}
slcr_base(); // init it