<?php
/** 
 * The SlashCreative Redux Header Navigation section set  
 *
 * @author     SlashCreative
 * @copyright  (c) Copyright by SlashCreative
 * @link       http://slashcreative.co
 * @package    Moppers
 * @subpackage Core
 * @since      1.0.0
 */

// START Header Navigation Fields 
Redux::setSection($opt_name, array(
    'title'            => esc_html__('Header Navigation','moppers'),
    'id'               => 'header-navigation-settings',
    'desc'             => esc_html__('All header navigation related options are listed here.','moppers'),
    'customizer_width' => '400px',
    'icon'             => 'icons-menu',
));
Redux::setSection($opt_name, array(
    'title'      => esc_html__('Logo & General Styling','moppers'),
    'id'         => 'header-navigation-settings-logo-general',
    'desc'       => esc_html__('General setting for header naigation like logos, height and colors etc.','moppers'),
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'header_navigation_logo',
            'type'     => 'media',
            'title'    => esc_html__('Main Logo','moppers'),
            'subtitle' => esc_html__('Select a main logo to display inside header naviagtion.','moppers'),
            'desc'     => '', 
        ),
        array(
            'id'       => 'header_navigation_sticky_logo',
            'type'     => 'media',
            'title'    => esc_html__('Sticky Logo','moppers'),
            'subtitle' => esc_html__('Choose a logo to display sticky is enabled.','moppers'),
            'desc'     => '',
        ),
        array(
            'id'    => 'header_navigation_logo_height',
            'type'  => 'text',
            'title' => esc_html__('Logo Height','moppers'),
            'subtitle' => esc_html__('Give a custom height to the logo.','moppers'),
            'desc'  => '',
            'default'  => '40',
        ),
        array(
            'id'    => 'header_navigation_logo_height_mobile',
            'type'  => 'text',
            'title' => esc_html__('Logo Height on Mobile','moppers'),
            'subtitle' => esc_html__('Custom height for the logo on mobile view.','moppers'),
            'desc'  => '',
        ),
        array(
            'id'    => 'header_navigation_height',
            'type'  => 'text',
            'title' => esc_html__('Header Height','moppers'),
            'subtitle' => esc_html__('Change the height of the header navigation.','moppers'),
            'desc'  => '',
            'default'  => '85',
        ),
        array(
            'id'    => 'header_navigation_height_mobile',
            'type'  => 'text',
            'title' => esc_html__('Header Height - Mobile','moppers'),
            'subtitle' => esc_html__('Custom height for the header navigation on mobile view.','moppers'),
            'desc'  => '',
        ),
        array(
            'id'       => 'header_navigation_background_color',
            'type'     => 'color_rgba',
            'title'    => esc_html__('Header Background Color','moppers'),
            'subtitle' => esc_html__('Pick a color for Background .','moppers'),
        ),
        array(
            'id'       => 'header_navigation_header_scheme',
            'type'     => 'select',
            'title'    => esc_html__('Header Scheme','moppers'),
            'subtitle' => esc_html__('Select a color scheme for header text.','moppers'),
            'options'  => array(
                'dark'  => 'dark',
                'light' => 'light',
            ),
            'default'  => 'light',
        ),
        array(
            'id'       => 'header_navigation_fixed_header',
            'type'     => 'switch',
            'title'    => esc_html__('Absolute Header','moppers'),
            'subtitle' => __('Enable this option to make the Header Absolute positioned. ','moppers').'<br /><br /> <i><strong>'.__('Best for Transparent Background','moppers').'</strong></i>',
            'default'  => false,
        ),
        array(
            'id'       => 'header_navigation_fixed_header_mobile',
            'type'     => 'switch',
            'title'    => esc_html__('Absolute - Mobile','moppers'),
            'subtitle' => esc_html__('Enable this option to keep Absolute header on Mobile View.','moppers'),
            'default'  => false,
        ),
        array(
            'id'       => 'header_navigation_header_shadow',
            'type'     => 'select',
            'title'    => esc_html__('Header Shadow','moppers'),
            'subtitle' => esc_html__('Select a shadow type on the bottom of the header.','moppers'),
            'options'  => array(
                'none'   => 'None',
                'small'  => 'Small',
                'medium' => 'Medium',
                'large'  => 'Large',
            ),
            'default'  => 'small',
        ),
        array(
            'id'       => 'header_navigation_sticky_header',
            'type'     => 'switch',
            'title'    => esc_html__('Sticky on Scroll','moppers'),
            'subtitle' => esc_html__('Make the header sticked to top when page is scrolled.','moppers'),
            'default'  => false,
        ),
        array(
            'id'       => 'header_navigation_sticky_header_mobile',
            'type'     => 'switch',
            'title'    => esc_html__('Sticky on Scroll - Mobile','moppers'),
            'subtitle' => esc_html__('Enable to keep','moppers'),
            'default'  => false,
            'required' => array('header_navigation_sticky_header', '=', true),
        ),
        array(
            'id'       => 'header_navigation_height_sticky_header',
            'type'     => 'text',
            'title'    => esc_html__('Sticky Header Height','moppers'),
            'subtitle' => esc_html__('Give custom height to the header is in sticky state.','moppers'),
            'desc'     => '',
            'required' => array('header_navigation_sticky_header', '=', true),
        ),
        array(
            'id'       => 'header_navigation_background_color_sticky_header',
            'type'     => 'color_rgba',
            'title'    => esc_html__('Sticky Background Color','moppers'),
            'subtitle' => esc_html__('Give custom background color to the header is in sticky state.','moppers'),
            'required' => array('header_navigation_sticky_header', '=', true),
        ),
        array(
            'id'       => 'header_navigation_sticky_header_shadow',
            'type'     => 'select',
            'title'    => esc_html__('Shadow on Sticky','moppers'),
            'subtitle' => esc_html__('Select a shadow type when header is in sticky state.','moppers'),
            'options'  => array(
                'shadow__none' => 'None',
                'shadow__sm'   => 'Small',
                'shadow__md'   => 'Medium',
                'shadow__lg'   => 'Large',
            ),
            'default'  => 'shadow__none',
            'required' => array('header_navigation_sticky_header', '=', true),
        ),
        array(
            'id'       => 'header_navigation_sticky_header_scheme',
            'type'     => 'select',
            'title'    => esc_html__('Sticky Header Scheme','moppers'),
            'subtitle' => esc_html__('Select a color scheme for Sticky header text.','moppers'),
            'options'  => array(
                'dark'  => 'dark',
                'light' => 'light',
            ),
            'default'  => 'light',
            'required' => array('header_navigation_sticky_header', '=', true),
        ),
        array(
            'id'       => 'header_navigation_hover_border',
            'type'     => 'select',
            'title'    => esc_html__('Menu Items Hover Type','moppers'),
            'subtitle' => esc_html__('Select a border type on mouseover menu items.','moppers'),
            'options'  => array(
                'none'      => 'None',
                'expanding' => 'Expanding Border',
                'simple'    => 'Simple Border',
                'dotted'    => 'Dots',
            ),
            'default'  => 'expanding',
        ),
        array(
            'id'       => 'header_navigation_nav_main_spacing',
            'type'     => 'text',
            'title'    => esc_html__('Main Header Spacing','moppers'),
            'subtitle' => esc_html__('Give Main Header Spacing.','moppers'),
            'default'  => '30',
        ),
        array(
            'id'       => 'header_navigation_nav_secondary_spacing',
            'type'     => 'text',
            'title'    => esc_html__('Secondary Header Spacing','moppers'),
            'subtitle' => esc_html__('Give Main Secondary Spacing.','moppers'),
            'default'  => '5',
        ),
    ),
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Navigation Layout','moppers'),
    'id'         => 'header-navigation-settings-layout',
    'desc'       => esc_html__('Build a layout for the website header.','moppers'),
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'header-navigation-settings-layout-type',
            'type'     => 'image_select',
            'title'    => esc_html__('Header Navigation Layout','moppers'),
            'subtitle' => esc_html__('Select a layout for your Navigation Header.','moppers'),
            'desc'     => esc_html__('Default layout is First','moppers'),
            'options'  => array(
                'first'  => array(
                    'alt' => 'First',
                    'img' => SLCR_REDUX_IMAGE_URI . 'header-1.png',
                ),
                'second' => array(
                    'alt' => 'Second',
                    'img' => SLCR_REDUX_IMAGE_URI . 'header-2.png',
                ),
                'third'  => array(
                    'alt' => 'Third',
                    'img' => SLCR_REDUX_IMAGE_URI . 'header-3.png',
                ),
                'fourth' => array(
                    'alt' => 'Fourth',
                    'img' => SLCR_REDUX_IMAGE_URI . 'header-4.png',
                ),
                'fifth'  => array(
                    'alt' => 'Fifth',
                    'img' => SLCR_REDUX_IMAGE_URI . 'header-5.png',
                ),
            ),
            'default'  => 'first',
        ),
        array(
            'id'       => 'header-navigation-settings-layout-type-first-position',
            'type'     => 'select',
            'title'    => esc_html__('Main Menu Position','moppers'),
            'subtitle' => esc_html__('Select the position of primary menu.','moppers'),
            'options'  => array(
                'left'   => 'Left',
                'right'  => 'Right',
                'center' => 'Center',
            ),
            'default'  => 'left',
            'required' => array('header-navigation-settings-layout-type', '=', 'first'),
        ),
        array(
            'id'       => 'header-navigation-settings-layout-third-sidebar-type',
            'type'     => 'select',
            'title'    => esc_html__('Sidebar Type','moppers'),
            'subtitle' => esc_html__('Select a sidebar type.','moppers'),
            'options'  => array(
                'regular'     => 'Regular',
                'full__width' => 'Full Width',
            ),
            'default'  => 'regular',
            'required' => array('header-navigation-settings-layout-type', '=', array('third', 'fourth')),
        ),
        array(
            'id'       => 'header-navigation-settings-layout-container',
            'type'     => 'switch',
            'title'    => esc_html__('Contained Layout','moppers'),
            'subtitle' => esc_html__('Use this option to enable or disable container inside header navigation.','moppers'),
            'default'  => true,
        ),
        array(
            'id'       => 'header-navigation-settings-layout-search',
            'type'     => 'switch',
            'title'    => esc_html__('Search Icon','moppers'),
            'subtitle' => esc_html__('Use this option to hide and show search icon.','moppers'),
            'default'  => false,
        ),
        array(
            'id'       => 'header-navigation-settings-layout-top-bar',
            'type'     => 'switch',
            'title'    => esc_html__('Tob Bar','moppers'),
            'subtitle' => esc_html__('By enabling top bar, social icons will move to the top bar and removed from main layout.','moppers'),
            'default'  => false,
        ),
        array(
            'id'       => 'header_navigation_top_bar_background_color',
            'type'     => 'color_rgba',
            'title'    => esc_html__('Background Color - Top Bar','moppers'),
            'subtitle' => esc_html__('Pick a background color for top menu bar.','moppers'),
            'required' => array('header-navigation-settings-layout-top-bar', '=', true),
            'default'  => '#f7f7f7',
        ),
        array(
            'id'       => 'header-navigation-settings-layout-top-bar-text',
            'type'     => 'textarea',
            'title'    => esc_html__('Top Bar Text','moppers'),
            'subtitle' => esc_html__('Enter custom HTML or text to show on top bar.','moppers'),
        ),
        array(
            'id'       => 'social-icons-heading',
            'type'     => '',
            'title'    => esc_html__('Social Icons','moppers'),
            'subtitle' => esc_html__('If Social Icons list is not visible, Navigate to Social Media tab in the theme options and paste URLs there.','moppers'),
        ),
        array(
            'id'       => 'header-navigation-settings-typography-primary-icon-font-size',
            'type'     => 'text',
            'title'    => esc_html__('Social Icons Size','moppers'),
            'subtitle' => esc_html__('Change the size of social icons inside header.','moppers'),
            'default'  => '17',
        ),
        array(
            'id'       => 'header-navigation-settings-typography-primary-icon-spacing',
            'type'     => 'text',
            'title'    => esc_html__('Social Icons Spacing','moppers'),
            'subtitle' => esc_html__('Adjust the spacing between social icons.','moppers'),
            'default'  => '8',
        ),
        array(
            'id'       => 'facebook-url',
            'type'     => 'checkbox',
            'title'    => esc_html__('Facebook Social Icon ','moppers'),
            'subtitle' => esc_html__('Select to add this icon to the header.','moppers'),
            'default'  => false,
            'required' => array('social-media-facebook-url', '!=', ''),
        ),
        array(
            'id'       => 'twitter-url',
            'type'     => 'checkbox',
            'title'    => esc_html__('Twitter Social Icon ','moppers'),
            'default'  => false,
            'subtitle' => esc_html__('Select to add this icon to the header.','moppers'),
            'required' => array('social-media-twitter-url', '!=', ''),
        ),
        array(
            'id'       => 'google-plus-url',
            'type'     => 'checkbox',
            'title'    => esc_html__('Google+ Social Icon ','moppers'),
            'default'  => false,
            'subtitle' => esc_html__('Select to add this icon to the header.','moppers'),
            'required' => array('social-media-google-plus-url', '!=', ''),
        ),
        array(
            'id'       => 'vimeo-url',
            'type'     => 'checkbox',
            'title'    => esc_html__('Vimeo Social Icon ','moppers'),
            'default'  => false,
            'subtitle' => esc_html__('Select to add this icon to the header.','moppers'),
            'required' => array('social-media-vimeo-url', '!=', ''),
        ),
        array(
            'id'       => 'dribbble-url',
            'type'     => 'checkbox',
            'title'    => esc_html__('Dribbble Social Icon ','moppers'),
            'default'  => false,
            'subtitle' => esc_html__('Select to add this icon to the header.','moppers'),
            'required' => array('social-media-dribbble-url', '!=', ''),
        ),
        array(
            'id'       => 'pinterest-url',
            'type'     => 'checkbox',
            'title'    => esc_html__('Pinterest Social Icon ','moppers'),
            'subtitle' => esc_html__('Select to add this icon to the header.','moppers'),
            'default'  => false,
            'required' => array('social-media-pinterest-url', '!=', ''),
        ),
        array(
            'id'       => 'youtube-url',
            'type'     => 'checkbox',
            'title'    => esc_html__('Youtube Social Icon ','moppers'),
            'subtitle' => esc_html__('Select to add this icon to the header.','moppers'),
            'default'  => false,
            'required' => array('social-media-youtube-url', '!=', ''),
        ),
        array(
            'id'       => 'tumblr-url',
            'type'     => 'checkbox',
            'title'    => esc_html__('Tumblr Social Icon ','moppers'),
            'subtitle' => esc_html__('Select to add this icon to the header.','moppers'),
            'default'  => false,
            'required' => array('social-media-tumblr-url', '!=', ''),
        ),
        array(
            'id'       => 'linkedin-url',
            'type'     => 'checkbox',
            'title'    => esc_html__('LinkedIn Social Icon ','moppers'),
            'subtitle' => esc_html__('Select to add this icon to the header.','moppers'),
            'default'  => false,
            'required' => array('social-media-linkedin-url', '!=', ''),
        ),
        array(
            'id'       => 'rss-url',
            'type'     => 'checkbox',
            'title'    => esc_html__('RSS Social Icon ','moppers'),
            'subtitle' => esc_html__('Select to add this icon to the header.','moppers'),
            'default'  => false,
            'required' => array('social-media-rss-url', '!=', ''),
        ),
        array(
            'id'       => 'behance-url',
            'type'     => 'checkbox',
            'title'    => esc_html__('Behance Social Icon ','moppers'),
            'subtitle' => esc_html__('Select to add this icon to the header.','moppers'),
            'default'  => false,
            'required' => array('social-media-behance-url', '!=', ''),
        ),
        array(
            'id'       => 'flickr-url',
            'type'     => 'checkbox',
            'title'    => esc_html__('Flickr Social Icon ','moppers'),
            'subtitle' => esc_html__('Select to add this icon to the header.','moppers'),
            'default'  => false,
            'required' => array('social-media-flickr-url', '!=', ''),
        ),
        array(
            'id'       => 'spotify-url',
            'type'     => 'checkbox',
            'title'    => esc_html__('Spotify Social Icon ','moppers'),
            'subtitle' => esc_html__('Select to add this icon to the header.','moppers'),
            'default'  => false,
            'required' => array('social-media-spotify-url', '!=', ''),
        ),
        array(
            'id'       => 'instagram-url',
            'type'     => 'checkbox',
            'title'    => esc_html__('Instagram Social Icon ','moppers'),
            'subtitle' => esc_html__('Select to add this icon to the header.','moppers'),
            'default'  => false,
            'required' => array('social-media-instagram-url', '!=', ''),
        ),
        array(
            'id'       => 'github-url',
            'type'     => 'checkbox',
            'title'    => esc_html__('GitHub Social Icon ','moppers'),
            'subtitle' => esc_html__('Select to add this icon to the header.','moppers'),
            'default'  => false,
            'required' => array('social-media-github-url', '!=', ''),
        ),
        array(
            'id'       => 'stackexchange-url',
            'type'     => 'checkbox',
            'title'    => esc_html__('StackExchange Social Icon ','moppers'),
            'subtitle' => esc_html__('Select to add this icon to the header.','moppers'),
            'default'  => false,
            'required' => array('social-media-stackexchange-url', '!=', ''),
        ),
        array(
            'id'       => 'soundcloud-url',
            'type'     => 'checkbox',
            'title'    => esc_html__('SoundCloud Social Icon ','moppers'),
            'subtitle' => esc_html__('Select to add this icon to the header.','moppers'),
            'default'  => false,
            'required' => array('social-media-soundcloud-url', '!=', ''),
        ),
        array(
            'id'       => 'vk-url',
            'type'     => 'checkbox',
            'title'    => esc_html__('VK Social Icon ','moppers'),
            'subtitle' => esc_html__('Select to add this icon to the header.','moppers'),
            'default'  => false,
            'required' => array('social-media-vk-url', '!=', ''),
        ),
        array(
            'id'       => 'vine-url',
            'type'     => 'checkbox',
            'title'    => esc_html__('Vine Social Icon ','moppers'),
            'subtitle' => esc_html__('Select to add this icon to the header.','moppers'),
            'default'  => false,
            'required' => array('social-media-vine-url', '!=', ''),
        ),
        array(
            'id'       => 'houzz-url',
            'type'     => 'checkbox',
            'title'    => esc_html__('Houzz Social Icon ','moppers'),
            'subtitle' => esc_html__('Select to add this icon to the header.','moppers'),
            'default'  => false,
            'required' => array('social-media-houzz-url', '!=', ''),
        ),
        array(
            'id'       => 'yelp-url',
            'type'     => 'checkbox',
            'title'    => esc_html__('Yelp Social Icon ','moppers'),
            'subtitle' => esc_html__('Select to add this icon to the header.','moppers'),
            'default'  => false,
            'required' => array('social-media-yelp-url', '!=', ''),
        ),
        array(
            'id'       => 'email-url',
            'type'     => 'checkbox',
            'title'    => esc_html__('Email Icon ','moppers'),
            'subtitle' => esc_html__('Select to add this icon to the header.','moppers'),
            'default'  => false,
            'required' => array('social-media-email-url', '!=', ''),
        ),
        array(
            'id'       => 'phone-url',
            'type'     => 'checkbox',
            'title'    => esc_html__('Phone Icon ','moppers'),
            'subtitle' => esc_html__('Select to add this icon to the header.','moppers'),
            'default'  => false,
            'required' => array('social-media-phone-url', '!=', ''),
        ),

    ),
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Navigation Typography','moppers'),
    'id'         => 'header-navigation-settings-typography',
    'desc'       => esc_html__('Change the typography of particular header elements.','moppers'),
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'header-navigation-settings-typography-main',
            'type'     => 'typography',
            'title'    => esc_html__('Main Menu Typography','moppers'),
            'subtitle' => esc_html__('Specify font properties for the Main Menu Links.','moppers'),
            'google'   => true,
            'default'  => array(
                'color'       => '#001837',
                'font-style'  => '',
                'font-family' => '',
                'google'      => true,
                'text-align'  => '',
                'font-size'   => '',
                'line-height' => '',
            ),
        ),
        array(
            'id'       => 'header-navigation-settings-typography-secondary',
            'type'     => 'typography',
            'title'    => esc_html__('Secondary Menu Typography','moppers'),
            'subtitle' => esc_html__('Specify font properties for the Secondary Menu Links.','moppers'),
            'google'   => true,
            'default'  => array(
                'color'       => '#001837',
                'font-style'  => '',
                'font-family' => '',
                'google'      => true,
                'text-align'  => '',
                'font-size'   => '',
                'line-height' => '',
            ),
        ), 
        array(
            'id'       => 'header-navigation-settings-typography-top-bar-text',
            'type'     => 'typography',
            'title'    => esc_html__('Top Bar Text Typography','moppers'),
            'subtitle' => esc_html__('Specify font properties for the Top Bar Custom Text.','moppers'),
            'google'   => true,
        ),
        array(
            'id'       => 'header-navigation-settings-typography-dropdown',
            'type'     => 'typography',
            'title'    => esc_html__('Dropdown Menu Typography','moppers'),
            'subtitle' => esc_html__('Specify font properties for the Dropdown Menu Typography.','moppers'),
            'google'   => true,
            'default'  => array(
                'color'       => '#001837',
                'font-style'  => '',
                'font-family' => '',
                'google'      => true,
                'text-align'  => '',
                'font-size'   => '',
                'line-height' => '',
            ),
        ),
        array(
            'id'       => 'header-navigation-settings-typography-dropdown-title',
            'type'     => 'typography',
            'title'    => esc_html__('Dropdown Title Typography','moppers'),
            'subtitle' => esc_html__('Specify font properties for the Dropdown Menu Title.','moppers'),
            'google'   => true,
            'default'  => array(
                'color'       => '#001837',
                'font-style'  => '',
                'font-family' => '',
                'google'      => true,
                'text-align'  => '',
                'font-size'   => '',
                'line-height' => '',
            ),
        ),
    ),
));
Redux::setSection($opt_name, array(
    'title'      => esc_html__('Mobile & Sidebar Navigation','moppers'),
    'id'         => 'header-navigation-settings-typography-mobile',
    'desc'       => esc_html__('Style the sidebar navigation on mobile view and desktop view.','moppers'),
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'header-navigation-settings-typography-type-mobile',
            'type'     => 'select',
            'title'    => esc_html__('Mobile Navigation Style','moppers'),
            'subtitle' => esc_html__('Select a Style Type.','moppers'),
            'options'  => array(
                'modern' => 'Modern',
                'simple' => 'Simple',
            ),
            'default'  => 'simple',
            'required' => array(array('header-navigation-settings-layout-type', '!=', 'third'), array('header-navigation-settings-layout-type', '!=', 'fourth')),
        ),
        array(
            'id'       => 'header-navigation-settings-typography-background-color-mobile',
            'type'     => 'color',
            'title'    => esc_html__('Sidebar Background Color','moppers'),
            'subtitle' => esc_html__('Pick a color for Background.','moppers'),
        ),
        array(
            'id'       => 'header-navigation-settings-typography-close-color-mobile',
            'type'     => 'color',
            'title'    => esc_html__('Sidebar Close Icon Color','moppers'),
            'subtitle' => esc_html__('Change the color of sidebar close icon.','moppers'),
        ),
        array(
            'id'       => 'header-navigation-settings-typography-top-bar-icon-color-mobile',
            'type'     => 'color',
            'title'    => esc_html__('Social Icons Color','moppers'),
            'subtitle' => esc_html__('Pick a color for Top Bar Icon.','moppers'),
        ),
        array(
            'id'       => 'header-navigation-settings-typography-top-bar-icon-font-size-mobile',
            'type'     => 'text',
            'title'    => esc_html__('Social Icons Size','moppers'),
            'subtitle' => esc_html__('Enter Mobile Social Icons Size. e.g. 30','moppers'),
            'desc'     => '',
        ),
        array(
            'id'       => 'header-navigation-settings-typography-top-bar-icon-spacing-mobile',
            'type'     => 'text',
            'title'    => esc_html__('Social Icons Spacing','moppers'),
            'subtitle' => esc_html__('Enter Mobile Social Icons Spacing. e.g. 30','moppers'),
            'desc'     => '',
        ),
        array(
            'id'       => 'header-navigation-settings-typography-main-mobile',
            'type'     => 'typography',
            'title'    => esc_html__('Main Menu Typography','moppers'),
            'subtitle' => esc_html__('Specify font properties for the Main Menu Links.','moppers'),
            'google'   => true,
        ),
        array(
            'id'       => 'header-navigation-settings-typography-dropdown-mobile',
            'type'     => 'typography',
            'title'    => esc_html__('Dropdown Menu Typography','moppers'),
            'subtitle' => esc_html__('Specify font properties for the Dropdown Menu Links.','moppers'),
            'google'   => true,
        ), 
        array(
            'id'       => 'header-navigation-settings-typography-top-bar-text-mobile',
            'type'     => 'typography',
            'title'    => esc_html__('Top Bar Text Typography','moppers'),
            'subtitle' => esc_html__('Specify font properties for the Top Bar Text.','moppers'),
            'google'   => true,
        ),
    ),
));
Redux::setSection($opt_name, array(
    'title'      => esc_html__('Custom Colors','moppers'),
    'id'         => 'header-navigation-settings-color',
    'desc'       => esc_html__('Custom color selection for header elements.','moppers'),
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'header-navigation-settings-li-hover-color-main',
            'type'     => 'color',
            'title'    => esc_html__('Menu Item Hover / Active - Text Color','moppers'),
            'subtitle' => esc_html__('Pick a color on menu item hover.','moppers'),
            'default'  => '#6382f7',
        ),
        array(
            'id'       => 'header-navigation-settings-typography-mega-dropdown-color',
            'type'     => 'color',
            'title'    => esc_html__('Mega Dropdown Background Color','moppers'),
            'subtitle' => esc_html__('Use a custom background color for mega dropdown menu.','moppers'),
        ),
        array(
            'id'       => 'header-navigation-settings-typography-dropdown-color',
            'type'     => 'color',
            'title'    => esc_html__('Simple Dropdown Background Color','moppers'),
            'subtitle' => esc_html__('Use a custom background color for simple dropdown menu.','moppers'),
        ),
        array(
            'id'       => 'header-navigation-settings-typography-mega-dropdown-li-hover-color',
            'type'     => 'color',
            'title'    => esc_html__('Dropdown List Item Hover - Background Color','moppers'),
            'subtitle' => esc_html__('Pick a custom background color on dropdown menu item hover.','moppers'),
            'default'  => '#6382f7',
        ),
        array(
            'id'       => 'header-navigation-settings-typography-mega-dropdown-text-hover-color',
            'type'     => 'color',
            'title'    => esc_html__('Dropdown List Item Hover - Text Color','moppers'),
            'subtitle' => esc_html__('Pick a color on dropdown menu item hover.','moppers'),
            'default'  => '#ffffff',
        ),
        array(
            'id'       => 'header-navigation-settings-typography-primary-main-icon-color',
            'type'     => 'color',
            'title'    => esc_html__('Menu Icon Color','moppers'),
            'subtitle' => esc_html__('Pick a color for simple mobile menu icon.','moppers'),
            'default'  => '#001837',
        ),
        array(
            'id'       => 'header-navigation-settings-typography-primary-icon-color',
            'type'     => 'color',
            'title'    => esc_html__('Main Navigation Icon Color','moppers'),
            'subtitle' => __('Pick a custom color for main navigation icons. ','moppers').'<br/> <strong>'.__('Example - Search Icon and Cart Icon','moppers').'</strong>',
            'default'  => '#001837',
        ),
        array(
            'id'       => 'header-navigation-settings-typography-primary-icon-color-social',
            'type'     => 'color',
            'title'    => esc_html__('Social Icons Color','moppers'),
            'subtitle' => esc_html__('Change icons color for social media icons in header navigation','moppers'),
            'default'  => '#001837',
        ),
    ),
));
Redux::setSection($opt_name, array(
    'title'      => esc_html__('Custom Menu Button','moppers'),
    'desc'       => esc_html__('Use custom settings to modify menu list buttons according to your need. To use a button as a menu item, Go to Menus > Select a menu item > Change Menu Item Style to Simple Button or Bordered Button.','moppers'),
    'id'         => 'header-navigation-settings-button',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'simple-button-heading',
            'type'     => '',
            'title'    => esc_html__('Simple Button Styling','moppers'),
            'subtitle' => esc_html__('Custom settings to make desired menu item button.','moppers'),
        ),
        array(
            'id'       => 'header-navigation-settings-button-simple_button',
            'type'     => 'typography',
            'title'    => esc_html__('Simple Button Typography','moppers'),
            'subtitle' => esc_html__('Specify font properties for the Simple Button Text.','moppers'),
            'google'   => true,
        ),
        array(
            'id'       => 'header-navigation-settings-button-simple_button-text-color-hover',
            'type'     => 'color',
            'title'    => esc_html__('Simple Button Text Color - Hover','moppers'),
            'subtitle' => esc_html__('Custom text color on hover.','moppers'),
        ),
        array(
            'id'       => 'header-navigation-settings-button-simple_button-color',
            'type'     => 'color',
            'title'    => esc_html__('Simple Button Background Color','moppers'),
            'subtitle' => esc_html__('Custom background color.','moppers'),
        ),
        array(
            'id'       => 'header-navigation-settings-button-simple_button-color-hover',
            'type'     => 'color',
            'title'    => esc_html__('Simple Button Background Color - Hover','moppers'),
            'subtitle' => esc_html__('Custom background color on hover.','moppers'),
        ),
        array(
            'id'       => 'header-navigation-settings-button-simple_button-top-padding',
            'type'     => 'text',
            'title'    => esc_html__('Simple Button Padding - Top and Bottom','moppers'),
            'subtitle' => esc_html__('Enter Button Padding - Top and Bottom. e.g. 10','moppers'),
            'desc'     => '',
        ),
        array(
            'id'       => 'header-navigation-settings-button-simple_button-left-padding',
            'type'     => 'text',
            'title'    => esc_html__('Simple Button Padding - Left and Right','moppers'),
            'subtitle' => esc_html__('Enter Button Padding - Left and Right. e.g. 10','moppers'),
            'desc'     => '',
        ),
        array(
            'id'       => 'header-navigation-settings-button-simple_button-border-radius',
            'type'     => 'text',
            'title'    => esc_html__('Simple Button Border Radius','moppers'),
            'subtitle' => esc_html__('Enter Button Border Radius. e.g. 10','moppers'),
            'desc'     => '',
        ),
        array(
            'id'       => 'bordered-button-heading',
            'type'     => '',
            'title'    => esc_html__('Bordered Button Styling','moppers'),
            'subtitle' => esc_html__('Custom settings to make desired menu item button.','moppers'),
        ),
        array(
            'id'       => 'header-navigation-settings-button-bordered_button',
            'type'     => 'typography',
            'title'    => esc_html__('Bordered Button Typography','moppers'),
            'subtitle' => esc_html__('Specify font properties for the Bordered Button Text.','moppers'),
            'google'   => true,
        ),
        array(
            'id'       => 'header-navigation-settings-button-bordered_button-text-hover-color',
            'type'     => 'color',
            'title'    => esc_html__('Bordered Button Text Color - Hover','moppers'),
            'subtitle' => esc_html__('Change text color on hover.','moppers'),
        ),
        array(
            'id'       => 'header-navigation-settings-button-bordered_button-color',
            'type'     => 'color',
            'title'    => esc_html__('Bordered Button Background Color','moppers'),
            'subtitle' => esc_html__('Custom background color for button.','moppers'),
        ),
        array(
            'id'       => 'header-navigation-settings-button-bordered_button-color-hover',
            'type'     => 'color',
            'title'    => esc_html__('Bordered Button Background Color - Hover','moppers'),
            'subtitle' => esc_html__('Pick a color for bordered button background on hover.','moppers'),
        ),
        array(
            'id'       => 'header-navigation-settings-button-bordered_button-border-color',
            'type'     => 'color',
            'title'    => esc_html__('Bordered Button Border Color','moppers'),
            'subtitle' => esc_html__('Change border color of button.','moppers'),
        ),
        array(
            'id'       => 'header-navigation-settings-button-bordered_button-border-color-hover',
            'type'     => 'color',
            'title'    => esc_html__('Bordered Button Border Color - Hover','moppers'),
            'subtitle' => esc_html__('Change border color of button on hover.','moppers'),
        ),
        array(
            'id'       => 'header-navigation-settings-button-bordered_button-top-padding',
            'type'     => 'text',
            'title'    => esc_html__('Button Padding - Top and Bottom','moppers'),
            'subtitle' => esc_html__('Enter Button Padding - Top and Bottom. e.g. 10','moppers'),
            'desc'     => '',
        ),
        array(
            'id'       => 'header-navigation-settings-button-bordered_button-left-padding',
            'type'     => 'text',
            'title'    => esc_html__('Button Padding - Left and Right','moppers'),
            'subtitle' => esc_html__('Enter Button Padding - Left and Right. e.g. 10','moppers'),
            'desc'     => '',
        ),
        array(
            'id'       => 'header-navigation-settings-button-bordered_button-border-radius',
            'type'     => 'text',
            'title'    => esc_html__('Button Border Radius','moppers'),
            'subtitle' => esc_html__('Enter Button Border Radius. e.g. 10','moppers'),
            'desc'     => '',
        ),

    ),
));
 
