<?php
/** 
 * The SlashCreative Redux General Settings section set  
 *
 * @author     SlashCreative
 * @copyright  (c) Copyright by SlashCreative
 * @link       http://slashcreative.co
 * @package    Moppers
 * @subpackage Core
 * @since      1.0.0
 */

// START General Settings Fields
Redux::setSection($opt_name, array(
    'title'            => esc_html__('General Settings','moppers'),
    'id'               => 'general-settings',
    'desc'             => esc_html__('General Theme options','moppers'),
    'customizer_width' => '400px',
    'icon'             => 'icons-settings',
));
Redux::setSection($opt_name, array(
    'title'      => esc_html__('General Settings','moppers'),
    'desc'       => esc_html__('General and basic theme options.','moppers'),
    'id'         => 'general-settings-general',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'general_settings_fav_icon_main',
            'type'     => 'media',
            'title'    => esc_html__('Favicon','moppers'),
            'subtitle' => esc_html__('Upload a 16 x 16 or 32 x 32 Favicon for your website.','moppers'),
            'desc'     => '',
        ),
        array(
            'id'       => 'general_settings_fav_icon_72',
            'type'     => 'media',
            'title'    => esc_html__('Apple Touch Icon 72','moppers'),
            'subtitle' => esc_html__('Choose 72 x 72 Apple touch icon.','moppers'),
            'desc'     => '',
        ),
        array(
            'id'       => 'general_settings_fav_icon_114',
            'type'     => 'media',
            'title'    => esc_html__('Apple Touch Icon 114','moppers'),
            'subtitle' => esc_html__('Choose 114 x 114 Apple touch icon.','moppers'),
            'desc'     => '',
        ),
        array(
            'id'       => 'general_settings_fav_icon_144',
            'type'     => 'media',
            'title'    => esc_html__('Apple Touch Icon 144','moppers'),
            'subtitle' => esc_html__('Choose 144 x 144 Apple touch icon.','moppers'),
            'desc'     => '',
        ),
        array(
            'id'       => 'general_settings_main_content_width',
            'type'     => 'text',
            'title'    => esc_html__('Container Width','moppers'),
            'subtitle' => __('Change the width of container in whole website.','moppers').'<br/> <strong>'.__('Default size is 1170.','moppers').'</strong>',
            'desc'     => '',
            'default'  => '1170',
        ),
        array(
            'id'       => 'general_settings_main_content_padding_top',
            'type'     => 'text',
            'title'    => esc_html__('Content Padding - Top','moppers'),
            'subtitle' => __('Enter custom padding on the top of main content. ','moppers').'<br/> <i><strong>'.__('Content between Header and Footer','moppers').'</strong></i>',
            'desc'     => '',
            'default'  => '50',
        ),
        array(
            'id'       => 'general_settings_main_content_padding_bottom',
            'type'     => 'text',
            'title'    => esc_html__('Content Padding - Bottom','moppers'),
            'subtitle' => __('Enter custom padding on the bottom of main content. ','moppers').'<br/> <i><strong>'.__('Content between Header and Footer','moppers').'</strong></i>',
            'desc'     => '',
            'default'  => '50',
        ),
        array(
            'id'       => 'general_settings_main_body_border',
            'type'     => 'switch',
            'title'    => esc_html__('Body Border','moppers'),
            'subtitle' => esc_html__('Enable a border around entire window.','moppers'),
            'default'  => false,
        ),
        array(
            'id'       => 'general_settings_main_body_border_width',
            'type'     => 'text',
            'title'    => esc_html__('Border Width','moppers'),
            'subtitle' => __('Enter the value for border width. ','moppers').'<br/> <i><strong>'.__('Example - 10','moppers').'</strong></i>',
            'desc'     => '',
            'required' => array('general_settings_main_body_border', '=', true),
        ),
        array(
            'id'       => 'general_settings_color_main_border_color',
            'type'     => 'color',
            'title'    => esc_html__('Border Color','moppers'),
            'subtitle' => __('Select a color to apply on body border','moppers'),
            'required' => array('general_settings_main_body_border', '=', true),
        ),
    ),
));
$autoptimize_url_real="";
if (class_exists( 'autoptimizeMain' ) ) {
    $autoptimize_url      = admin_url("options-general.php?page=autoptimize");
    $autoptimize_url_real = '<h4>Go to the <a href=' . $autoptimize_url . '>Autoptimize Settings Page</a> . for advanced compression settings.</h4> <br>Autoptimize allows you compressing and joining css and javascripts in to one file for faster page load and better performance.';
} else {
    $autoptimize_url      = admin_url("themes.php?page=tgmpa-install-plugins");
    $autoptimize_url_real = '<h4>Go to the <a href=' . $autoptimize_url . '>Autoptimize Settings Page</a> . for advanced compression settings.</h4> <br>Autoptimize allows you compressing and joining css and javascripts in to one file for faster page load and better performance.';
}
Redux::setSection($opt_name, array(
    'title'      => esc_html__('Functionality','moppers'),
    'desc'       => esc_html__('Theme functionality and other settings.','moppers'),
    'id'         => 'general-settings-functionality',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'general_settings_functionality_minify_theme',
            'type'     => 'htmltext',
            'title'    => esc_html__('Compress HTML, CSS & Javascripts','moppers'),
            'default'  => false,
            'subtitle' => $autoptimize_url_real,
        ),
        array(
            'id'       => 'general_settings_functionality_back_to_top',
            'type'     => 'switch',
            'title'    => esc_html__('Back to Top Icon','moppers'),
            'subtitle' => esc_html__('Enable or disable back to top button on every page.','moppers'),
            'default'  => true,
        ),
        array(
            'id'       => 'general_settings_functionality_back_to_top_mobile',
            'type'     => 'switch',
            'title'    => esc_html__('Back to Top Icon Mobile','moppers'),
            'subtitle' => esc_html__('Keep this button on Mobile and Tablet by enabling this option.','moppers'),
            'default'  => true,
            'required' => array('general_settings_functionality_back_to_top', '=', true),
        ),
        array(
            'id'       => 'general_settings_functionality_search_resulte_type',
            'type'     => 'select',
            'title'    => esc_html__('Search Type','moppers'),
            'subtitle' => __('Select a type of Search. ','moppers').'<br/><br/><i><strong>'.__('Select product to search products and blog to search only blog posts in the search results.','moppers').'</strong></i>',
            'options'  => array(
                "default" => "Default",
                "product" => "Product",
                "blog"    => "Blog",
            ),
            'default'  => 'default',
        ),
        array(
            'id'       => 'general_settings_functionality_scroll_to_div_animation',
            'type'     => 'switch',
            'title'    => esc_html__('Scroll To Div Animation','moppers'),
            'subtitle' => esc_html__('Scroll smoothly via in-page links.','moppers'),
            'default'  => true,
        ), 
        array(
            'id'       => 'general_settings_functionality_preloader',
            'type'     => 'switch',
            'title'    => esc_html__('Preloader','moppers'),
            'subtitle' => esc_html__('Enable or disable preloader.','moppers'),
            'default'  => true,
        ),
        array(
            'id'       => 'general_settings_functionality_preloader_type',
            'type'     => 'select',
            'title'    => esc_html__('Preloader Type','moppers'),
            'subtitle' => __('Select a type of preloader. ','moppers').'<br/><br/><i><strong>'.__('Loader is the default theme preloader type. You can also use custom image GIF or simple image by selecting Image option.','moppers').'</strong></i>',
            'options'  => array(
                "loader" => "Loader",
                "image"  => "Image",
            ),
            'default'  => 'loader',
            'required' => array('general_settings_functionality_preloader', '=', true),
        ),
        array(
            'id'       => 'general_settings_functionality_preloader_color_1',
            'type'     => 'color',
            'title'    => esc_html__('First Color - Preloader','moppers'),
            'subtitle' => __('Select 3 different colors to make it multicoloured or select same color at each field to use it as single coloured.','moppers').'<br/><br/><i><strong>'.__('Do not leave any color empty.','moppers').'</strong></i>',
            'required' => array('general_settings_functionality_preloader_type', '=', "loader"),
            'default'  => '#6382f7',
        ),
        array(
            'id'       => 'general_settings_functionality_preloader_color_2',
            'type'     => 'color',
            'title'    => esc_html__('Second Color - Preloader','moppers'),
            'subtitle' => __('Select second color for preloader.','moppers').'<br/><br/><i><strong>'.__('Do not leave this empty.','moppers').'</strong></i>',
            'required' => array('general_settings_functionality_preloader_type', '=', "loader"),
            'default'  => '#6382f7',
        ),
        array(
            'id'       => 'general_settings_functionality_preloader_color_3',
            'type'     => 'color',
            'title'    => esc_html__('Third Color - Preloader','moppers'),
            'subtitle' => __('Select third color for preloader.','moppers').'<br/><br/><i><strong>'.__('Do not leave this empty.','moppers').'</strong></i>',
            'required' => array('general_settings_functionality_preloader_type', '=', "loader"),
            'default'  => '#6382f7',
        ),
        array(
            'id'       => 'general_settings_functionality_preloader_image',
            'type'     => 'media',
            'title'    => esc_html__('Preloader Image','moppers'),
            'subtitle' => __('Select a image to use as website preloader. ','moppers').'<br/> <i><strong>'.__('You can use GIF or simple image.','moppers').'</strong></i>',
            'desc'     => '',
            'required' => array('general_settings_functionality_preloader_type', '=', "image"),
        ),
        array(
            'id'       => 'general_settings_functionality_preloader_image_height',
            'type'     => 'text',
            'title'    => esc_html__('Image Size','moppers'),
            'subtitle' => esc_html__('Give a custom height to your image.','moppers'),
            'desc'     => '',
            'default'  => '30',
            'required' => array('general_settings_functionality_preloader_type', '=', "image"),
        ),
        array(
            'id'       => 'general_settings_functionality_preloader_background',
            'type'     => 'color',
            'title'    => esc_html__('Preloader Page Background Color','moppers'),
            'subtitle' => esc_html__('Change the background color of the preloader page.','moppers'),
            'default'  => '#ffffff',
        ),
        array(
            'id'       => 'general_settings_functionality_preloader_position',
            'type'     => 'select',
            'title'    => esc_html__('Preloader Position','moppers'),
            'subtitle' => esc_html__('Select a position of page, where you want to show preloader.','moppers'),
            'options'  => array(
                "center"       => "Center",
                "top-left"     => "Top Left",
                "top-right"    => "Top Right",
                "bottom-left"  => "Bottom Left",
                "bottom-right" => "Bottom Right",
            ),
            'default'  => 'center',
        ),
        array(
            'id'       => 'general_settings_functionality_map_api',
            'type'     => 'text',
            'title'    => esc_html__('Google Map API ','moppers'),
            'subtitle' => __('Enter your Google API key to enable Google Maps. ','moppers').'<a href="https://cloud.google.com/maps-platform/" targe="_blank">'.__('Get your key here','moppers').'</a>',
            'desc'     => '',
        ),
    ),
));
Redux::setSection($opt_name, array(
    'title'            => esc_html__('Typography','moppers'),
    'id'               => 'general-settings-typography',
    'subsection'       => true,
    'customizer_width' => '450px',
    'desc'             => esc_html__('Main theme typography settings.','moppers'),
    'fields'           => array(
        array(
            'id'       => 'general_settings_typography_body_main_typography_link',
            'type'     => 'text',
            'title'    => esc_html__('Body & Overall Font URL','moppers'),
            'subtitle' => __('Enter a Google Fonts or Typekit URL to load font files. ','moppers').'<br/> <i><strong>'.__('Example - https://fonts.googleapis.com/css?family=Poppins:400,500,600,700','moppers').'</strong></i>',
            'desc'     => '',
            'default'  => 'https://fonts.googleapis.com/css?family=Open+Sans:300,400,400i,600,700',
        ),
        array(
            'id'       => 'general_settings_typography_body_main_typography_name',
            'type'     => 'text',
            'title'    => esc_html__('Overall Font Family','moppers'),
            'subtitle' => __('Enter the font family css of the font you are using.','moppers').'<br/> <i><strong>'.__("Example - 'Poppins', sans-serif","moppers").'</strong></i><br>'.__('Do not use double quotes ( " ) in Font Family Name','moppers'),
            'desc'     => '',
            'default'  => "'Open Sans', sans-serif",
        ),
        array(
            'id'       => 'general_settings_typography_body_main_typography_link_switch_p',
            'type'     => 'switch',
            'title'    => esc_html__('Use Different Font for Paragraph Tag','moppers'),
            'subtitle' => __('Enable the option to use different font family for p or Paragraph tag.','moppers'),
            'default'  => false, // 1 = on | 0 = off
        ),
        array(
            'id'       => 'general_settings_typography_body_main_typography_link_p',
            'type'     => 'text',
            'title'    => esc_html__('Paragraph Font URL','moppers'),
            'subtitle' => __('Enter a Google Fonts or Typekit URL to load font files. ','moppers').'<br/> <i><strong>'.__('Example - https://fonts.googleapis.com/css?family=Nunito:400,600,700','moppers').'</strong></i>',
            'desc'     => '',
            'required' => array('general_settings_typography_body_main_typography_link_switch_p', '=', true), 
        ),
        array(
            'id'       => 'general_settings_typography_body_main_typography_name_p',
            'type'     => 'text',
            'title'    => esc_html__('Paragraph Font Family','moppers'),
            'subtitle' => __('Enter the font family css of the font you are using.','moppers').'<br/> <i><strong>'.__("Example - 'Nunito', sans-serif","moppers").'</strong></i><br>'.__('Do not use double quotes ( " ) in Font Family Name','moppers'),
            'desc'     => '',
            'required' => array('general_settings_typography_body_main_typography_link_switch_p', '=', true), 
        ),
        array(
            'id'       => 'general_settings_typography_body_main_typography_link_switch_h',
            'type'     => 'switch',
            'title'    => esc_html__('Use Different Font for all Heading Tags','moppers'),
            'subtitle' => esc_html__('Enable the option to use different font family for H or Heading tags.','moppers'),
            'default'  => true, // 1 = on | 0 = off
        ),
        array(
            'id'       => 'general_settings_typography_body_main_typography_link_h',
            'type'     => 'text',
            'title'    => esc_html__('Headings Font URL','moppers'),
            'subtitle' => __('Enter a Google Fonts or Typekit URL to load font files.  ','moppers').'<br/> <i><strong>'.__('Example - https://fonts.googleapis.com/css?family=Nunito:400,600,700','moppers').'</strong></i>',
            'desc'     => '',
            'required' => array('general_settings_typography_body_main_typography_link_switch_h', '=', true),
            'default'  => 'https://fonts.googleapis.com/css?family=Poppins:300,400,400i,600',
        ),
        array(
            'id'       => 'general_settings_typography_body_main_typography_name_h',
            'type'     => 'text',
            'title'    => esc_html__('Headings Font Family','moppers'),
            'subtitle' => __('Enter the font family css of the font you are using.','moppers').'<br/> <i><strong>'.__("Example - 'Nunito', sans-serif","moppers").'</strong></i><br>'.__('Do not use double quotes ( " ) in Font Family Name','moppers'),
            'desc'     => '',
            'required' => array('general_settings_typography_body_main_typography_link_switch_h', '=', true),
            'default'  => "'Poppins', sans-serif",
        ),
        array(
            'id'       => 'general_settings_typography_body',
            'type'     => 'typography',
            'title'    => esc_html__('Body Typography','moppers'),
            'subtitle' => esc_html__('Specify font properties for the Body typography.','moppers'),
            'google'   => true,
            'default'  => array(
                'color'       => '#565656',
                'font-style'  => '',
                'font-family' => '',
                'google'      => true, 
                'font-size'   => '',
                'line-height' => '',
            ),
        ),
        array(
            'id'       => 'general_settings_typography_h1',
            'type'     => 'typography',
            'title'    => esc_html__('H1 Tag Typography','moppers'),
            'subtitle' => esc_html__('Specify font properties for the H1 tag Typography.','moppers'),
            'google'   => true,
            'default'  => array(
                'color'       => '#001837',
                'font-style'  => '',
                'font-family' => '',
                'google'      => true, 
                'font-size'   => '',
                'line-height' => '',
            ),
        ),
        array(
            'id'       => 'general_settings_typography_h2',
            'type'     => 'typography',
            'title'    => esc_html__('H2 Tag Typography','moppers'),
            'subtitle' => esc_html__('Specify font properties for the H2 tag Typography.','moppers'),
            'google'   => true,
            'default'  => array(
                'color'       => '#001837',
                'font-style'  => '',
                'font-family' => '',
                'google'      => true, 
                'font-size'   => '',
                'line-height' => '',
            ),
        ),
        array(
            'id'       => 'general_settings_typography_h3',
            'type'     => 'typography',
            'title'    => esc_html__('H3 Tag Typography','moppers'),
            'subtitle' => esc_html__('Specify font properties for the H3 tag Typography.','moppers'),
            'google'   => true,
            'default'  => array(
                'color'       => '#001837',
                'font-style'  => '',
                'font-family' => '',
                'google'      => true, 
                'font-size'   => '',
                'line-height' => '',
            ),
        ),
        array(
            'id'       => 'general_settings_typography_h4',
            'type'     => 'typography',
            'title'    => esc_html__('H4 Tag Typography','moppers'),
            'subtitle' => esc_html__('Specify font properties for the H4 tag Typography.','moppers'),
            'google'   => true,
            'default'  => array(
                'color'       => '#001837',
                'font-style'  => '',
                'font-family' => '',
                'google'      => true, 
                'font-size'   => '',
                'line-height' => '',
            ),
        ),
        array(
            'id'       => 'general_settings_typography_h5',
            'type'     => 'typography',
            'title'    => esc_html__('H5 Tag Typography','moppers'),
            'subtitle' => esc_html__('Specify font properties for the H5 tag Typography.','moppers'),
            'google'   => true,
            'default'  => array(
                'color'       => '#001837',
                'font-style'  => '',
                'font-family' => '',
                'google'      => true, 
                'font-size'   => '',
                'line-height' => '',
            ),
        ),
        array(
            'id'       => 'general_settings_typography_h6',
            'type'     => 'typography',
            'title'    => esc_html__('H6 Tag Typography','moppers'),
            'subtitle' => esc_html__('Specify font properties for the H6 tag Typography.','moppers'),
            'google'   => true,
            'default'  => array(
                'color'       => '#001837',
                'font-style'  => '',
                'font-family' => '',
                'google'      => true, 
                'font-size'   => '',
                'line-height' => '',
            ),
        ),
        array(
            'id'       => 'general_settings_typography_p_tag',
            'type'     => 'typography',
            'title'    => esc_html__('P Tag Typography','moppers'),
            'subtitle' => esc_html__('Specify font properties for the P tag Typography.','moppers'),
            'google'   => true,
            'default'  => array(
                'color'       => '#565656',
                'font-style'  => '',
                'font-family' => '',
                'google'      => true, 
                'font-size'   => '',
                'line-height' => '',
            ),
        ),
    ),
));
Redux::setSection($opt_name, array(
    'title'            => esc_html__('Theme Colors','moppers'),
    'id'               => 'general-settings-color',
    'subsection'       => true,
    'customizer_width' => '450px',
    'desc'             => esc_html__('Theme colors settings ','moppers'),
    'fields'           => array(
        array(
            'id'       => 'general_settings_color_main_color',
            'type'     => 'color',
            'title'    => esc_html__('Main Theme Color','moppers'),
            'subtitle' => esc_html__('Select a main theme color.','moppers'),
            'default'  => '#6382f7',
        ),
        array(
            'id'       => 'general_settings_color_second_color',
            'type'     => 'color',
            'title'    => esc_html__('Second Color','moppers'),
            'subtitle' => esc_html__('Select a second color.','moppers'),
            'default'  => '#fba311',
        ),
        array(
            'id'       => 'general_settings_color_main_text_color',
            'type'     => 'color',
            'title'    => esc_html__('Main Text Color','moppers'),
            'subtitle' => esc_html__('Select a color to use as overall text color.','moppers'),
            'default'  => '#001837',
        ),
        array(
            'id'       => 'general_settings_color_second_text_color',
            'type'     => 'color',
            'title'    => esc_html__('Second Text Color','moppers'),
            'subtitle' => esc_html__('Select a Second color to use as overall text color.','moppers'),
            'default'  => '#565656',
        ),
        array(
            'id'       => 'general_settings_color_third_text_color',
            'type'     => 'color',
            'title'    => esc_html__('Third Text Color','moppers'),
            'subtitle' => esc_html__('Select a Third color to use as overall text color.','moppers'),
            'default'  => '#999999',
        ),
        array(
            'id'       => 'general_settings_color_main_background_color',
            'type'     => 'color',
            'title'    => esc_html__('Body Background Color','moppers'),
            'subtitle' => esc_html__('Pick a color for body background color.','moppers'),
            'default'  => '#ffffff',
        ),
        array(
            'id'       => 'general_settings_color_main_link_all_color',
            'type'     => 'color',
            'title'    => esc_html__('Links Color','moppers'),
            'subtitle' => esc_html__('Select a color for all links.','moppers'),
            'default'  => '#6382f7',
        ),
        array(
            'id'       => 'general_settings_color_main_link_all_color_hover',
            'type'     => 'color',
            'title'    => esc_html__('Links Color on Hover','moppers'),
            'subtitle' => esc_html__('Select a color for all links on hover.','moppers'),
            'default'  => '#6382f7',
        ),
        array(
            'id'       => 'general_settings_color_main_gradient_1',
            'type'     => 'text',
            'title'    => esc_html__('Gradient Color 1','moppers'),
            'subtitle' => esc_html__('Select a Gradient color 1.','moppers'), 
            'default'  => 'linear-gradient(to right, #1c1958 0%, #6484f7 100%);',
        ),
        array(
            'id'       => 'general_settings_color_main_gradient_2',
            'type'     => 'text',
            'title'    => esc_html__('Gradient Color 2','moppers'),
            'subtitle' => esc_html__('Select a Gradient color 2.','moppers'), 
            'default'  => 'linear-gradient(225deg,#2899f9,#0059fc)',
        ),
        array(
            'id'       => 'general_settings_color_body_selection_color',
            'type'     => 'color',
            'title'    => esc_html__('Body Selection Color','moppers'),
            'subtitle' => esc_html__('Select a color for Body Selection.','moppers'),
            'default'  => '#6382f7',
        ),
    ),
));
Redux::setSection($opt_name, array(
    'title'      => esc_html__('Custom CSS & Scripts','moppers'),
    'id'         => 'general-settings-custom-css',
    'desc'             => esc_html__('Add custom CSS, Google Analytics and any other scripts.','moppers'),
    'subsection' => true,
    'fields'     => array(
        array(
            'id'      => 'general_custom_css_custom_css',
            'type'    => 'ace_editor',
            'title'   => esc_html__('Custom CSS','moppers'),
            'subtitle' => esc_html__('Allows you to add any custom CSS code if you need to customize styles','moppers'),
            'default' => '',
            'hint'    => array(
                'title'   => esc_attr__('Custom CSS','moppers'),
                'content' => esc_attr__('Allows you to add any custom CSS code if you need to customize styles','moppers'),
            ),
        ),
        array(
            'id'       => 'general_custom_google_analytics',
            'type'     => 'ace_editor',
            'title'    => esc_html__('Google Analytics','moppers'),
            'subtitle' => esc_html__('Please enter your Google Analytics tracking JS code here.','moppers'),
            'options' => array( 'minLines' => 20, 'maxLines' => 60 )
        ),
        array(
            'id'       => 'general_custom_google_webmaster_other',
            'type'     => 'ace_editor',
            'title'    => esc_html__('Google Webmaster / Other API','moppers'),
            'subtitle' => esc_html__('Please enter your Google Webmaster  or any other API code using &lt;script&gt; tag.','moppers'),
            'options' => array( 'minLines' => 20, 'maxLines' => 60 )
        ),
    ),
));
