<?php
/** 
 * The SlashCreative Redux Footer Settings section set  
 *
 * @author     SlashCreative
 * @copyright  (c) Copyright by SlashCreative
 * @link       http://slashcreative.co
 * @package    Moppers
 * @subpackage Core
 * @since      1.0.0
 */

// START Footer Settings Fields
Redux::setSection($opt_name, array(
    'title'            => esc_html__('Footer Settings','moppers'),
    'id'               => 'footer-settings',
    'desc'             => esc_html__('All Footer Settings related options are listed here.','moppers'),
    'customizer_width' => '400px',
    'icon'             => 'icons-switch',
));
Redux::setSection($opt_name, array(
    'title'      => esc_html__('Footer General Settings','moppers'),
    'id'         => 'footer-settings-general',
    'desc'       => esc_html__('General Footer Styling and Content.','moppers'),
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'footer-settings_logo',
            'type'     => 'media',
            'title'    => esc_html__('Footer Logo','moppers'),
            'subtitle' => __('Upload a logo to use in footer. ','moppers').'<i><strong>'.__('Optional','moppers').'</strong></i>',
            'desc'     => '',
        ),
        array(
            'id'    => 'footer_settings_logo_height',
            'type'  => 'text',
            'title' => esc_html__('Footer Logo Height','moppers'),
            'subtitle' => esc_html__('Change the height of the footer logo.','moppers'),
            'desc'  => '',
            'default'  => '40',
        ),
        array(
            'id'       => 'footer-settings-copyright-text',
            'type'     => 'textarea',
            'title'    => esc_html__('Description','moppers'),
            'subtitle' => esc_html__('You can enter a small description or custom HTML here to show inside footer meta.','moppers'),
            'desc'     => '',
        ),
        array(
            'id'       => 'footer-settings-copyright-down-text',
            'type'     => 'textarea',
            'title'    => esc_html__('Copyright Text','moppers'),
            'subtitle' => esc_html__('Enter any text to show along with copyright text.','moppers'),
            'desc'     => '',
        ),
        array(
            'id'       => 'footer-settings-copyright-text-default',
            'type'     => 'checkbox',
            'title'    => esc_html__('Hide Default Copyright Text','moppers'),
            'subtitle' => esc_html__('Enable this option to hide default copyright text.','moppers'),
            'desc'     => '',
            'default'  => false,
        ),
        array(
            'id'       => 'footer-settings-copyright-text-on-off',
            'type'     => 'checkbox',
            'title'    => esc_html__('Hide Whole Copyright Footer','moppers'),
            'subtitle' => esc_html__('Hide whole copyright footer or bottom footer.','moppers'),
            'desc'     => '',
            'default'  => false,
        ),
        array(
            'id'       => 'footer-settings-footer-backgroud-type',
            'type'     => 'select',
            'title'    => esc_html__('Footer Background','moppers'),
            'subtitle' => esc_html__('Select a background type for footer.','moppers'),
            'options'  => array(
                'image' => 'Image',
                'color' => 'Color',
            ),
            'default'  => 'color',
        ),
        array(
            'id'       => 'footer-settings-footer-background-image',
            'type'     => 'media',
            'title'    => esc_html__('Footer Background Image','moppers'),
            'subtitle' => esc_html__('Upload any image to use as footer background image.','moppers'),
            'desc'     => '',
            'required' => array('footer-settings-footer-backgroud-type', '=', 'image'),
        ),
        array(
            'id'            => 'footer-settings-background-image-overlay',
            'type'          => 'slider',
            'title'         => esc_html__('Footer Overlay Opacity','moppers'),
            'subtitle'      => esc_html__('Adjust the overlay opacity for background image.','moppers'),
            'desc'          => '',
            "default"       => 8,
            "min"           => 0,
            "step"          => 1,
            "max"           => 10,
            "resolution"    => 1,
            'display_value' => 'text',
            'required'      => array('footer-settings-footer-backgroud-type', '=', 'image'),
        ),
        array(
            'id'       => 'footer-settings-footer-background-image-background-color-overlay',
            'type'     => 'color',
            'title'    => esc_html__('Overlay Color','moppers'),
            'subtitle' => esc_html__('Change overlay color of footer background image.','moppers'),
            'required' => array('footer-settings-footer-backgroud-type', '=', 'image'),
        ),
        array(
            'id'       => 'footer-settings-footer-background-image-background-color',
            'type'     => 'color',
            'title'    => esc_html__('Main Footer Background Color','moppers'),
            'subtitle' => esc_html__('Pick a color to apply on main footer background.','moppers'),
            'required' => array('footer-settings-footer-backgroud-type', '=', 'color'),
            'default'  => '#1c1959', 
        ),
        array(
            'id'       => 'footer-settings-footer-background-image-background-color-copyright',
            'type'     => 'color',
            'title'    => esc_html__('Copyright Footer Background Color','moppers'),
            'subtitle' => esc_html__('Change the background color of copyright footer.','moppers'),
            'required' => array('footer-settings-footer-backgroud-type', '=', 'color'),
            'default'  => '#1c1959', 
        ),
        array(
            'id'       => 'footer-settings-footer-background-color-scheme',
            'type'     => 'select',
            'title'    => esc_html__('Footer Color Scheme','moppers'),
            'subtitle' => esc_html__('Select a color scheme for  footer content.','moppers'),
            'options'  => array(
                'dark'  => 'Dark',
                'light' => 'Light',
            ),
            'default'  => 'dark', 
        ),
        array(
            'id'       => 'footer-facebook-url',
            'type'     => 'checkbox',
            'title'    => esc_html__('Facebook Social Icon ','moppers'),
            'subtitle' => esc_html__('Select to add this icon to the footer.','moppers'),
            'default'  => false,
            'required' => array('social-media-facebook-url', '!=', ''),
        ),
        array(
            'id'       => 'footer-twitter-url',
            'type'     => 'checkbox',
            'title'    => esc_html__('Twitter Social Icon ','moppers'),
            'default'  => false,
            'subtitle' => esc_html__('Select to add this icon to the footer.','moppers'),
            'required' => array('social-media-twitter-url', '!=', ''),
        ),
        array(
            'id'       => 'footer-google-plus-url',
            'type'     => 'checkbox',
            'title'    => esc_html__('Google+ Social Icon ','moppers'),
            'default'  => false,
            'subtitle' => esc_html__('Select to add this icon to the footer.','moppers'),
            'required' => array('social-media-google-plus-url', '!=', ''),
        ),
        array(
            'id'       => 'footer-vimeo-url',
            'type'     => 'checkbox',
            'title'    => esc_html__('Vimeo Social Icon ','moppers'),
            'default'  => false,
            'subtitle' => esc_html__('Select to add this icon to the footer.','moppers'),
            'required' => array('social-media-vimeo-url', '!=', ''),
        ),
        array(
            'id'       => 'footer-dribbble-url',
            'type'     => 'checkbox',
            'title'    => esc_html__('Dribbble Social Icon ','moppers'),
            'default'  => false,
            'subtitle' => esc_html__('Select to add this icon to the footer.','moppers'),
            'required' => array('social-media-dribbble-url', '!=', ''),
        ),
        array(
            'id'       => 'footer-pinterest-url',
            'type'     => 'checkbox',
            'title'    => esc_html__('Pinterest Social Icon ','moppers'),
            'subtitle' => esc_html__('Select to add this icon to the footer.','moppers'),
            'default'  => false,
            'required' => array('social-media-pinterest-url', '!=', ''),
        ),
        array(
            'id'       => 'footer-youtube-url',
            'type'     => 'checkbox',
            'title'    => esc_html__('Youtube Social Icon ','moppers'),
            'subtitle' => esc_html__('Select to add this icon to the footer.','moppers'),
            'default'  => false,
            'required' => array('social-media-youtube-url', '!=', ''),
        ),
        array(
            'id'       => 'footer-tumblr-url',
            'type'     => 'checkbox',
            'title'    => esc_html__('Tumblr Social Icon ','moppers'),
            'subtitle' => esc_html__('Select to add this icon to the footer.','moppers'),
            'default'  => false,
            'required' => array('social-media-tumblr-url', '!=', ''),
        ),
        array(
            'id'       => 'footer-linkedin-url',
            'type'     => 'checkbox',
            'title'    => esc_html__('LinkedIn Social Icon ','moppers'),
            'subtitle' => esc_html__('Select to add this icon to the footer.','moppers'),
            'default'  => false,
            'required' => array('social-media-linkedin-url', '!=', ''),
        ),
        array(
            'id'       => 'footer-rss-url',
            'type'     => 'checkbox',
            'title'    => esc_html__('RSS Social Icon ','moppers'),
            'subtitle' => esc_html__('Select to add this icon to the footer.','moppers'),
            'default'  => false,
            'required' => array('social-media-rss-url', '!=', ''),
        ),
        array(
            'id'       => 'footer-behance-url',
            'type'     => 'checkbox',
            'title'    => esc_html__('Behance Social Icon ','moppers'),
            'subtitle' => esc_html__('Select to add this icon to the footer.','moppers'),
            'default'  => false,
            'required' => array('social-media-behance-url', '!=', ''),
        ),
        array(
            'id'       => 'footer-flickr-url',
            'type'     => 'checkbox',
            'title'    => esc_html__('Flickr Social Icon ','moppers'),
            'subtitle' => esc_html__('Select to add this icon to the footer.','moppers'),
            'default'  => false,
            'required' => array('social-media-flickr-url', '!=', ''),
        ),
        array(
            'id'       => 'footer-spotify-url',
            'type'     => 'checkbox',
            'title'    => esc_html__('Spotify Social Icon ','moppers'),
            'subtitle' => esc_html__('Select to add this icon to the footer.','moppers'),
            'default'  => false,
            'required' => array('social-media-spotify-url', '!=', ''),
        ),
        array(
            'id'       => 'footer-instagram-url',
            'type'     => 'checkbox',
            'title'    => esc_html__('Instagram Social Icon ','moppers'),
            'subtitle' => esc_html__('Select to add this icon to the footer.','moppers'),
            'default'  => false,
            'required' => array('social-media-instagram-url', '!=', ''),
        ),
        array(
            'id'       => 'footer-github-url',
            'type'     => 'checkbox',
            'title'    => esc_html__('GitHub Social Icon ','moppers'),
            'subtitle' => esc_html__('Select to add this icon to the footer.','moppers'),
            'default'  => false,
            'required' => array('social-media-github-url', '!=', ''),
        ),
        array(
            'id'       => 'footer-stackexchange-url',
            'type'     => 'checkbox',
            'title'    => esc_html__('StackExchange Social Icon ','moppers'),
            'subtitle' => esc_html__('Select to add this icon to the footer.','moppers'),
            'default'  => false,
            'required' => array('social-media-stackexchange-url', '!=', ''),
        ),
        array(
            'id'       => 'footer-soundcloud-url',
            'type'     => 'checkbox',
            'title'    => esc_html__('SoundCloud Social Icon ','moppers'),
            'subtitle' => esc_html__('Select to add this icon to the footer.','moppers'),
            'default'  => false,
            'required' => array('social-media-soundcloud-url', '!=', ''),
        ),
        array(
            'id'       => 'footer-vk-url',
            'type'     => 'checkbox',
            'title'    => esc_html__('VK Social Icon ','moppers'),
            'subtitle' => esc_html__('Select to add this icon to the footer.','moppers'),
            'default'  => false,
            'required' => array('social-media-vk-url', '!=', ''),
        ),
        array(
            'id'       => 'footer-vine-url',
            'type'     => 'checkbox',
            'title'    => esc_html__('Vine Social Icon ','moppers'),
            'subtitle' => esc_html__('Select to add this icon to the footer.','moppers'),
            'default'  => false,
            'required' => array('social-media-vine-url', '!=', ''),
        ),
        array(
            'id'       => 'footer-houzz-url',
            'type'     => 'checkbox',
            'title'    => esc_html__('Houzz Social Icon ','moppers'),
            'subtitle' => esc_html__('Select to add this icon to the footer.','moppers'),
            'default'  => false,
            'required' => array('social-media-houzz-url', '!=', ''),
        ),
        array(
            'id'       => 'footer-yelp-url',
            'type'     => 'checkbox',
            'title'    => esc_html__('Yelp Social Icon ','moppers'),
            'subtitle' => esc_html__('Select to add this icon to the footer.','moppers'),
            'default'  => false,
            'required' => array('social-media-yelp-url', '!=', ''),
        ),
        array(
            'id'       => 'footer-email-url',
            'type'     => 'checkbox',
            'title'    => esc_html__('Email Icon ','moppers'),
            'subtitle' => esc_html__('Select to add this icon to the footer.','moppers'),
            'default'  => false,
            'required' => array('social-media-email-url', '!=', ''),
        ),
        array(
            'id'       => 'footer-phone-url',
            'type'     => 'checkbox',
            'title'    => esc_html__('Phone Icon ','moppers'),
            'subtitle' => esc_html__('Select to add this icon to the footer.','moppers'),
            'default'  => false,
            'required' => array('social-media-phone-url', '!=', ''),
        ),
    ),
));
Redux::setSection($opt_name, array(
    'title'      => esc_html__('Layout Settings','moppers'),
    'id'         => 'footer-settings-layout',
    'desc'       => esc_html__('Setting for building the footer layout.','moppers'),
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'footer-settings-type',
            'type'     => 'image_select',
            'title'    => esc_html__('Footer type','moppers'),
            'subtitle' => esc_html__('Select a type of the footer.','moppers'),
            'desc'     => esc_html__('Default layout is 1 Column','moppers'),
            'options'  => array(
                'grid' => array(
                    'alt' => 'Grid',
                    'img' => SLCR_FRAMEWORK_URI . SCDS . 'redux/assets/img/footer-1.png',
                ),
                '2'    => array(
                    'alt' => 'Second',
                    'img' => SLCR_FRAMEWORK_URI . SCDS . 'redux/assets/img/footer-2.png',
                ),
                '3'    => array(
                    'alt' => 'third',
                    'img' => SLCR_FRAMEWORK_URI . SCDS . 'redux/assets/img/footer-3.png',
                ),
                '4'    => array(
                    'alt' => 'fourth',
                    'img' => SLCR_FRAMEWORK_URI . SCDS . 'redux/assets/img/footer-4.png',
                ),
                '5'    => array(
                    'alt' => 'fifth',
                    'img' => SLCR_FRAMEWORK_URI . SCDS . 'redux/assets/img/footer-5.png',
                ),
            ),
            'default'  => 'grid',
        ),
        array(
            'id'       => 'footer-settings-layout-type',
            'type'     => 'image_select',
            'title'    => esc_html__('Footer Layout','moppers'),
            'subtitle' => esc_html__('Select a layout for your footer.','moppers'),
            'desc'     => esc_html__('Default layout is 1 Column','moppers'),
            'options'  => array(
                '1_col' => array(
                    'alt' => '1 column',
                    'img' => SLCR_FRAMEWORK_URI . SCDS . 'redux/assets/img/footer-1c.png',
                ),
                '2_col' => array(
                    'alt' => '2 column',
                    'img' => SLCR_FRAMEWORK_URI . SCDS . 'redux/assets/img/footer-2c.png',
                ),
                '3_col' => array(
                    'alt' => '3 column',
                    'img' => SLCR_FRAMEWORK_URI . SCDS . 'redux/assets/img/footer-3c.png',
                ),
                '4_col' => array(
                    'alt' => '4 column',
                    'img' => SLCR_FRAMEWORK_URI . SCDS . 'redux/assets/img/footer-4c.png',
                ),
                '5_col' => array(
                    'alt' => '5 column',
                    'img' => SLCR_FRAMEWORK_URI . SCDS . 'redux/assets/img/footer-5c.png',
                ),
            ),
            'default'  => '4_col',
            'required' => array('footer-settings-type', '=', 'grid'),
        ),
        array(
            'id'       => 'footer-settings-layout-type-wider',
            'type'     => 'select',
            'title'    => esc_html__('Wider Column','moppers'),
            'subtitle' => esc_html__('Select a column to make it wider than others.','moppers'),
            'options'  => array(
                'none' => 'None',
                '1'    => 'First',
                '2'    => 'Second',
                '3'    => 'Third',
            ),
            'default'  => 'none',
            'required' => array('footer-settings-layout-type', '=', '3_col'),
        ),
        array(
            'id'       => 'footer-settings-layout-type-wider-4-col',
            'type'     => 'select',
            'title'    => esc_html__('Wider Column','moppers'),
            'subtitle' => esc_html__('Select a column to make it wider than others.','moppers'),
            'options'  => array(
                'none' => 'None',
                '1'    => 'First',
                '2'    => 'Second',
                '3'    => 'Third',
                '4'    => 'Fourth',
            ),
            'default'  => '4',
            'required' => array('footer-settings-layout-type', '=', '4_col'),
        ),
        array(
            'id'       => 'footer-settings-layout-type-wider-5-col',
            'type'     => 'select',
            'title'    => esc_html__('Wider Column','moppers'),
            'subtitle' => esc_html__('Select a column to make it wider than others.','moppers'),
            'options'  => array(
                'none' => 'None',
                '1'    => 'First',
                '2'    => 'Second',
                '3'    => 'Third',
                '4'    => 'Fourth',
                '5'    => 'Fifth',
            ),
            'default'  => 'none',
            'required' => array('footer-settings-layout-type', '=', '5_col'),
        ),
        array(
            'id'       => 'footer-settings-layout-widget-align',
            'type'     => 'select',
            'title'    => esc_html__('Widgets Content Align','moppers'),
            'subtitle' => __('Select an alignment for footer widgets.','moppers').'<br/> <i><b>'.__('It will effect whole widget, not text.','moppers').'</b></i>',
            'options'  => array(
                'left'   => 'Left',
                'right'  => 'Right',
                'center' => 'Center',
            ),
            'default'  => 'left',
            'required' => array('footer-settings-type', '=', 'grid'),
        ),
        array(
            'id'       => 'footer-settings-layout-content-align',
            'type'     => 'select',
            'title'    => esc_html__('Footer Content Align','moppers'),
            'subtitle' => esc_html__('Adjust the alignment of whole footer.','moppers'),
            'options'  => array(
                'left'   => 'Left',
                'right'  => 'Right',
                'center' => 'Center',
            ),
            'default'  => 'left',
            'required' => array('footer-settings-type', '=', '2'),
        ),
        array(
            'id'       => 'footer-settings-layout-footer-meta-position-2-col',
            'type'     => 'select',
            'title'    => esc_html__('Footer Meta Position','moppers'),
            'subtitle' => __('Select a column where you want to show footer meta. ','moppers').'<br /><i><strong>'.__('Example - Logo and description.','moppers').'</strong></i>',
            'options'  => array(
                '1' => 'First',
                '2' => 'Second',
            ),
            'default'  => '1',
            'required' => array('footer-settings-layout-type', '=', '2_col'),
        ),
        array(
            'id'       => 'footer-settings-layout-footer-meta-position-3-col',
            'type'     => 'select',
            'title'    => esc_html__('Footer Meta Position','moppers'),
            'subtitle' => __('Select a column where you want to show footer meta. ','moppers').'<br /><i><strong>'.__('Example - Logo and description.','moppers').'</strong></i>',
            'options'  => array(
                '1' => 'First',
                '2' => 'Second',
                '3' => 'Third',
            ),
            'default'  => '1',
            'required' => array('footer-settings-layout-type', '=', '3_col'),
        ),
        array(
            'id'       => 'footer-settings-layout-footer-meta-position-4-col',
            'type'     => 'select',
            'title'    => esc_html__('Footer Meta Position','moppers'),
            'subtitle' => __('Select a column where you want to show footer meta. ','moppers').'<br /><i><strong>'.__('Example - Logo and description.','moppers').'</strong></i>',
            'options'  => array(
                '1' => 'First',
                '2' => 'Second',
                '3' => 'Third',
                '4' => 'Fourth',
            ),
            'default'  => '1',
            'required' => array('footer-settings-layout-type', '=', '4_col'),
        ),
        array(
            'id'       => 'footer-settings-layout-footer-meta-position-5-col',
            'type'     => 'select',
            'title'    => esc_html__('Footer Meta Position','moppers'),
            'subtitle' => __('Select a column where you want to show footer meta. ','moppers').'<br /><i><strong>'.__('Example - Logo and description.','moppers').'</strong></i>',
            'options'  => array(
                '1' => 'First',
                '2' => 'Second',
                '3' => 'Third',
                '4' => 'Fourth',
                '5' => 'Fifth',
            ),
            'default'  => '1',
            'required' => array('footer-settings-layout-type', '=', '5_col'),
        ),
        array(
            'id'       => 'footer-settings-footer-main-footer-padding',
            'type'     => 'text',
            'title'    => esc_html__('Main Footer Padding','moppers'),
            'subtitle' => esc_html__('Enter Main Footer Padding. e.g. 30','moppers'),
            'desc'     => '',
            'default'  => '100',
        ),
        array(
            'id'       => 'footer-settings-footer-main-footer-padding-small',
            'type'     => 'text',
            'title'    => esc_html__('Copyright Footer Padding','moppers'),
            'subtitle' => esc_html__('Enter Copyright Footer Padding. e.g. 30','moppers'),
            'desc'     => '',
            'default'  => '20',
        ),
        array(
            'id'       => 'footer-settings-layout-footer-social-position',
            'type'     => 'select',
            'title'    => esc_html__('Social Icons Position','moppers'),
            'subtitle' => '',
            'options'  => array(
                'default' => 'Default',
                'bottom'  => 'Bottom',
            ),
            'default'  => 'default',
            'required' => array('footer-settings-type', '=', 'grid'),
        ),
        array(
            'id'       => 'footer-settings-footer-primary-icon-color',
            'type'     => 'color',
            'title'    => esc_html__('Social Icons Color','moppers'),
            'subtitle' => esc_html__('Change the color of social icons.','moppers'),
        ),
        array(
            'id'       => 'footer-settings-footer-primary-icon-color-hover',
            'type'     => 'color',
            'title'    => esc_html__('Social Icons Color - Hover','moppers'),
            'subtitle' => esc_html__('Change the color of social icons on hover.','moppers'),
        ),
        array(
            'id'       => 'footer-settings-footer-primary-icon-font-size',
            'type'     => 'text',
            'title'    => esc_html__('Social Icons Size','moppers'),
            'subtitle' => esc_html__('Enter Social Icons Size. e.g. 30','moppers'),
            'desc'     => '',
        ),
        array(
            'id'       => 'footer-settings-footer-primary-icon-spacing',
            'type'     => 'text',
            'title'    => esc_html__('Social Icons Spacing','moppers'),
            'subtitle' => esc_html__('Enter Social Icons Spacing . e.g. 10','moppers'),
            'desc'     => '',
        ),
    ),
));
Redux::setSection($opt_name, array(
    'title'      => esc_html__('Footer Typography','moppers'),
    'id'         => 'footer-settings-typography',
    'desc'       => esc_html__('Custom typography for footer elements and widgets.','moppers'),
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'header-navigation-settings-widget-text',
            'type'     => 'typography',
            'title'    => esc_html__('Widget  Text','moppers'),
            'subtitle' => esc_html__('Specify font properties for the Widget Text.','moppers'),
            'google'   => true,
        ),
        array(
            'id'       => 'header-navigation-settings-description',
            'type'     => 'typography',
            'title'    => esc_html__('Description Typography','moppers'),
            'subtitle' => esc_html__('Specify font properties for the Description Text.','moppers'),
            'google'   => true,
        ),
        array(
            'id'       => 'header-navigation-settings-copyright',
            'type'     => 'typography',
            'title'    => esc_html__('Copyright Typography','moppers'),
            'subtitle' => esc_html__('Specify font properties for the Copyright Text.','moppers'),
            'google'   => true,
        ),
        array(
            'id'       => 'header-navigation-settings-title',
            'type'     => 'typography',
            'title'    => esc_html__('Widget Title Typography','moppers'),
            'subtitle' => esc_html__('Specify font properties for the Widget Titles.','moppers'),
            'google'   => true,
        ),
        array(
            'id'       => 'header-navigation-settings-link',
            'type'     => 'typography',
            'title'    => esc_html__('Widget Links Typography','moppers'),
            'subtitle' => esc_html__('Specify font properties for the Widget Links.','moppers'),
            'google'   => true,
        ),
        array(
            'id'       => 'header-navigation-settings-menu-link',
            'type'     => 'typography',
            'title'    => esc_html__('Widget Menu Typography','moppers'),
            'subtitle' => esc_html__('Specify font properties for the Widget Menu.','moppers'),
            'google'   => true,
        ),
    ),
));