<?php 
/** 
 * The SlashCreative Acf Header Navigation Settings Group
 *
 * @author     SlashCreative
 * @copyright  (c) Copyright by SlashCreative
 * @link       http://slashcreative.co
 * @package    Moppers
 * @subpackage Core
 * @since      1.0.0
 */

// START Header Navigation Settings Fields Group
register_field_group(array(
    'id'         => 'acf_page_page_options_header',
    'key'         => 'group_acf_page_page_options_header',
    'title'      => esc_html__('Header Nav ','moppers'),
    'fields'     => array(
        array(
            'key'          => 'field_acf_page_header_custom_logo',
            'label'        => esc_html__('Custom Header Logo','moppers'),
            'name'         => 'acf_page_header_custom_logo',
            'type'         => 'image',
            'instructions' => esc_html__('Upload a logo here to use a custom logo in header navigation for this specific page.','moppers'),
            'save_format'  => 'array',
            'preview_size' => 'thumbnail',
            'library'      => 'all',
        ),
        array(
            'key'          => 'field_acf_page_header_sticky_custom_logo',
            'label'        => esc_html__('Custom sticky Header Logo','moppers'),
            'name'         => 'acf_page_header_sticky_custom_logo',
            'type'         => 'image',
            'instructions' => esc_html__('Upload a logo here to use a custom sticky logo in header navigation for this specific page.','moppers'),
            'save_format'  => 'array',
            'preview_size' => 'thumbnail',
            'library'      => 'all',
        ),
        array(
            'key'           => 'field_acf_page_header_logo_height',
            'label'         => esc_html__('Logo Height','moppers'),
            'name'          => 'acf_page_header_logo_height',
            'type'          => 'text',
            'instructions'  => esc_html__('Change the height of logo in header navigation for this specific page. "Example - 20px"','moppers'),
            'column_width'  => '',
            'default_value' => '',
            'placeholder'   => '',
            'prepend'       => '',
            'append'        => '',
            'formatting'    => 'html',
            'maxlength'     => '',
        ),
        array(
            'key'           => 'field_acf_page_header_logo_height_mobile',
            'label'         => esc_html__('Logo Height - Mobile','moppers'),
            'name'          => 'acf_page_header_logo_height_mobile',
            'type'          => 'text',
            'instructions'  => esc_html__('Change the height of logo on mobile view in header navigation for this specific page. "Example - 20px"','moppers'),
            'column_width'  => '',
            'default_value' => '',
            'placeholder'   => '',
            'prepend'       => '',
            'append'        => '',
            'formatting'    => 'html',
            'maxlength'     => '',
        ),
        array(
            'key'           => 'field_acf_page_header_header_height',
            'label'         => esc_html__('Header Height','moppers'),
            'name'          => 'acf_page_header_header_height',
            'type'          => 'text',
            'instructions'  => esc_html__('Change the height of header for this specific page.  "Example - 20px"','moppers'),
            'column_width'  => '',
            'default_value' => '',
            'placeholder'   => '',
            'prepend'       => '',
            'append'        => '',
            'formatting'    => 'html',
            'maxlength'     => '',
        ),
        array(
            'key'           => 'field_acf_page_header_header_height_mobile',
            'label'         => esc_html__('Header Height - Mobile','moppers'),
            'name'          => 'acf_page_header_header_height_mobile',
            'type'          => 'text',
            'instructions'  => esc_html__('Change the height of header on mobile view. "Example - 20px"','moppers'),
            'column_width'  => '',
            'default_value' => '',
            'placeholder'   => '',
            'prepend'       => '',
            'append'        => '',
            'formatting'    => 'html',
            'maxlength'     => '',
        ),
        array(
            'key'           => 'field_acf_page_header_header_sticky',
            'label'         => esc_html__('Sticky on Scroll','moppers'),
            'name'          => 'acf_page_header_header_sticky',
            'type'          => 'select',
            'instructions'  => esc_html__('Use this option to make header navigation sticked to top while scrolling.','moppers'),
            'choices'       => array(
                'default' => esc_html__('Default From Theme Options','moppers'),
                'true'    => esc_html__('On','moppers'),
                'none'    => esc_html__('Off','moppers'),
            ),
            'default_value' => 'default',
            'allow_null'    => 0,
            'multiple'      => 0,
        ),
        array(
            'key'               => 'field_acf_page_header_header_sticky_mobile',
            'label'             => esc_html__('Sticky on Scroll - Mobile','moppers'),
            'name'              => 'acf_page_header_header_sticky_mobile',
            'type'              => 'select',
            'instructions'      => esc_html__('Keep header sticky on mobile view.','moppers'),
            'choices'           => array(
                'default' => esc_html__('Default From Theme Options','moppers'),
                'true'    => esc_html__('On','moppers'),
                'none'    => esc_html__('Off','moppers'),
            ),
            'default_value'     => 'default',
            'allow_null'        => 0,
            'multiple'          => 0,
            'conditional_logic' => array(
                'status'   => 1,
                'rules'    => array(
                    array(
                        'field'    => 'field_acf_page_header_header_sticky',
                        'operator' => '==',
                        'value'    => 'true',
                    ),
                ),
                'allorany' => 'all',
            ),
        ),
        array(
            'key'           => 'field_acf_page_header_header_sticky_shadow',
            'label'         => esc_html__('Sticky Header Shadow','moppers'),
            'name'          => 'acf_page_header_header_sticky_shadow',
            'type'          => 'select',
            'instructions'  => esc_html__('Change the shadow depth for Sticky header navigation','moppers'),
            'choices'       => array(
                'default' => esc_html__('Default From Theme Options','moppers'),
                'shadow__none'    => esc_html__('None','moppers'),
                'shadow__sm'      => esc_html__('Small','moppers'),
                'shadow__md'      => esc_html__('Medium','moppers'),
                'shadow__lg'      => esc_html__('Large','moppers'),
            ),
            'default_value' => 'default',
            'allow_null'    => 0,
            'multiple'      => 0,
            'conditional_logic' => array(
                'status'   => 1,
                'rules'    => array(
                    array(
                        'field'    => 'field_acf_page_header_header_sticky',
                        'operator' => '==',
                        'value'    => 'true',
                    ),
                ),
                'allorany' => 'all',
            ),
        ),
        array(
            'key'           => 'field_acf_page_header_header_fixed',
            'label'         => esc_html__('Absolute Header','moppers'),
            'name'          => 'acf_page_header_header_fixed',
            'type'          => 'select',
            'instructions'  => esc_html__('Make the header absolute positioned.','moppers'),
            'choices'       => array(
                'default' => esc_html__('Default From Theme Options','moppers'),
                'fixed'   => esc_html__('On','moppers'),
                'none'    => esc_html__('Off','moppers'),
            ),
            'default_value' => 'default',
            'allow_null'    => 0,
            'multiple'      => 0,
        ),
        array(
            'key'           => 'field_acf_page_header_header_fixed_mobile',
            'label'         => esc_html__('Absolute Header - Mobile','moppers'),
            'name'          => 'acf_page_header_header_fixed_mobile',
            'type'          => 'select',
            'instructions'  => esc_html__('Keep this option on mobile view.','moppers'),
            'choices'       => array(
                'default' => esc_html__('Default From Theme Options','moppers'),
                'fixed'   => esc_html__('On','moppers'),
                'none'    => esc_html__('Off','moppers'),
            ),
            'default_value' => 'default',
            'allow_null'    => 0,
            'multiple'      => 0,
        ),
        array(
            'key'           => 'field_acf_page_header_header_shadow',
            'label'         => esc_html__('Header shadow','moppers'),
            'name'          => 'acf_page_header_header_shadow',
            'type'          => 'select',
            'instructions'  => esc_html__('Change the shadow depth for header navigation','moppers'),
            'choices'       => array(
                'default' => esc_html__('Default From Theme Options','moppers'),
                'none'    => esc_html__('None','moppers'),
                'small'   => esc_html__('Small','moppers'),
                'medium'  => esc_html__('Medium','moppers'),
                'large'   => esc_html__('Large','moppers'),
            ),
            'default_value' => 'default',
            'allow_null'    => 0,
            'multiple'      => 0,
        ),
        array(
            'key'           => 'field_acf_page_header_header_color',
            'label'         => esc_html__('Header Background Color','moppers'),
            'name'          => 'acf_page_header_header_color',
            'type'          => 'text',
            'instructions'  => esc_html__('Change the background color for header navigation. Paste HEX, RGB or Gradient CSS here. ','moppers'),
            'column_width'  => '',
            'default_value' => '',
            'placeholder'   => '',
            'prepend'       => '',
            'append'        => '',
            'formatting'    => 'html',
            'maxlength'     => '',
        ),
        array(
            'key'           => 'field_acf_page_header_header_color_sticky_header',
            'label'         => esc_html__('Sticky Header Background Color','moppers'),
            'name'          => 'acf_page_header_header_color_sticky_header',
            'type'          => 'text',
            'instructions'  => esc_html__('Change the background color for sticky header navigation. Paste HEX, RGB or Gradient CSS here. ','moppers'),
            'column_width'  => '',
            'default_value' => '',
            'placeholder'   => '',
            'prepend'       => '',
            'append'        => '',
            'formatting'    => 'html',
            'maxlength'     => '',
        ),
        array(
            'key'           => 'field_acf_page_header_header_scheme',
            'label'         => esc_html__('Header Content Scheme','moppers'),
            'name'          => 'acf_page_header_header_scheme',
            'type'          => 'select',
            'instructions'  => esc_html__('Change the content scheme for header navigation according to the background color selection.','moppers'),
            'choices'       => array(
                'default' => esc_html__('Default From Theme Options','moppers'),
                'dark'    => esc_html__('dark','moppers'),
                'light'   => esc_html__('light','moppers'),
            ),
            'default_value' => 'default',
            'allow_null'    => 0,
            'multiple'      => 0,
        ),
        array(
            'key'           => 'field_acf_page_header_header_sticky_scheme',
            'label'         => esc_html__('Sticky Header Content Scheme','moppers'),
            'name'          => 'acf_page_header_header_sticky_scheme',
            'type'          => 'select',
            'instructions'  => esc_html__('Change the content scheme for Sticky header navigation according to the background color selection.','moppers'),
            'choices'       => array(
                'default' => esc_html__('Default From Theme Options','moppers'),
                'dark'    => esc_html__('dark','moppers'),
                'light'   => esc_html__('light','moppers'),
            ),
            'default_value' => 'default',
            'allow_null'    => 0,
            'multiple'      => 0,
        ),

    ),
    'location'   => array(
        array(
            array(
                'param'    => 'post_type',
                'operator' => '==',
                'value'    => 'post',
                'order_no' => 0,
                'group_no' => 0,
            ),
        ),
        array(
            array(
                'param'    => 'post_type',
                'operator' => '==',
                'value'    => 'page',
                'order_no' => 0,
                'group_no' => 1,
            ),
        ), 
    ),
    'options'    => array(
        'position'       => 'normal',
        'layout'         => 'default',
        'hide_on_screen' => array(
        ),
    ),
    'menu_order' => 1500,
));