<?php
/** 
 * The SlashCreative VC Element 
 *
 * @author     SlashCreative
 * @copyright  (c) Copyright by SlashCreative
 * @link       http://slashcreative.co
 * @package    SC-CORE
 * @subpackage Core
 * @since      1.0.0
 * 
 */
if ( ! defined( 'ABSPATH' ) ) {
    die( '-1' );
}
return array(
    'name' => esc_html__( 'SC Tabs','sc-core' ),
    'base' => 'vc_tta_tabs',
    'icon' => 'icon-wpb-ui-tab-content',
    'is_container' => true,
    'show_settings_on_create' => false,
    'as_parent' => array(
        'only' => 'vc_tta_section',
    ),
    'category' => esc_html__( 'Content','sc-core'),
    'description' => esc_html__( 'Tabbed content','sc-core'),
    'params' => array(
        array(
            'type' => 'dropdown',
            'param_name' => 'tab_main_type',
            'value' => array(
                esc_html__( 'SC Tabs','sc-core' ) => 'slcr_tab', 
                esc_html__( 'vc Default','sc-core' ) => 'vc_default', 
            ),
            'heading' => esc_html__( 'Tab Type','sc-core'),
            'admin_label' => false,
            'description' => esc_html__( 'Select the tabs you want to use.','sc-core'),
            'group' => esc_html__('General','sc-core'), 
        ),
        array(
            'type' => 'dropdown',
            'param_name' => 'tab_style',
            'value' => array(
                esc_html__( 'Horizontal','sc-core' ) => '', 
                esc_html__( 'Vertical','sc-core') => 'tabbed_vertical', 
            ),
            'heading' => esc_html__( 'Style','sc-core'),
            'description' => esc_html__( 'Horizontal or Vertical?','sc-core'),
            'group' => esc_html__('General','sc-core'),
            'admin_label' => false,
            'dependency' => array(
                'element' =>'tab_main_type',
                'value' => 'slcr_tab',
            ), 
        ),
        array(
            'type' => 'dropdown',
            'param_name' => 'tab_align',
            'value' => array(
                esc_html__( 'Left','sc-core' ) => 'left', 
                esc_html__( 'Right','sc-core' ) => 'right', 
                esc_html__( 'Center','sc-core' ) => 'center', 
            ),
            'heading' => esc_html__( 'Tabs Alignment','sc-core'),
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc', 
            'description' => esc_html__( 'Adjust the alignment of inner tabs. Please do not use Center option if you are using Vertical tabs.','sc-core'),
            'admin_label' => false,
            'group' => esc_html__('General','sc-core'),
            'dependency' => array(
                'element' =>'tab_main_type',
                'value' => 'slcr_tab',
            ),  
        ),
        array(
            'type' => 'dropdown',
            'param_name' => 'tab_text_align',
            'value' => array(
                esc_html__( 'left','sc-core' ) => 'left', 
                esc_html__( 'center','sc-core' ) => 'center', 
                esc_html__( 'right','sc-core' ) => 'right', 
            ),
            'heading' => esc_html__( 'Tabs Text Alignment','sc-core' ),
            'admin_label' => false,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc', 
            'description' => esc_html__( 'Adjust the alignment of text in inner tabs.','sc-core'),
            'group' => esc_html__('General','sc-core'), 
            'dependency' => array(
                'element' =>'tab_main_type',
                'value' => 'slcr_tab',
            ), 
        ),
        array(
            'type' => 'checkbox', 
            'class' => 'custom_heading_element_use_theme_fonts',
            'heading' => esc_html__( 'Need Spacing Between Tabs?','sc-core'),
            'param_name' => 'tab_style_tabbed_sperator',
            'value' => array(
                            'Yes' =>'Yes', 
                        ),  
            'admin_label' => false, 
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc', 
            'weight' => 0,
            'group' => esc_html__('General','sc-core'), 
            'dependency' => array(
                'element' =>'tab_main_type',
                'value' => 'slcr_tab',
            ), 
        ),
        array(
            'type' => 'textfield', 
            'class' => 'title-class',
            'heading' => esc_html__( 'Spacing Size','sc-core' ), 
            'description' => esc_html__( 'Enter some value to add spacing between tabs. eg - 20px','sc-core'),
            'param_name' => 'tab_head_style_seprator_value',
            'value' => '', 
            'edit_field_class' => 'vc_column vc_col-sm-12 crum_vc',
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('General','sc-core'),
            'dependency' => array(
                'element' =>'tab_style_tabbed_sperator',
                'value' => 'Yes',
            ), 
        ), 
        array(
            'type' => 'checkbox', 
            'class' => 'custom_heading_element_use_theme_fonts',
            'heading' => esc_html__( 'Justify Tabs?','sc-core' ),
            'description' => esc_html__( 'Enable the option to Justify tabs according to the Header.','sc-core' ),
            'param_name' => 'tab_style_tabbed_justify',
            'value' => array(
                            'Yes' =>'Yes', 
                        ),  
            'admin_label' => false, 
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc', 
            'weight' => 0,
            'group' => esc_html__('General','sc-core'), 
            'dependency' => array(
                'element' =>'tab_main_type',
                'value' => 'slcr_tab',
            ), 
        ), 
        array(
            'type' => 'checkbox', 
            'class' => 'custom_heading_element_use_theme_fonts',
            'heading' => esc_html__( 'Custom Border For Header','sc-core'),
            'description' => esc_html__( 'Add custom border to the entire Header which is containing tabs.','sc-core'),
            'param_name' => 'tab_head_style_border_type',
            'value' => array(
                            'Yes' =>'Yes', 
                        ), 
            'description' => esc_html__( 'Leave this if you want to use no border style.','sc-core' ),
            'admin_label' => false, 
            'weight' => 0,
            'group' => esc_html__('General','sc-core'),
            'dependency' => array(
                'element' =>'tab_main_type',
                'value' => 'slcr_tab',
            ),  
        ), 
        array(
            'type' => 'textfield', 
            'class' => 'title-class',
            'heading' => esc_html__( 'Top Border','sc-core' ), 
            'param_name' => 'tab_head_style_top_border',
            'value' => '', 
            'edit_field_class' => 'vc_column vc_col-sm-3 crum_vc',
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('General','sc-core'),
            'dependency' => array(
                'element' =>'tab_head_style_border_type',
                'value' => 'Yes',
            ), 
        ), 
        array(
            'type' => 'textfield', 
            'class' => 'title-class',
            'heading' => esc_html__( 'Bottom Border','sc-core' ), 
            'param_name' => 'tab_head_style_bottom_border',
            'value' => '',
            'edit_field_class' => 'vc_column vc_col-sm-3 crum_vc', 
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('General','sc-core'),
            'dependency' => array(
                'element' =>'tab_head_style_border_type',
                'value' => 'Yes',
            ),  
        ), 
        array(
            'type' => 'textfield', 
            'class' => 'title-class',
            'heading' => esc_html__( 'Left Border','sc-core' ), 
            'param_name' => 'tab_head_style_left_border',
            'edit_field_class' => 'vc_column vc_col-sm-3 crum_vc',
            'value' => '', 
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('General','sc-core'), 
            'dependency' => array(
                'element' =>'tab_head_style_border_type',
                'value' => 'Yes',
            ), 
        ), 
        array(
            'type' => 'textfield', 
            'class' => 'title-class',
            'heading' => esc_html__( 'Right Border','sc-core' ), 
            'edit_field_class' => 'vc_column vc_col-sm-3 crum_vc',
            'param_name' => 'tab_head_style_right_border',
            'value' => '', 
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('General','sc-core'), 
            'dependency' => array(
                'element' =>'tab_head_style_border_type',
                'value' => 'Yes',
            ), 
        ), 
        array(
            'type' => 'colorpicker',
            'class' => 'title-class',
            'heading' => esc_html__( 'Border Color','sc-core'),
            'param_name' => 'tab_head_style_border_color', 
            'description' => esc_html__( 'Select border color for Header.','sc-core'),
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'admin_label' => false,
            'group' => esc_html__('General','sc-core'),
            'dependency' => array(
                'element' =>'tab_main_type',
                'value' => 'slcr_tab',
            ), 
             
         ), 
        array(
            'type' => 'textfield', 
            'class' => 'title-class',
            'heading' => esc_html__( 'Border Radius','sc-core'), 
            'param_name' => 'tab_head_style_border_radius',
            'description' => esc_html__( 'Change border radius of Header.','sc-core'),
            'value' => '', 
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('General','sc-core'), 
            'dependency' => array(
                'element' =>'tab_main_type',
                'value' => 'slcr_tab',
            ),  
        ),
        array(
            'type' => 'colorpicker',
            'class' => 'title-class',
            'heading' => esc_html__( 'Background Color','sc-core' ),
            'param_name' => 'tab_head_style_bg_color', 
            'description' => esc_html__( 'Change background color of entire Header.','sc-core'),
            'edit_field_class' => 'vc_column vc_col-sm-9 crum_vc',
            'group' => esc_html__('General','sc-core'), 
            'admin_label' => false,
            'dependency' => array(
                'element' =>'tab_main_type',
                'value' => 'slcr_tab',
            ), 
             
         ), 
        array(
            'type' => 'textfield',
            'holder' => 'Font Size',
            'class' => 'title-class',
            'heading' => esc_html__( 'Font Size of Title','sc-core'),
            'description' => esc_html__( 'Enter a custom font size for tab title. eg- 20px','sc-core' ),
            'param_name' => 'title_font_size',
            'value' => '', 
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('Header Title Styles','sc-core'),
            'dependency' => array(
                'element' =>'tab_main_type',
                'value' => 'slcr_tab',
            ),  
         ),
        array(
        'type' => 'dropdown',
        'heading' => esc_html__( 'Transform Text','sc-core'),
        'param_name' => 'title_text_transform',
        'class' => 'Title_Text_Transform', 
        'description' => esc_html__( 'Transform title text. eg( UPPERCASE, lowecase )','sc-core'), 
        'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc', 
        'group' => esc_html__('Header Title Styles','sc-core'),
        'admin_label' => false,
        'value' => array( 
            esc_html__( 'Default ','sc-core' ) => 'Default', 
            esc_html__( 'Uppercase ','sc-core' ) => 'uppercase', 
            esc_html__( 'Lowercase ','sc-core') => 'lowercase', 
        ), 
        'save_always' => true,
        'dependency' => array(
                'element' =>'tab_main_type',
                'value' => 'slcr_tab',
            ),   
        ),
        array(
        'type' => 'dropdown',
        'heading' => esc_html__( 'Text Alignment','sc-core'),
        'param_name' => 'title_text_aling',
        'class' => 'Title_Text_Transform', 
        'description' => esc_html__( 'Change the Alignment of text in tabs. eg( left, right )','sc-core'),
        'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc', 
        'group' => esc_html__('Header Title Styles','sc-core'),
        'admin_label' => false,
        'value' => array( 
            esc_html__( 'left ','sc-core' ) => 'left', 
            esc_html__( 'right ','sc-core' ) => 'right', 
            esc_html__( 'center ','sc-core' ) => 'center', 
        ), 
        'save_always' => true,  
        'dependency' => array(
                'element' =>'tab_main_type',
                'value' => 'slcr_tab',
            ), 
        ),

        array(
            'type' => 'textfield',
            'holder' => 'Font Padding',
            'class' => 'title-class',
            'heading' => esc_html__( 'Title Padding Top & Bottom','sc-core'),
            'description' => esc_html__( 'Enter custom Top and Bottom padding. eg(10px) ','sc-core' ),
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc', 
            'param_name' => 'title_padding_top',
            'value' => '', 
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('Header Title Styles','sc-core'), 
            'dependency' => array(
                'element' =>'tab_main_type',
                'value' => 'slcr_tab',
            ), 
        ),
        array(
            'type' => 'textfield',
            'holder' => 'Font Padding  ',
            'class' => 'title-class',
            'heading' => esc_html__( 'Title Padding Left & Right','sc-core' ),
            'description' => esc_html__( 'Enter custom Left and Right padding. eg(10px)','sc-core'),
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc', 
            'param_name' => 'title_padding_left',
            'value' => '', 
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('Header Title Styles','sc-core'), 
            'dependency' => array(
                'element' =>'tab_main_type',
                'value' => 'slcr_tab',
            ), 
        ), 
        array(
            'type' => 'checkbox', 
            'class' => 'custom_heading_element_use_theme_fonts',
            'heading' => esc_html__( 'Use custom Google font ?','sc-core'),
            'param_name' => 'title_use_theme_fonts',
            'value' => array(
                            'Yes' =>'Yes', 
                        ), 
            'description' => esc_html__( 'Leave this if you want to use default theme font.','sc-core'),
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc', 
            'admin_label' => false, 
            'weight' => 0,
            'group' => esc_html__('Header Title Styles','sc-core'), 
            'dependency' => array(
                'element' =>'tab_main_type',
                'value' => 'slcr_tab',
            ), 
        ), 
        array(
            'type' => 'google_fonts',
            'class' => 'title-class',
            'heading' => esc_html__( 'Change Title Typography','sc-core'),
            'param_name' => 'title_google_font_select',
            'settings' => array(
                'fields' => array(
                    'font_family_description' => esc_html__( 'Select Font Family.','sc-core' ),
                    'font_style_description' => esc_html__( 'Select Font Style.','sc-core' ),
                ),
            ), 
            'description' => esc_html__( 'Select Google Font from the list.','sc-core' ),
            'group' => esc_html__('Header Title Styles','sc-core'),
            'dependency' => array(
                'element' =>'title_use_theme_fonts',
                'value' => 'Yes',
            ),
        ), 
        array(
        'type' => 'dropdown',
        'heading' => esc_html__('Title Font Weights','sc-core') ,
        'param_name' => 'title_font_weights_class',
        'class' => 'title-class',
        'admin_label' => false,
        'group' => esc_html__('Header Title Styles','sc-core'),
        'value' => array(
            esc_html__('font-400','sc-core') => 'font-400',
            esc_html__('font-100','sc-core') => 'font-100',
            esc_html__('font-300','sc-core') => 'font-300',
            esc_html__('font-500','sc-core') => 'font-500',
            esc_html__('font-600','sc-core') => 'font-600',
            esc_html__('font-700','sc-core') => 'font-700',
            esc_html__('font-800','sc-core') => 'font-800',
            esc_html__('font-900','sc-core') => 'font-900',
        ) ,
        'save_always' => true,
        'description' => esc_html__('Select Font Weights of Title  ','sc-core') ,
        'dependency' => array(
            'element' => 'tab_main_type',
            'value' => array(
                'slcr_tab'
            ) ,
        ) ,
    ) ,
        array(
            'type' => 'colorpicker',
            'class' => 'title-class',
            'heading' => esc_html__( 'Title Font Color','sc-core'),
            'param_name' => 'title_font_color', 
            'description' => esc_html__( 'Change font color for title','sc-core' ),
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc', 
            'group' => esc_html__('Header Title Styles','sc-core'),
            'admin_label' => false,
             'dependency' => array(
                'element' =>'tab_main_type',
                'value' => 'slcr_tab',
            ), 
         ), 
        array(
            'type' => 'colorpicker',
            'class' => 'title-class',
            'heading' => esc_html__( 'Tab Background Color','sc-core'),
            'param_name' => 'tab_style_color', 
            'description' => esc_html__( 'Select the background color for tabs in normal state. ( Active and Hover Color can be changed in Active and Hover Styles tab. )','sc-core'),
            'group' => esc_html__('Tab Styles','sc-core'),
            'admin_label' => false,
             'dependency' => array(
                'element' =>'tab_main_type',
                'value' => 'slcr_tab',
            ), 
         ), 
        array(
            'type' => 'checkbox', 
            'class' => 'custom_heading_element_use_theme_fonts',
            'heading' => esc_html__( 'Custom Border','sc-core'),
            'param_name' => 'tab_style_border_type',
            'value' => array(
                            'Yes' =>'Yes', 
                        ), 
            'description' => esc_html__( 'Use this feature to create custom borders around tabs.','sc-core' ),
            'admin_label' => false, 
            'weight' => 0,
            'group' => esc_html__('Tab Styles','sc-core'), 
            'dependency' => array(
                'element' =>'tab_main_type',
                'value' => 'slcr_tab',
            ), 
        ), 
        array(
            'type' => 'textfield', 
            'class' => 'title-class',
            'heading' => esc_html__( 'Top Border','sc-core' ), 
            'param_name' => 'tab_style_top_border',
            'description' => esc_html__( 'Example - 1px','sc-core' ),
            'value' => '', 
            'edit_field_class' => 'vc_column vc_col-sm-3 crum_vc',
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('Tab Styles','sc-core'),
            'dependency' => array(
                'element' =>'tab_style_border_type',
                'value' => 'Yes',
            ), 
        ), 
        array(
            'type' => 'textfield', 
            'class' => 'title-class',
            'heading' => esc_html__( 'Bottom Border','sc-core'), 
            'param_name' => 'tab_style_bottom_border',
            'description' => esc_html__( 'Example - 1px','sc-core' ),
            'value' => '',
            'edit_field_class' => 'vc_column vc_col-sm-3 crum_vc', 
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('Tab Styles','sc-core'),
            'dependency' => array(
                'element' =>'tab_style_border_type',
                'value' => 'Yes',
            ),  
        ), 
        array(
            'type' => 'textfield', 
            'class' => 'title-class',
            'heading' => esc_html__( 'Left Border','sc-core'), 
            'param_name' => 'tab_style_left_border',
            'description' => esc_html__( 'Example - 1px','sc-core' ),
            'edit_field_class' => 'vc_column vc_col-sm-3 crum_vc',
            'value' => '', 
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('Tab Styles','sc-core'), 
            'dependency' => array(
                'element' =>'tab_style_border_type',
                'value' => 'Yes',
            ), 
        ), 
        array(
            'type' => 'textfield', 
            'class' => 'title-class',
            'heading' => esc_html__( 'Right Border','sc-core' ),
            'description' => esc_html__( 'Example - 1px','sc-core' ),
            'edit_field_class' => 'vc_column vc_col-sm-3 crum_vc',
            'param_name' => 'tab_style_right_border',
            'value' => '', 
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('Tab Styles','sc-core'), 
            'dependency' => array(
                'element' =>'tab_style_border_type',
                'value' => 'Yes',
            ), 
        ), 
        array(
            'type' => 'colorpicker',
            'class' => 'title-class',
            'heading' => esc_html__( 'Border Color','sc-core'),
            'param_name' => 'tab_style_border_color', 
            'description' => esc_html__( 'Change the color of border.','sc-core'),
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'admin_label' => false,
            'group' => esc_html__('Tab Styles','sc-core'),
            'dependency' => array(
                'element' =>'tab_main_type',
                'value' => 'slcr_tab',
            ), 
             
         ), 
        array(
            'type' => 'textfield', 
            'class' => 'title-class',
            'heading' => esc_html__( 'Border Radius','sc-core' ), 
            'param_name' => 'tab_style_border_radius',
            'value' => '', 
            'description' => esc_html__( 'Change the border radius','sc-core' ),
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('Tab Styles','sc-core'),
            'dependency' => array(
                'element' =>'tab_main_type',
                'value' => 'slcr_tab',
            ),   
        ), 
        array(
            'type' => 'checkbox', 
            'class' => 'custom_heading_element_rounded_tab',
            'heading' => esc_html__( 'Rounded Tab','sc-core'),
            'param_name' => 'tab_style_border_element_rounded_tab',
            'value' => array(
                            'Yes' =>'Yes', 
                        ), 
            'description' => esc_html__( 'Give custom border radius to the first and last tabs to make it look rounded from edges.','sc-core'),
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc', 
            'admin_label' => false,  
            'group' => esc_html__('Tab Styles','sc-core'), 
            'dependency' => array(
                'element' =>'tab_main_type',
                'value' => 'slcr_tab',
            ), 
        ), 
        array(
            'type' => 'textfield', 
            'class' => 'title-class',
            'heading' => esc_html__( 'Rounded Tab Value','sc-core' ), 
            'param_name' => 'tab_style_border_rounded_tab_radius',
            'value' => '', 
            'description' => esc_html__( 'Give the first and last tabs rounded value.','sc-core' ),
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc', 
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('Tab Styles','sc-core'),
            'dependency' => array(
                'element' =>'tab_style_border_element_rounded_tab',
                'value' => 'Yes',
            ),
        ),
         array(
            'type' => 'colorpicker',
            'class' => 'title-class',
            'heading' => esc_html__( 'Border Color on Hover','sc-core'),
            'param_name' => 'hover_tab_style_border_color', 
            'description' => esc_html__( 'Change the border color on mouseover tab.','sc-core'),
            'edit_field_class' => 'vc_column vc_col-sm-4 crum_vc',
            'group' => esc_html__('Active & Hover Styles','sc-core'),
            'admin_label' => false,
            'dependency' => array(
                'element' =>'tab_main_type',
                'value' => 'slcr_tab',
            ), 
             
         ), 
          array(
            'type' => 'colorpicker',
            'class' => 'title-class',
            'heading' => esc_html__( 'Title Color on Hover','sc-core' ),
            'param_name' => 'hover_title_font_color', 
            'description' => esc_html__( 'Change the title color on mouseover tab.','sc-core'),
            'edit_field_class' => 'vc_column vc_col-sm-4 crum_vc',
            'group' => esc_html__('Active & Hover Styles','sc-core'),
            'admin_label' => false,
            'dependency' => array(
                'element' =>'tab_main_type',
                'value' => 'slcr_tab',
            ), 
             
         ), 
        array(
            'type' => 'colorpicker',
            'class' => 'title-class',
            'heading' => esc_html__( 'Tab Background on Hover','sc-core'),
            'param_name' => 'hover_tab_style_color', 
            'description' => esc_html__( 'Change the background color on mouseover tab.','sc-core'),
            'edit_field_class' => 'vc_column vc_col-sm-4 crum_vc',
            'group' => esc_html__('Active & Hover Styles','sc-core'),
            'admin_label' => false,
            'dependency' => array(
                'element' =>'tab_main_type',
                'value' => 'slcr_tab',
            ), 
             
         ), 
        array(
            'type' => 'colorpicker',
            'class' => 'title-class',
            'heading' => esc_html__( 'Border Color On Active','sc-core'),
            'param_name' => 'active_tab_style_border_color', 
            'description' => esc_html__( 'Change the background color when tab is active.','sc-core'),
            'edit_field_class' => 'vc_column vc_col-sm-4 crum_vc',
            'group' => esc_html__('Active & Hover Styles','sc-core'),
            'admin_label' => false,
            'dependency' => array(
                'element' =>'tab_main_type',
                'value' => 'slcr_tab',
            ), 
             
         ), 
          array(
            'type' => 'colorpicker',
            'class' => 'title-class',
            'heading' => esc_html__( 'Title Color On Active','sc-core'),
            'param_name' => 'active_title_font_color', 
            'description' => esc_html__( 'Change the title color when tab is active.','sc-core'),
            'edit_field_class' => 'vc_column vc_col-sm-4 crum_vc',
            'group' => esc_html__('Active & Hover Styles','sc-core'),
            'admin_label' => false,
            'dependency' => array(
                'element' =>'tab_main_type',
                'value' => 'slcr_tab',
            ), 
             
         ), 
        array(
            'type' => 'colorpicker',
            'class' => 'title-class',
            'heading' => esc_html__( 'Tab Background on Active','sc-core' ),
            'param_name' => 'active_tab_style_color', 
            'description' => esc_html__( 'Change the background color of tab when it is active.','sc-core' ),
            'edit_field_class' => 'vc_column vc_col-sm-4 crum_vc',
            'group' => esc_html__('Active & Hover Styles','sc-core'),
            'admin_label' => false,
            'dependency' => array(
                'element' =>'tab_main_type',
                'value' => 'slcr_tab',
            ), 
             
         ),
        array(
            'type' => 'dropdown',
            'param_name' => 'icon_style',
            'value' => array(
                esc_html__( 'Inline icon','sc-core' ) => 'inline-icon', 
                esc_html__( 'Large icon','sc-core' ) => 'large-icon', 
            ),
            'heading' => esc_html__( 'Icon Style','sc-core'),
            'description' => esc_html__( 'Select Inline option for using icon in same line as text or select Large Icon to use large sized icon on the top of tab title.','sc-core' ), 
            'group' => esc_html__('Icon Styles','sc-core'),
            'admin_label' => false,
            'dependency' => array(
                'element' =>'tab_main_type',
                'value' => 'slcr_tab',
            ), 
        ),
        array(
            'type' => 'textfield', 
            'class' => 'title-class',
            'heading' => esc_html__( 'Icon Size','sc-core' ), 
            'param_name' => 'tab_style_icon_size',
            'value' => '', 
            'description' => esc_html__( 'Enter some value to use custom size for icon. Example - 20px','sc-core' ), 
            'edit_field_class' => 'vc_column vc_col-sm-4 crum_vc',
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('Icon Styles','sc-core'),
            'dependency' => array(
                'element' =>'tab_main_type',
                'value' => 'slcr_tab',
            ),   
        ), 
        array(
            'type' => 'textfield', 
            'class' => 'title-class',
            'heading' => esc_html__( 'Icon Padding Left','sc-core'), 
            'param_name' => 'tab_style_icon_padding_left',
            'value' => '', 
            'description' => esc_html__( 'Enter custom padding on left side of icon. *Applicable on Inline Icon Style only','sc-core' ), 
            'edit_field_class' => 'vc_column vc_col-sm-4 crum_vc',
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('Icon Styles','sc-core'),
            'dependency' => array(
                'element' =>'tab_main_type',
                'value' => 'slcr_tab',
            ),   
        ), 
        array(
            'type' => 'textfield', 
            'class' => 'title-class',
            'heading' => esc_html__( 'Icon Padding Right','sc-core' ), 
            'param_name' => 'tab_style_icon_padding_right',
            'description' => esc_html__( 'Enter custom padding on right side of icon. *Applicable on Inline Icon Style only','sc-core' ), 
            'value' => '', 
            'edit_field_class' => 'vc_column vc_col-sm-4 crum_vc',
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('Icon Styles','sc-core'),
            'dependency' => array(
                'element' =>'tab_main_type',
                'value' => 'slcr_tab',
            ),   
        ),
        array(
            'type' => 'colorpicker',
            'class' => 'title-class',
            'heading' => esc_html__( 'Custom Icon Color','sc-core' ),
            'param_name' => 'icon_style_color', 
            'description' => esc_html__( 'Select a color to use a custom color for icon. Default color is same as the Tab Title Color.','sc-core' ),
            'edit_field_class' => 'vc_column vc_col-sm-4 crum_vc',
            'group' => esc_html__('Icon Styles','sc-core'),
            'admin_label' => false,
            'dependency' => array(
                'element' =>'tab_main_type',
                'value' => 'slcr_tab',
            ), 
             
         ),
        array(
            'type' => 'colorpicker',
            'class' => 'title-class',
            'heading' => esc_html__( 'Icon Color on Active','sc-core'),
            'param_name' => 'active_icon_style_color', 
            'description' => esc_html__( 'Change the color of icon when tab is active.','sc-core'),
            'edit_field_class' => 'vc_column vc_col-sm-4 crum_vc',
            'group' => esc_html__('Icon Styles','sc-core'),
            'admin_label' => false,
            'dependency' => array(
                'element' =>'tab_main_type',
                'value' => 'slcr_tab',
            ), 
             
         ),
        array(
            'type' => 'colorpicker',
            'class' => 'title-class',
            'heading' => esc_html__( 'Icon Color on Hover','sc-core'),
            'param_name' => 'hover_icon_style_color', 
            'description' => esc_html__( 'Change the color of icon when tab is hovered.','sc-core' ),
            'edit_field_class' => 'vc_column vc_col-sm-4 crum_vc',
            'group' => esc_html__('Icon Styles','sc-core'),
            'admin_label' => false,
            'dependency' => array(
                'element' =>'tab_main_type',
                'value' => 'slcr_tab',
            ), 
             
         ),


        array(
            'type' => 'textfield',
            'param_name' => 'title',
            'heading' => esc_html__( 'Widget title','sc-core'),
            'description' => esc_html__( 'Enter text used as widget title (Note: located above content element).','sc-core' ),
            'group' => esc_html__('General','sc-core'), 
            'admin_label' => false,
            'dependency' => array(
                'element' =>'tab_main_type',
                'value' => 'vc_default',
            ), 
        ),
        array(
            'type' => 'dropdown',
            'param_name' => 'style',
            'value' => array(
                esc_html__( 'Classic','sc-core' ) => 'classic',
                esc_html__( 'Modern','sc-core' ) => 'modern',
                esc_html__( 'Flat','sc-core' ) => 'flat',
                esc_html__( 'Outline','sc-core' ) => 'outline',
            ),
            'heading' => esc_html__( 'Style','sc-core'),
            'group' => esc_html__('General','sc-core'), 
            'admin_label' => false,
            'description' => esc_html__( 'Select tabs display style.','sc-core' ),
            'dependency' => array(
                'element' =>'tab_main_type',
                'value' => 'vc_default',
            ),
        ),
        array(
            'type' => 'dropdown',
            'param_name' => 'shape',
            'value' => array(
                esc_html__( 'Rounded','sc-core' ) => 'rounded',
                esc_html__( 'Square','sc-core' ) => 'square',
                esc_html__( 'Round','sc-core') => 'round',
            ),
            'heading' => esc_html__( 'Shape','sc-core'),
            'group' => esc_html__('General','sc-core'), 
            'admin_label' => false,
            'description' => esc_html__( 'Select tabs shape.','sc-core'),
            'dependency' => array(
                'element' =>'tab_main_type',
                'value' => 'vc_default',
            ),
        ),
        array(
            'type' => 'dropdown',
            'param_name' => 'color',
            'heading' => esc_html__( 'Color','sc-core' ),
            'description' => esc_html__( 'Select tabs color.','sc-core' ),
            'value' => vc_get_shared( 'colors-dashed' ),
            'std' => 'grey',
            'group' => esc_html__('General','sc-core'), 
            'admin_label' => false,
            'param_holder_class' => 'vc_colored-dropdown',
            'dependency' => array(
                'element' =>'tab_main_type',
                'value' => 'vc_default',
            ),
        ),
        array(
            'type' => 'checkbox',
            'param_name' => 'no_fill_content_area',
            'heading' => esc_html__( 'Do not fill content area?','sc-core' ),
            'description' => esc_html__( 'Do not fill content area with color.','sc-core' ),
            'group' => esc_html__('General','sc-core'), 
            'admin_label' => false,
            'dependency' => array(
                'element' =>'tab_main_type',
                'value' => 'vc_default',
            ),
        ),
        array(
            'type' => 'dropdown',
            'param_name' => 'spacing',
            'value' => array(
                esc_html__( 'None','sc-core' ) => '',
                esc_html__( '1px','sc-core' ) => '1',
                esc_html__( '2px','sc-core' ) => '2',
                esc_html__( '3px','sc-core' ) => '3',
                esc_html__( '4px','sc-core' ) => '4',
                esc_html__( '5px','sc-core' ) => '5',
                esc_html__( '10px','sc-core' ) => '10',
                esc_html__( '15px','sc-core' ) => '15',
                esc_html__( '20px','sc-core' ) => '20',
                esc_html__( '25px','sc-core' ) => '25',
                esc_html__( '30px','sc-core' ) => '30',
                esc_html__( '35px','sc-core' ) => '35',
            ),
            'heading' => esc_html__( 'Spacing','sc-core' ),
            'description' => esc_html__( 'Select tabs spacing.','sc-core' ),
            'group' => esc_html__('General','sc-core'),
            'admin_label' => false,
            'std' => '1',
            'dependency' => array(
                'element' =>'tab_main_type',
                'value' => 'vc_default',
            ),
        ),
        array(
            'type' => 'dropdown',
            'param_name' => 'gap',
            'value' => array(
                esc_html__( 'None','sc-core' ) => '',
                esc_html__( '1px','sc-core' ) => '1',
                esc_html__( '2px','sc-core' ) => '2',
                esc_html__( '3px','sc-core' ) => '3',
                esc_html__( '4px','sc-core' ) => '4',
                esc_html__( '5px','sc-core' ) => '5',
                esc_html__( '10px','sc-core' ) => '10',
                esc_html__( '15px','sc-core' ) => '15',
                esc_html__( '20px','sc-core' ) => '20',
                esc_html__( '25px','sc-core' ) => '25',
                esc_html__( '30px','sc-core' ) => '30',
                esc_html__( '35px','sc-core' ) => '35',
            ),
            'heading' => esc_html__( 'Gap','sc-core'),
            'description' => esc_html__( 'Select tabs gap.','sc-core'),
            'group' => esc_html__('General','sc-core'),
            'admin_label' => false, 
            'dependency' => array(
                'element' =>'tab_main_type',
                'value' => 'vc_default',
            ),
        ),
        array(
            'type' => 'dropdown',
            'param_name' => 'tab_position',
            'value' => array(
                esc_html__( 'Top','sc-core' ) => 'top',
                esc_html__( 'Bottom','sc-core' ) => 'bottom',
            ),
            'heading' => esc_html__( 'Position','sc-core' ),
            'description' => esc_html__( 'Select tabs navigation position.','sc-core'),
            'admin_label' => false,
            'group' => esc_html__('General','sc-core'), 
            'dependency' => array(
                'element' =>'tab_main_type',
                'value' => 'vc_default',
            ),
        ),
        array(
            'type' => 'dropdown',
            'param_name' => 'alignment',
            'value' => array(
                esc_html__( 'Left','sc-core' ) => 'left',
                esc_html__( 'Right','sc-core' ) => 'right',
                esc_html__( 'Center','sc-core' ) => 'center',
            ),
            'heading' => esc_html__( 'Alignment','sc-core' ),
            'description' => esc_html__( 'Select tabs section title alignment.','sc-core'),
            'admin_label' => false,
            'group' => esc_html__('General','sc-core'), 
            'dependency' => array(
                'element' =>'tab_main_type',
                'value' => 'vc_default',
            ),
        ),
        array(
            'type' => 'dropdown',
            'param_name' => 'autoplay',
            'value' => array(
                esc_html__( 'None','sc-core' ) => 'none',
                esc_html__( '1','sc-core' ) => '1',
                esc_html__( '2','sc-core' ) => '2',
                esc_html__( '3','sc-core' ) => '3',
                esc_html__( '4','sc-core' ) => '4',
                esc_html__( '5','sc-core' ) => '5',
                esc_html__( '10','sc-core' ) => '10',
                esc_html__( '20','sc-core' ) => '20',
                esc_html__( '30','sc-core' ) => '30',
                esc_html__( '40','sc-core' ) => '40',
                esc_html__( '50','sc-core' ) => '50',
                esc_html__( '60','sc-core' ) => '60',
            ),
            'std' => 'none',
            'heading' => esc_html__( 'Autoplay','sc-core'),
            'description' => esc_html__( 'Select auto rotate for tabs in seconds (Note: disabled by default).','sc-core' ),
            'group' => esc_html__('General','sc-core'), 
            'admin_label' => false,
            'dependency' => array(
                'element' =>'tab_main_type',
                'value' => 'vc_default',
            ),
        ),
        array(
            'type' => 'textfield',
            'param_name' => 'active_section',
            'heading' => esc_html__( 'Active section','sc-core'),
            'value' => 1,
            'description' => esc_html__( 'Enter active section number (Note: to have all sections closed on initial load enter non-existing number).','sc-core' ),
            'group' => esc_html__('General','sc-core'), 
            'admin_label' => false,
            'dependency' => array(
                'element' =>'tab_main_type',
                'value' => 'vc_default',
            ),
        ),
        array(
            'type' => 'dropdown',
            'param_name' => 'pagination_style',
            'value' => array(
                esc_html__( 'None','sc-core' ) => '',
                esc_html__( 'Square Dots','sc-core' ) => 'outline-square',
                esc_html__( 'Radio Dots','sc-core' ) => 'outline-round',
                esc_html__( 'Point Dots','sc-core') => 'flat-round',
                esc_html__( 'Fill Square Dots','sc-core' ) => 'flat-square',
                esc_html__( 'Rounded Fill Square Dots','sc-core' ) => 'flat-rounded',
            ),
            'heading' => esc_html__( 'Pagination style','sc-core' ),
            'description' => esc_html__( 'Select pagination style.','sc-core'),
            'group' => esc_html__('General','sc-core'),
            'admin_label' => false, 
            'dependency' => array(
                'element' =>'tab_main_type',
                'value' => 'vc_default',
            ),
        ),
        array(
            'type' => 'dropdown',
            'param_name' => 'pagination_color',
            'value' => vc_get_shared( 'colors-dashed' ),
            'heading' => esc_html__( 'Pagination color','sc-core'),
            'description' => esc_html__( 'Select pagination color.','sc-core' ),
            'param_holder_class' => 'vc_colored-dropdown',
            'std' => 'grey',
            'group' => esc_html__('General','sc-core'),
            'admin_label' => false, 
            'dependency' => array(
                'element' => 'pagination_style',
                'not_empty' => true,
            ),
        ),
        array(
            'type' => 'animation_style',
            'param_name' => 'css_animation',
            'admin_label' => false, 
            'heading' => esc_html__( 'CSS Animation','sc-core' ), 
            'group' => esc_html__('General','sc-core'), 
        ),  
        array(
            'type' => 'el_id',
            'heading' => esc_html__( 'Element ID','sc-core' ),
            'param_name' => 'el_id',
            'admin_label' => false,
            'description' => sprintf(__('Enter element ID (Note: make sure it is unique and valid according to ','sc-core').'<a href="%s" target="_blank">'.__('w3c specification','sc-core').'</a>).' , 'http://www.w3schools.com/tags/att_global_id.asp'),
            'group' => esc_html__('General','sc-core'), 
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Extra class name','sc-core' ),
            'param_name' => 'el_class',
            'admin_label' => false,
            'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.','sc-core' ),
            'group' => esc_html__('General','sc-core'), 
        ),
        array(
            'type' => 'css_editor',
            'heading' => esc_html__( 'CSS box','sc-core' ),
            'param_name' => 'css',
            'admin_label' => false,
            'group' => esc_html__( 'Design Options','sc-core'),
        ),
    ),
    'js_view' => 'VcBackendTtaTabsView',
    'custom_markup' => '
<div class="vc_tta-container" data-vc-action="collapse">
    <div class="vc_general vc_tta vc_tta-tabs vc_tta-color-backend-tabs-white vc_tta-style-flat vc_tta-shape-rounded vc_tta-spacing-1 vc_tta-tabs-position-top vc_tta-controls-align-left">
        <div class="vc_tta-tabs-container">'
                       . '<ul class="vc_tta-tabs-list">'
                       . '<li class="vc_tta-tab" data-vc-tab data-vc-target-model-id="{{ model_id }}" data-element_type="vc_tta_section"><a href="javascript:;" data-vc-tabs data-vc-container=".vc_tta" data-vc-target="[data-model-id=\'{{ model_id }}\']" data-vc-target-model-id="{{ model_id }}"><span class="vc_tta-title-text">{{ section_title }}</span></a></li>'
                       . '</ul>
        </div>
        <div class="vc_tta-panels vc_clearfix {{container-class}}">
          {{ content }}
        </div>
    </div>
</div>',
    'default_content' => '
[vc_tta_section title="' . sprintf( '%s %d', esc_html__( 'Tab','sc-core' ), 1 ) . '"][/vc_tta_section]
[vc_tta_section title="' . sprintf( '%s %d', esc_html__( 'Tab','sc-core' ), 2 ) . '"][/vc_tta_section]
    ',
    'admin_enqueue_js' => array(
        vc_asset_url( 'lib/vc_tabs/vc-tabs.min.js' ),
    ),
);
