<?php
/** 
 * The SlashCreative VC Element 
 *
 * @author     SlashCreative
 * @copyright  (c) Copyright by SlashCreative
 * @link       http://slashcreative.co
 * @package    SC-CORE
 * @subpackage Core
 * @since      1.1.0
 *
 * Element Description: Slcr Trustpilot
 */
if ( ! defined( 'ABSPATH' ) ) {
    die( '-1' );
}
if (!class_exists('Slcr_Trustpilot')) {
    class Slcr_Trustpilot extends WPBakeryShortCode
    {
        /**
         * Constructor.
         *
         * @access public 
         */
        public function __construct()
        {
            add_shortcode('slcr_trustpilot', array(
                $this,
                'slcr_trustpilot_callback'
            )); 
        }
        function slcr_trustpilot_callback($atts, $content = null)
        {
            extract(shortcode_atts(array( 
                'image' => '',   
                'slcr_trustpilot_rating' => '',    
                'no_of_rewiews' => '',    
                'trustpilot_link' => '',    
                'el_id' => '',
                'el_class' => '',
                'css' => '',
            ) , $atts));
            $wrapper_attributes = array();

            if (!empty($el_id)) {
                $wrapper_attributes[] = 'id="' . esc_attr($el_id) . '"';
            }
            if (!empty($el_class)) {
            $el_class =  $el_class;
            }
            // get custom css value
            $css_class = apply_filters(VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class($css, ' ') , $atts); 
            // parse link
            $trustpilot_link = ('||' === $trustpilot_link) ? '' : $trustpilot_link;
            $link = vc_build_link($trustpilot_link);
            $use_link = false; 
            $a_href = "";
            $a_title = "";
            $a_target = "";
            $a_rel = "";
            if (strlen($link['url']) > 0) {
                $use_link = true;
                $a_href = $link['url'];
                $a_title = $link['title'];
                $a_target = $link['target'];
                $a_rel = $link['rel'];
            }
            $attributes2 = "";
            if ($use_link) {
                $attributes2 = 'href="' . esc_url(trim($a_href)) . '" ';
                $attributes2.= ' title="' . esc_attr(trim($a_title)) . '" ';
                if (!empty($a_target)) {
                    $attributes2.= 'target="' . esc_attr(trim($a_target)) . '"';
                }
                if (!empty($a_rel)) {
                    $attributes2.= 'rel="' . esc_html(trim($a_rel)) . '"';
                }
            }
            else {
                $attributes2 = 'href="#" ';
            }  
           
            $output = "";
            if ($use_link) {
                $output.= '
                <!-- TRUSTPILOT -->
                <a '.$attributes2.' class="sc-trustpilot ' . esc_attr($css_class) . ' '. esc_attr($el_class). '" ' . implode(' ', $wrapper_attributes) . '>
                    <div class="sc-trustpilot-logo">
                        <img class="lazy" data-src="'.SLCR_CORE_VC_ELEMENT_ICON_URI . 'elements/trustpilot-logo.svg" alt="Trustpilot Logo">
                    </div>
                    <div class="sc-trustpilot-rating" style="background-image: url('.SLCR_CORE_VC_ELEMENT_ICON_URI . 'elements/stars-' . esc_attr($slcr_trustpilot_rating) . '.svg);"></div>
                    <div class="sc-trustpilot-text">
                        <span class="tp-rating">TrustScore <span class="font-500">' . esc_attr($slcr_trustpilot_rating) . '</span></span>
                        <span class="tp-reviews">Based on <span class="font-500">' . esc_html($no_of_rewiews) . '</span> reviews.</span>
                    </div>
                </a>';
            }else{
                $output.= '
                <!-- TRUSTPILOT -->
                <div class="sc-trustpilot ' . esc_attr($css_class) . ' '. esc_attr($el_class). '" ' . implode(' ', $wrapper_attributes) . '>
                    <div class="sc-trustpilot-logo">
                        <img class="lazy" data-src="'.SLCR_CORE_VC_ELEMENT_ICON_URI . 'elements/trustpilot-logo.svg" alt="Trustpilot Logo">
                    </div>
                    <div class="sc-trustpilot-rating" style="background-image: url('.SLCR_CORE_VC_ELEMENT_ICON_URI . 'elements/stars-' . esc_attr($slcr_trustpilot_rating) . '.svg);"></div>
                    <div class="sc-trustpilot-text">
                        <span class="tp-rating">TrustScore <span class="font-500">' . esc_attr($slcr_trustpilot_rating) . '</span></span>
                        <span class="tp-reviews">Based on <span class="font-500">' . esc_html($no_of_rewiews) . '</span> reviews.</span>
                    </div>
                </div>';
            }

            return $output;
        }
    }
    // Finally initialize code
    new Slcr_Trustpilot;
}