<?php
/** 
 * The SlashCreative VC Element 
 *
 * @author     SlashCreative
 * @copyright  (c) Copyright by SlashCreative
 * @link       http://slashcreative.co
 * @package    SC-CORE
 * @subpackage Core
 * @since      1.1.0
 *
 * Element Description: VC Pricing Table Class Mapping
 */
if (!defined('ABSPATH')) {
    die('-1');
}
// Map the block with vc_map()
return array(
    'name' => esc_html__('Pricing Table ','sc-core') ,
    'base' => 'pricing_table',
    'show_settings_on_create' => true,
    // 'is_container' => true,
    'description' => esc_html__('Insert a pricing table element.','sc-core') ,
    'category' => esc_html__('SC Elements','sc-core') ,
    'icon' => SLCR_CORE_VC_ELEMENT_ICON_URI . 'pricing.png',
    'params' => array(
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Select Pricing Table Type','sc-core') ,
            'param_name' => 'pricing_table_type',
            'class' => 'title-class',
            'value' => array(
                esc_html__('Pricing Table Type 1','sc-core') => 'Pricing_Table_Type_1',
                esc_html__('Pricing Table Type 2','sc-core') => 'Pricing_Table_Type_2',
                esc_html__('Pricing Table Type 3','sc-core') => 'Pricing_Table_Type_3',
                esc_html__('Pricing Table Type 4','sc-core') => 'Pricing_Table_Type_4',
                esc_html__('Pricing Table Type 5','sc-core') => 'Pricing_Table_Type_5',
            ) ,
            'save_always' => true,
            'admin_label' => false,
            'group' => esc_html__('General','sc-core'),
            'description' => esc_html__('Select Type of Pricing Table  . ( Other Input Fields will automatically open and close according to your selections )','sc-core')
        ) ,
        array(
            'admin_label' => false,
            'type' => 'textfield',
            'class' => 'vc_col-xs-6',
            'heading' => esc_html__('Plan Name','sc-core') ,
            'param_name' => 'title',
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'description' => esc_html__('Enter a title or plan name for pricing table. Example - Basic, Advanced or Pro','sc-core') ,
            'group' => esc_html__('General','sc-core'),
        ) ,
        array(
            'admin_label' => false,
            'type' => 'textfield',
            'class' => 'vc_col-xs-6',
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'heading' => esc_html__('Price','sc-core') ,
            'param_name' => 'price',
            'description' => esc_html__('Enter price for pricing tabel. Example - 100, 149 or 200','sc-core') ,
            'group' => esc_html__('General','sc-core'),
        ) ,
        array(
            'admin_label' => false,
            'type' => 'textfield',
            'class' => 'vc_col-xs-6',
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'heading' => esc_html__('Currency Symbol','sc-core') ,
            'param_name' => 'currency',
            'description' => esc_html__('Enter currency symbol for price tag. Example - $, € or £','sc-core') ,
            'group' => esc_html__('General','sc-core'),
        ) ,
        
        array(
            'admin_label' => false,
            'type' => 'textfield',
            'class' => 'vc_col-xs-6',
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'heading' => esc_html__('Helping Text','sc-core') ,
            'param_name' => 'subprice',
            'description' => esc_html__('Enter any helping text to show after price. Example - per month, per year or .99','sc-core') ,
            'group' => esc_html__('General','sc-core'),
        ) ,
        array(
            'type' => 'textfield',
            'holder' => 'Font Size',
            'class' => 'title-class',
            'heading' => esc_html__('Plan Name Font Size','sc-core') ,
            'description' => esc_html__('Enter custom font size for plan name. Example - 15px','sc-core') ,
            'param_name' => 'title_font_size',
            'value' => '' ,
            'admin_label' => false,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'weight' => 0,
            'group' => esc_html__('Typography','sc-core'),
            'dependency' => array(
                'element' => 'title',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Plan Name Text Transform ','sc-core') ,
            'param_name' => 'title_text_transform',
            'class' => 'Title_Text_Transform',
            'description' => esc_html__('Transform the plan name text. Example - UPPERCASE or lowercase','sc-core') ,
            'group' => esc_html__('Typography','sc-core'),
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc padding-custom',
            'value' => array(
                esc_html__('Default ','sc-core') => 'Default',
                esc_html__('Uppercase ','sc-core') => 'uppercase',
                esc_html__('Lowercase ','sc-core') => 'lowercase',
            ) ,
            'save_always' => true,
            'admin_label' => false,
            'dependency' => array(
                'element' => 'title',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'textfield',
            'holder' => 'Font Padding  ',
            'class' => 'title-class',
            'heading' => esc_html__('Plan Name Top and Bottom Padding','sc-core') ,
            'description' => esc_html__('Enter custom Top and Bottom Padding for plan name. Example - 10px','sc-core') ,
            'param_name' => 'title_padding_top',
            'value' => '',
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('Typography','sc-core'),
            'dependency' => array(
                'element' => 'title',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'textfield',
            'holder' => 'Font Padding  ',
            'class' => 'title-class',
            'heading' => esc_html__('Plan Name Left and Right Padding','sc-core') ,
            'description' => esc_html__('Enter custom Left and Right Padding for plan name. Example - 10px','sc-core') ,
            'param_name' => 'title_padding_left',
            'value' => '',
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('Typography','sc-core'),
            'dependency' => array(
                'element' => 'title',
                'not_empty' => true,
            ) ,
        ) ,
        
        array(
            'type' => 'colorpicker',
            'class' => 'title-class',
            'heading' => esc_html__('Plan Name Text Color','sc-core') ,
            'param_name' => 'title_font_color',
            'description' => esc_html__('Change font color for title','sc-core') ,
            'group' => esc_html__('Typography','sc-core'),
            'admin_label' => false,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'dependency' => array(
                'element' => 'title',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'checkbox',
            'class' => 'custom_heading_element_use_theme_fonts',
            'heading' => esc_html__('Use custom Google font ?','sc-core') ,
            'param_name' => 'title_use_theme_fonts',
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'value' => array(
                'Yes' => 'Yes',
            ) ,
            'description' => esc_html__('Leave this if you want to use default theme font.','sc-core') ,
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('Typography','sc-core'),
            'dependency' => array(
                'element' => 'title',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'google_fonts',
            'class' => 'title-class',
            'heading' => esc_html__('Change Plan Name Typography','sc-core') ,
            'param_name' => 'title_google_font_select',
            'settings' => array(
                'fields' => array(
                    'font_family_description' => esc_html__('Select Font Family.','sc-core') ,
                    'font_style_description' => esc_html__('Select Font Style.','sc-core') ,
                ) ,
            ) ,
            'description' => esc_html__('Select Google Font from the list.','sc-core') ,
            'group' => esc_html__('Typography','sc-core'),
            'admin_label' => false,
            'dependency' => array(
                'element' => 'title_use_theme_fonts',
                'value' => 'Yes',
            ) ,
        ) ,
        array(
            'admin_label' => false,
            'type' => 'textarea',
            'class' => 'vc_col-xs-6',
            'heading' => esc_html__('Description','sc-core') ,
            'param_name' => 'desc',
            'description' => esc_html__('Enter some description for pricing table.','sc-core') ,
            'group' => esc_html__('General','sc-core'),
        ) ,
        array(
            'type' => 'textfield',
            'holder' => 'Font Size',
            'class' => 'desc-class',
            'heading' => esc_html__('Description Font Size','sc-core') ,
            'description' => esc_html__('Enter custom font size for description. Example - 15px','sc-core') ,
            'param_name' => 'desc_font_size',
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'value' => '' ,
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('Typography','sc-core'),
            'dependency' => array(
                'element' => 'desc',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Description Text Transform ','sc-core') ,
            'param_name' => 'desc_text_transform',
            'class' => 'desc_Text_Transform',
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'description' => esc_html__('Transform description text. Example - UPPERCASE, lowercase','sc-core') ,
            'group' => esc_html__('Typography','sc-core'),
            'value' => array(
                esc_html__('Default ','sc-core') => 'Default',
                esc_html__('Uppercase ','sc-core') => 'uppercase',
                esc_html__('Lowercase ','sc-core') => 'lowercase',
            ) ,
            'save_always' => true,
            'admin_label' => false,
            'dependency' => array(
                'element' => 'desc',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'textfield',
            'holder' => 'Font Padding  ',
            'class' => 'desc-class',
            'heading' => esc_html__('Description Top and Bottom Padding','sc-core') ,
            'description' => esc_html__('Enter custom description from Top and Bottom to pricing table. Example - 10px','sc-core') ,
            'param_name' => 'desc_padding_top',
            'value' => '',
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('Typography','sc-core'),
            'dependency' => array(
                'element' => 'desc',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'textfield',
            'holder' => 'Font Padding  ',
            'class' => 'desc-class',
            'heading' => esc_html__('Description Left and Right Padding','sc-core') ,
            'description' => esc_html__('Enter custom description from Left and Right to pricing table. Example - 10px','sc-core') ,
            'param_name' => 'desc_padding_left',
            'value' => '',
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('Typography','sc-core'),
            'dependency' => array(
                'element' => 'desc',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'colorpicker',
            'class' => 'desc-class',
            'heading' => esc_html__('Description Text Color','sc-core') ,
            'param_name' => 'desc_font_color',
            'description' => esc_html__('Change text color of description.','sc-core') ,
            'group' => esc_html__('Typography','sc-core'),
            'admin_label' => false,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'dependency' => array(
                'element' => 'desc',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'checkbox',
            'class' => 'custom_heading_element_use_theme_fonts',
            'heading' => esc_html__('Use custom Google font ?','sc-core') ,
            'param_name' => 'desc_use_theme_fonts',
            'value' => array(
                'Yes' => 'Yes',
            ) ,
            'description' => esc_html__('Leave this if you want to use default theme font.','sc-core') ,
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('Typography','sc-core'),
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'dependency' => array(
                'element' => 'desc',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'google_fonts',
            'class' => 'desc-class',
            'heading' => esc_html__('Change Description Typography','sc-core') ,
            'param_name' => 'desc_google_font_select',
            'admin_label' => false,
            'settings' => array(
                'fields' => array(
                    'font_family_description' => esc_html__('Select Font Family.','sc-core') ,
                    'font_style_description' => esc_html__('Select Font Style.','sc-core') ,
                ) ,
            ) ,
            'description' => esc_html__('Select Google Font from the list.','sc-core') ,
            'group' => esc_html__('Typography','sc-core'),
            'dependency' => array(
                'element' => 'desc_use_theme_fonts',
                'value' => 'Yes',
            ) ,
        ) ,
        array(
            'type' => 'textfield',
            'holder' => 'Font Size',
            'class' => 'price-class',
            'heading' => esc_html__('Price Font Size','sc-core') ,
            'description' => esc_html__('Enter custom font size for price tag. Example - 30px','sc-core') ,
            'param_name' => 'price_font_size',
            'value' => '' ,
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('Typography','sc-core'),
            'dependency' => array(
                'element' => 'price',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'textfield',
            'holder' => 'Font Padding  ',
            'class' => 'price-class',
            'heading' => esc_html__('Price Top and Bottom Padding','sc-core') ,
            'description' => esc_html__('Enter custom from top and bottom around price tag. Example - 10px','sc-core') ,
            'param_name' => 'price_padding_top',
            'value' => '' ,
            'admin_label' => false,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'weight' => 0,
            'group' => esc_html__('Typography','sc-core'),
            'dependency' => array(
                'element' => 'price',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'textfield',
            'holder' => 'Font Padding',
            'class' => 'price-class',
            'heading' => esc_html__('Price Left and Right Padding','sc-core') ,
            'description' => esc_html__('Enter custom from left and right around price tag. Example - 10px','sc-core') ,
            'param_name' => 'price_padding_left',
            'value' => '' ,
            'admin_label' => false,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'weight' => 0,
            'group' => esc_html__('Typography','sc-core'),
            'dependency' => array(
                'element' => 'price',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'colorpicker',
            'class' => 'price-class',
            'heading' => esc_html__('Price Text Color','sc-core') ,
            'param_name' => 'price_font_color',
            'description' => esc_html__('Change text color of price tag.','sc-core') ,
            'group' => esc_html__('Typography','sc-core'),
            'admin_label' => false,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'dependency' => array(
                'element' => 'price',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'checkbox',
            'class' => 'custom_heading_element_use_theme_fonts',
            'heading' => esc_html__('Use custom Google font ?','sc-core') ,
            'param_name' => 'price_use_theme_fonts',
            'value' => array(
                'Yes' => 'Yes',
            ) ,
            'description' => esc_html__('Leave this if you want to use default theme font.','sc-core') ,
            'admin_label' => false,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'weight' => 0,
            'group' => esc_html__('Typography','sc-core'),
            'dependency' => array(
                'element' => 'price',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'google_fonts',
            'class' => 'price-class',
            'heading' => esc_html__('Change Price Tag Typography','sc-core') ,
            'param_name' => 'price_google_font_select',
            'settings' => array(
                'fields' => array(
                    'font_family_description' => esc_html__('Select Font Family.','sc-core') ,
                    'font_style_description' => esc_html__('Select Font Style.','sc-core') ,
                ) ,
            ) ,
            'description' => esc_html__('Select Google Font from the table.','sc-core') ,
            'group' => esc_html__('Typography','sc-core'),
            'admin_label' => false,
            'dependency' => array(
                'element' => 'price_use_theme_fonts',
                'value' => 'Yes',
            ) ,
        ) ,
        array(
            'type' => 'textfield',
            'holder' => 'Font Size',
            'class' => 'price-class',
            'heading' => esc_html__('Helping Text Size','sc-core') ,
            'description' => esc_html__('Enter custom font size for helping text. Example - 20px','sc-core') ,
            'param_name' => 'subprice_font_size',
            'value' => '',
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('Typography','sc-core'),
            'dependency' => array(
                'element' => 'subprice',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Helping Text Transform ','sc-core') ,
            'param_name' => 'subprice_text_transform',
            'class' => 'price_Text_Transform',
            'description' => esc_html__('Transform helping text. Example - UPPERCASE or lowercase','sc-core') ,
            'group' => esc_html__('Typography','sc-core'),
            'admin_label' => false,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'value' => array(
                esc_html__('Default ','sc-core') => 'Default',
                esc_html__('Uppercase ','sc-core') => 'uppercase',
                esc_html__('Lowercase ','sc-core') => 'lowercase',
            ) ,
            'save_always' => true,
            'dependency' => array(
                'element' => 'subprice',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'textfield',
            'holder' => 'Font Padding  ',
            'class' => 'price-class',
            'heading' => esc_html__('Helping Text Top and Bottom Padding','sc-core') ,
            'description' => esc_html__('Enter custom padding from top and bottom around helping text. Example - 10px','sc-core') ,
            'param_name' => 'subprice_padding_top',
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'value' => '' ,
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('Typography','sc-core'),
            'dependency' => array(
                'element' => 'subprice',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'textfield',
            'holder' => 'Font Padding  ',
            'class' => 'price-class',
            'heading' => esc_html__('Helping Text Left and Right Padding','sc-core') ,
            'description' => esc_html__('Enter custom padding from left and right around helping text. Example - 10px ','sc-core') ,
            'param_name' => 'subprice_padding_left',
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'value' => '',
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('Typography','sc-core'),
            'dependency' => array(
                'element' => 'subprice',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'colorpicker',
            'class' => 'price-class',
            'heading' => esc_html__('Helping Text Color','sc-core') ,
            'param_name' => 'subprice_font_color',
            'description' => esc_html__('Change the font color for helping text.','sc-core') ,
            'group' => esc_html__('Typography','sc-core'),
            'admin_label' => false,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'dependency' => array(
                'element' => 'subprice',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'checkbox',
            'class' => 'custom_heading_element_use_theme_fonts',
            'heading' => esc_html__('Use custom Google font ?','sc-core') ,
            'param_name' => 'subprice_use_theme_fonts',
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'value' => array(
                'Yes' => 'Yes',
            ) ,
            'description' => esc_html__('Leave this if you want to use default theme font.','sc-core') ,
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('Typography','sc-core'),
            'dependency' => array(
                'element' => 'subprice',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'google_fonts',
            'class' => 'price-class',
            'heading' => esc_html__('Change Helping Text Typography','sc-core') ,
            'param_name' => 'subprice_google_font_select',
            'settings' => array(
                'fields' => array(
                    'font_family_description' => esc_html__('Select Font Family.','sc-core') ,
                    'font_style_description' => esc_html__('Select Font Style.','sc-core') ,
                ) ,
            ) ,
            'description' => esc_html__('Select Google Font from the table.','sc-core') ,
            'group' => esc_html__('Typography','sc-core'),
            'admin_label' => false,
            'dependency' => array(
                'element' => 'subprice_use_theme_fonts',
                'value' => 'Yes',
            ) ,
        ) ,
        array(
            'type' => 'checkbox',
            'class' => 'custom_heading_element_use_theme_fonts',
            'heading' => esc_html__('Enable Pricing Badge','sc-core') ,
            'param_name' => 'use_pricing_badge',
            'value' => array(
                'Yes' => 'Yes',
            ) ,
            'description' => esc_html__('Enable this option to show a badge in the table.','sc-core') ,
            'admin_label' => false,
            'weight' => 0,
            'dependency' => array(
                'element' => 'pricing_table_type',
                'value' => array(
                    'Pricing_Table_Type_1',
                    'Pricing_Table_Type_5'
                ) ,
            ) ,
            'group' => esc_html__('General','sc-core'),
        ) ,
        array(
            'type' => 'textfield',
            'holder' => 'Font Padding  ',
            'class' => 'price-class',
            'heading' => esc_html__('pricing badge  Title','sc-core') ,
            'description' => esc_html__('Enter pricing badge Title ','sc-core') ,
            'param_name' => 'pricing_badge_title',
            'value' => '' ,
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('General','sc-core'),
            'dependency' => array(
                'element' => 'use_pricing_badge',
                'value' => 'Yes',
            ) ,
        ) ,
        array(
            'type' => 'colorpicker',
            'class' => 'title-class',
            'heading' => esc_html__('pricing badge Color','sc-core') ,
            'param_name' => 'pricing_badge_color',
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'description' => esc_html__('Change badge color for title','sc-core') ,
            'group' => esc_html__('General','sc-core'),
            'admin_label' => false,
            'dependency' => array(
                'element' => 'use_pricing_badge',
                'value' => 'Yes',
            ) ,
        ) ,
        array(
            'type' => 'colorpicker',
            'class' => 'title-class',
            'heading' => esc_html__('pricing badge text Color','sc-core') ,
            'param_name' => 'pricing_badge_text_color',
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'description' => esc_html__('Change font color for title','sc-core') ,
            'group' => esc_html__('General','sc-core'),
            'admin_label' => false,
            'dependency' => array(
                'element' => 'use_pricing_badge',
                'value' => 'Yes',
            ) ,
        ) ,
        array(
            'type' => 'colorpicker',
            'class' => 'title-class',
            'heading' => esc_html__('Header Background Color','sc-core') ,
            'param_name' => 'pricing_header_color',
            'description' => esc_html__('Change header color for this pricing table','sc-core') ,
            'group' => esc_html__('General','sc-core'),
            'admin_label' => false,
            'dependency' => array(
                'element' => 'pricing_table_type',
                'value' => 'Pricing_Table_Type_2',
            ) ,
        ) ,
        array(
            'type' => 'textfield',
            'class' => 'price-class',
            'heading' => esc_html__('pricing box link ','sc-core') ,
            'description' => esc_html__('Enter pricing badge link ','sc-core') ,
            'param_name' => 'pricing_box_link',
            'value' => '' ,
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('General','sc-core'),
            'dependency' => array(
                'element' => 'pricing_table_type',
                'value' => 'Pricing_Table_Type_3',
            ) ,
        ) ,
        array(
            'type' => 'attach_image',
            'holder' => 'img',
            // 'class' => 'text-class',
            'heading' => esc_html__('icon','sc-core') ,
            'param_name' => 'himg',
            // 'value' => esc_html__( 'Default value' ),
            'description' => esc_html__('Select Image ','sc-core') ,
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('General','sc-core'),
            'dependency' => array(
                'element' => 'pricing_table_type',
                'value' => 'Pricing_Table_Type_5',
            ) ,
        ) ,
        array(
            'type' => 'textarea_html',
            'holder' => 'div',
            'class' => '',
            'heading' => esc_html__('Pricing Content','sc-core') ,
            'param_name' => 'content', // Important: Only one textarea_html param per content element allowed and it should have 'content' as a 'param_name'
            'value' => '<p>'.__('I am test text block. Click edit button to change this text.','sc-core').'</p>',
            'description' => esc_html__('Enter your content for pricing table or copy the content format from Pricing Element page in the main demo.','sc-core') ,
            'group' => esc_html__('General','sc-core'),
            'admin_label' => false,
            'dependency' => array(
                'element' => 'pricing_table_type',
                'value' => array(
                    'Pricing_Table_Type_1',
                    'Pricing_Table_Type_2',
                    'Pricing_Table_Type_4',
                    'Pricing_Table_Type_5'
                ) ,
            ) ,
        ) ,
        array(
            'type' => 'checkbox',
            'class' => 'custom_heading_element_use_theme_fonts',
            'heading' => esc_html__('Insert Button','sc-core') ,
            'param_name' => 'use_button',
            'value' => array(
                'Yes' => 'Yes',
            ) ,
            'description' => esc_html__('Enable the option to put a button in pricing table.','sc-core'),
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('General','sc-core'),
            'edit_field_class' => 'vc_column vc_col-sm-4 crum_vc',
            'dependency' => array(
                'element' => 'pricing_table_type',
                'value' => array(
                    'Pricing_Table_Type_1',
                    'Pricing_Table_Type_2',
                    'Pricing_Table_Type_4',
                    'Pricing_Table_Type_5'
                ) ,
            ) ,
        ) ,
        array(
            'type' => 'checkbox',
            'class' => 'custom_heading_element_use_theme_fonts',
            'heading' => esc_html__('Make featured','sc-core') ,
            'param_name' => 'make_featured',
            'edit_field_class' => 'vc_column vc_col-sm-4 crum_vc',
            'description' => esc_html__('Enable this option to set this table as featured.','sc-core'),
            'value' => array(
                'Yes' => 'Yes',
            ) ,
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('General','sc-core'),
        ) ,
        array(
            'type' => 'checkbox',
            'class' => 'custom_heading_element_use_theme_fonts',
            'heading' => esc_html__('Hover Translate','sc-core') ,
            'param_name' => 'pricing_hover_translate',
            'edit_field_class' => 'vc_column vc_col-sm-4 crum_vc',
            'description' => esc_html__('Enable this option for translate effect on hover.','sc-core'),
            'value' => array(
                'Yes' => 'Yes',
            ) ,
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('General','sc-core'),
        ) ,
        array(
            'type' => 'textfield',
            'holder' => 'Font Padding  ',
            'class' => 'price-class',
            'heading' => esc_html__('Button Text','sc-core') ,
            'description' => esc_html__('Enter some text to show in the button. For advanced button settings navigate to "Button Options" Tab.','sc-core') ,
            'param_name' => 'button_title',
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'value' => '' ,
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('General','sc-core'),
            'dependency' => array(
                'element' => 'use_button',
                'value' => 'Yes',
            ) ,
        ) ,
        array(
            'type' => 'vc_link',
            'heading' => esc_html__('URL (Link)','sc-core') ,
            'param_name' => 'link',
            'description' => esc_html__('Add link to button.','sc-core') ,
            'group' => esc_html__('General','sc-core'),
            'admin_label' => false,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'dependency' => array(
                'element' => 'use_button',
                'value' => 'Yes',
            ) ,
            // compatible with btn2 and converted from href{btn1}
        ) ,
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Select Button style','sc-core') ,
            'param_name' => 'button_type',
            'class' => 'title-class',
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'value' => array(
                esc_html__('Button Default','sc-core') => 'Button_Default',
                esc_html__('Button Ghost','sc-core') => 'Button_Ghost', 
                esc_html__('Button Fill','sc-core') => 'Button_Fill',
                esc_html__('Arrow Icon','sc-core') => 'Arrow_Icon',
                esc_html__('Background Inverse','sc-core') => 'Background_Inverse',
            ) ,
            'save_always' => true,
            'description' => esc_html__('Select style of Button ( Other Input Fields will automatically open and close according to your selections )','sc-core') ,
            'admin_label' => false,
            'dependency' => array(
                'element' => 'use_button',
                'value' => 'Yes',
            ) ,
            'group' => esc_html__('Button Options','sc-core'),
        ) ,
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Button Fill Animation','sc-core') ,
            'param_name' => 'button_fill_animation',
            'class' => 'title-class',
            'value' => array(
                esc_html__('Left to Right','sc-core') => 'l-to-r',
                esc_html__('Right to Left','sc-core') => 'r-to-l',
                esc_html__('Top to Bottom','sc-core') => 't-to-b',
                esc_html__('Bottom to Top','sc-core') => 'b-to-t',
            ) ,
            'save_always' => true,
            'description' => esc_html__('Select Button Fill Animation ','sc-core') ,
            'dependency' => array(
                'element' => 'button_type',
                'value' => array(
                    'Button_Fill',
                    'Hover_Icon_Fill'
                ) ,
            ) ,
            'group' => esc_html__('Button Options','sc-core'),
            'admin_label' => false,
        ) ,
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Button Size','sc-core') ,
            'param_name' => 'button_size',
            'class' => 'title-class',
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc padding-custom',
            'value' => array(
                esc_html__('Button X Large','sc-core') => 'btn--xl',
                esc_html__('Button Large','sc-core') => 'btn--lg',
                esc_html__('Button Medium','sc-core') => 'btn--md',
                esc_html__('Button Small','sc-core') => 'btn--sm',
            ) ,
            'save_always' => true,
            'description' => esc_html__('Select Size of Button ','sc-core') ,
            'dependency' => array(
                'element' => 'use_button',
                'value' => 'Yes',
            ) ,
            'group' => esc_html__('Button Options','sc-core'),
            'admin_label' => false,
        ) ,
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Button Shapes','sc-core') ,
            'param_name' => 'button_shapes',
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'class' => 'title-class',
            'value' => array(
                esc_html__('Pill Shaped','sc-core') => 'btn--pill',
                esc_html__('Square Borders','sc-core') => 'btn--square',
                esc_html__('Rounded Borders','sc-core') => 'btn--rounded',
                esc_html__('Border Transform','sc-core') => 'btn--border-tr',
            ) ,
            'save_always' => true,
            'description' => esc_html__('Select Shapes of Button ','sc-core') ,
            'dependency' => array(
                'element' => 'use_button',
                'value' => 'Yes',
            ) ,
            'group' => esc_html__('Button Options','sc-core'),
            'admin_label' => false,
        ) ,
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Hover Styles','sc-core') ,
            'param_name' => 'button_hover_styles',
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'class' => 'title-class',
            'value' => array(
                esc_html__('Hover Default','sc-core') => '',
                esc_html__('Hover Translate','sc-core') => 'btn-translate',
                esc_html__('Hove Shadow','sc-core') => 'btn-shadow',
            ) ,
            'save_always' => true,
            'description' => esc_html__('Select Hover Styles of Button ','sc-core') ,
            'dependency' => array(
                'element' => 'use_button',
                'value' => 'Yes',
            ) ,
            'group' => esc_html__('Button Options','sc-core'),
            'admin_label' => false,
        ) ,
        array(
            'type' => 'checkbox',
            'heading' => esc_html__('Fade Effect on click','sc-core') ,
            'param_name' => 'fade_effect',
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'dependency' => array(
                'element' => 'use_button',
                'value' => 'Yes',
            ) ,
            'group' => esc_html__('Button Options','sc-core'),
            'admin_label' => false,
        ) ,
        array(
            'type' => 'checkbox',
            'heading' => esc_html__('Set full width button?','sc-core') ,
            'param_name' => 'button_block',
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'dependency' => array(
                'element' => 'use_button',
                'value' => 'Yes',
            ) ,
            'group' => esc_html__('Button Options','sc-core'),
            'admin_label' => false,
        ) ,
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Button Colors','sc-core') ,
            'param_name' => 'button_colors',
            'class' => 'title-class',
            'value' => array(
                esc_html__('Primary Color','sc-core') => 'btn--primary',
                esc_html__('Secondary Color','sc-core') => 'btn--secondary',
                esc_html__('Dark Color','sc-core') => 'btn--dark',
                esc_html__('Color Green','sc-core') => 'btn--green',
                esc_html__('Color Orange','sc-core') => 'btn--orange',
                esc_html__('Color Blue','sc-core') => 'btn--blue',
                esc_html__('Gradient Color 1','sc-core') => 'btn--gradient btn--gradient-1',
                esc_html__('Gradient Color 2','sc-core') => 'btn--gradient btn--gradient-2',
            ) ,
            'save_always' => true,
            'description' => esc_html__('Select Colors of Button  ','sc-core') ,
            'dependency' => array(
                'element' => 'use_button',
                'value' => 'Yes',
            ) ,
            'group' => esc_html__('Button Options','sc-core'),
            'admin_label' => false,
        ) ,
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Font Weights','sc-core') ,
            'param_name' => 'button_font_weights',
            'class' => 'title-class',
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'value' => array(
                esc_html__('font-400','sc-core') => 'font-400',
                esc_html__('font-100','sc-core') => 'font-100',
                esc_html__('font-300','sc-core') => 'font-300',
                esc_html__('font-500','sc-core') => 'font-500',
                esc_html__('font-600','sc-core') => 'font-600',
                esc_html__('font-700','sc-core') => 'font-700',
                esc_html__('font-800','sc-core') => 'font-800',
                esc_html__('font-900','sc-core') => 'font-900',
            ) ,
            'save_always' => true,
            'description' => esc_html__('Select Font Weights of Button ','sc-core') ,
            'dependency' => array(
                'element' => 'use_button',
                'value' => 'Yes',
            ) ,
            'group' => esc_html__('Button Options','sc-core'),
            'admin_label' => false,
        ) ,
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Border Size','sc-core') ,
            'param_name' => 'button_border_size',
            'class' => 'title-class',
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'value' => array(
                esc_html__('No Border ','sc-core') => '',
                esc_html__('Border 1px','sc-core') => 'border-1',
                esc_html__('Border 2px','sc-core') => 'border-2',
                esc_html__('Border 3px','sc-core') => 'border-3',
                esc_html__('Border 4px','sc-core') => 'border-4',
                esc_html__('Border 5px','sc-core') => 'border-5',
                esc_html__('Border 6px','sc-core') => 'border-6',
                esc_html__('Border 7px','sc-core') => 'border-7',
            ) ,
            'save_always' => true,
            'description' => esc_html__('Select Border Size of Button ','sc-core') ,
            'dependency' => array(
                'element' => 'use_button',
                'value' => 'Yes',
            ) ,
            'group' => esc_html__('Button Options','sc-core'),
            'admin_label' => false,
        ) ,
        array(
            'type' => 'el_id',
            'heading' => esc_html__('Element ID','sc-core') ,
            'param_name' => 'el_id',
            'description' => sprintf(__('Enter element ID (Note: make sure it is unique and valid according to ','sc-core').'<a href="%s" target="_blank">'.__('w3c specification','sc-core').'</a>).' , 'http://www.w3schools.com/tags/att_global_id.asp') ,
            'admin_label' => false,
            'group' => esc_html__('General','sc-core'),
        ) ,
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Extra class name','sc-core') ,
            'param_name' => 'el_class',
            'description' => esc_html__('Style particular content element differently - add a class name and refer to it in custom CSS.','sc-core') ,
            'admin_label' => false,
            'group' => esc_html__('General','sc-core'),
        ) ,
        array(
            'type' => 'css_editor',
            'heading' => esc_html__('CSS box','sc-core') ,
            'param_name' => 'css',
            'admin_label' => false,
            'group' => esc_html__('Design Options','sc-core') ,
        ) ,
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'External Image link for Template','sc-core' ),  
            'param_name' => 'slcr_img_link_template',  
            'group' => esc_html__('General','sc-core'),
            'content_element'=>false,
        ),
    ) ,
);