<?php
/** 
 * The SlashCreative VC Element 
 *
 * @author     SlashCreative
 * @copyright  (c) Copyright by SlashCreative
 * @link       http://slashcreative.co
 * @package    SC-CORE
 * @subpackage Core
 * @since      1.1.0
 *
 * Element Description: Slcr Instagram Story Mapping
 */
if ( ! defined( 'ABSPATH' ) ) {
    die( '-1' );
}
return array(
    'name' => esc_html__('Instagram Story','sc-core') ,
    'base' => 'slcr_insta_story',
    'icon' => SLCR_CORE_VC_ELEMENT_ICON_URI . 'insta-feed.png',
    'class' => 'vc_icon_content_box',
    // /'content_element' => true,
    'controls' => 'full',
    'show_settings_on_create' => true,
    // 'is_container'    => true,
    'category' => esc_html__('SC Elements','sc-core') ,
    'description' => esc_html__('Add a Instagram Story.','sc-core') ,
    'params' => array(
        array(
            'type' => 'attach_image',
            'holder' => 'img', 
            'heading' => esc_html__('Avatar','sc-core') ,
            'param_name' => 'image', 
            'description' => esc_html__('Select Avatar image  .','sc-core') ,
            'edit_field_class' => 'vc_column vc_col-sm-6 padding-custom crum_vc',
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('General','sc-core'),
        ) ,
        array(
            'admin_label' => false,
            'type' => 'textfield',
            'class' => 'vc_col-xs-6',
            'heading' => esc_html__('Name','sc-core') ,
            'param_name' => 'name',
            'description' => esc_html__('Enter full name of the user.','sc-core') ,
            'group' => esc_html__('General','sc-core'),
        ) ,
        array(
            'admin_label' => false,
            'type' => 'textfield',
            'class' => 'vc_col-xs-6',
            'heading' => esc_html__('User Name','sc-core') ,
            'param_name' => 'username',
            'description' => esc_html__('Type instagram username of the client.','sc-core') ,
            'group' => esc_html__('General','sc-core'),
        ) ,
        array(
            'type' => 'attach_image',
            'holder' => 'img', 
            'heading' => esc_html__('Story Image','sc-core') ,
            'param_name' => 'story_image', 
            'description' => esc_html__('Choose an image for the story.','sc-core') ,
            'edit_field_class' => 'vc_column vc_col-sm-6 padding-custom crum_vc',
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('General','sc-core'),
        ) ,
        array(
            'type' => 'colorpicker',
            'class' => 'title-class',
            'heading' => esc_html__('Hover Color','sc-core') ,
            'param_name' => 'hover_color',
            'description' => esc_html__('Custom overlay color on Hover','sc-core'),
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'group' => esc_html__('General','sc-core'),
            'admin_label' => false, 
        ) ,
        array(
            'admin_label' => false,
            'type' => 'textarea',
            'class' => 'vc_col-xs-6',
            'heading' => esc_html__('Review Text','sc-core') ,
            'param_name' => 'description',
            'description' => esc_html__('Type testimonial text to display on image hover.','sc-core') ,
            'group' => esc_html__('General','sc-core'),
        ) ,
        array(
            'admin_label' => false,
            'type' => 'textfield',
            'class' => 'vc_col-xs-6',
            'heading' => esc_html__('Helping Text','sc-core') ,
            'param_name' => 'description_2',
            'description' => esc_html__('Enter small text to show under review text.','sc-core') ,
            'group' => esc_html__('General','sc-core'),
        ) ,  
        array(
            'type' => 'vc_link',
            'class' => 'custom_heading_element_link',
            'heading' => esc_html__('URL (Link)','sc-core') ,
            'param_name' => 'insta_link',
            'description' => esc_html__('Select URL and enter text.','sc-core') ,
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('General','sc-core'),
        ) , 
        array(
            'type' => 'el_id',
            'heading' => esc_html__('Element ID','sc-core') ,
            'param_name' => 'el_id',
            'description' => sprintf(__('Enter element ID (Note: make sure it is unique and valid according to ','sc-core').'<a href="%s" target="_blank">'.__('w3c specification','sc-core').'</a>).' , 'http://www.w3schools.com/tags/att_global_id.asp') ,
            'admin_label' => false,
            'group'       => esc_html__('General','sc-core'),
        ) ,
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Extra class name','sc-core') ,
            'param_name' => 'el_class',
            'description' => esc_html__('Style particular content element differently - add a class name and refer to it in custom CSS.','sc-core') ,
            'admin_label' => false,
            'group'       => esc_html__('General','sc-core'),
        ) ,
        array(
            'type' => 'css_editor',
            'heading' => esc_html__('CSS box','sc-core') ,
            'param_name' => 'css',
            'admin_label' => false,
            'group' => esc_html__('Design Options','sc-core') ,
        ) ,
    ) ,
);