<?php
/** 
 * The SlashCreative VC Element 
 *
 * @author     SlashCreative
 * @copyright  (c) Copyright by SlashCreative
 * @link       http://slashcreative.co
 * @package    SC-CORE
 * @subpackage Core
 * @since      1.1.0
 *
 * Element Description: Slcr Instagram Story
 */
if ( ! defined( 'ABSPATH' ) ) {
    die( '-1' );
}
if (!class_exists('Slcr_Insta_Story')) {
    class Slcr_Insta_Story extends WPBakeryShortCode
    {
        /**
         * Constructor.
         *
         * @access public 
         */
        public function __construct()
        {
            add_shortcode('slcr_insta_story', array(
                $this,
                'slcr_insta_story_callback'
            )); 
        }
        function slcr_insta_story_callback($atts, $content = null)
        {
            extract(shortcode_atts(array( 
                'image' => '',   
                'name' => '',   
                'username' => '',   
                'story_image' => '',   
                'hover_color' => '',   
                'description' => '',   
                'description_2' => '',   
                'insta_link' => '',   
                'el_id' => '',
                'el_class' => '',
                'css' => '',
            ) , $atts));
            $output_css = '';
            $wrapper_attributes = array();

            if (!empty($el_id)) {
                $wrapper_attributes[] = 'id="' . esc_attr($el_id) . '"';
            }
            if (!empty($el_class)) {
            $el_class =  $el_class;
            }
            // get custom css value
            $css_class = apply_filters(VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class($css, ' ') , $atts); 
            // parse link
            $insta_link = ('||' === $insta_link) ? '' : $insta_link;
            $link = vc_build_link($insta_link);
            $use_link = false; 
            $a_href = "";
            $a_title = "";
            $a_target = "";
            $a_rel = "";
            if (strlen($link['url']) > 0) {
                $use_link = true;
                $a_href = $link['url'];
                $a_title = $link['title'];
                $a_target = $link['target'];
                $a_rel = $link['rel'];
            }
            $attributes2 = "";
            if ($use_link) {
                $attributes2 = 'href="' . esc_url(trim($a_href)) . '" ';
                $attributes2.= ' title="' . esc_attr(trim($a_title)) . '" ';
                if (!empty($a_target)) {
                    $attributes2.= 'target="' . esc_attr(trim($a_target)) . '"';
                }
                if (!empty($a_rel)) {
                    $attributes2.= 'rel="' . esc_html(trim($a_rel)) . '"';
                }
            }
            else {
                $attributes2 = 'href="#" ';
            } 
            $img_url = wp_get_attachment_image_src($image, "thumbnail");
            $story_image_url = wp_get_attachment_image_src($story_image, "larg");
            $uid2 = uniqid();
            $slcr_custom_insta_story_css = '.slcr_custom_insta_story_css' . $uid2 . ' {
                background-color: ' . esc_attr($hover_color) . ' !important; 
            }'; 
            $value=$slcr_custom_insta_story_css;
            $output_css .= $value; 
            $output = "";
            if ($use_link) {
                $output.= '
                <!-- INSTAGRAM STORY -->
                <a '.$attributes2.' class="sc-insta-story ' . esc_attr($css_class) . ' '. esc_attr($el_class). '" ' . implode(' ', $wrapper_attributes) . '>
                    <!-- HEADER -->
                    <div class="sc-insta-header">
                        <div class="sc-insta-avatar">
                            <img class="lazy" data-src="'.esc_url($img_url[0]).'" alt="User Avatar">
                        </div>
                        <div class="sc-insta-info">
                            <h4>' . esc_html( $name ) . '</h4>
                            <p>' . esc_html( $username ) . '</p>
                        </div>
                        <div class="sc-insta-icon"></div>
                    </div>
                    <!-- CONTENT -->
                    <div class="sc-insta-content lazy" data-bg="url('.esc_url($story_image_url[0]).')">
                        <div class="sc-insta-overlay slcr_custom_insta_story_css' . $uid2 . '">
                            <div class="sc-insta-caption">
                                <p>' . esc_html( $description ) . '</p>
                                <h5>' . esc_html( $description_2 ) . '</h5>
                            </div>
                        </div>
                    </div>
                </a>';
            }else{
                $output.= '
                <!-- INSTAGRAM STORY -->
                <div class="sc-insta-story ' . esc_attr($css_class) . ' '. esc_attr($el_class). '" ' . implode(' ', $wrapper_attributes) . '>
                    <!-- HEADER -->
                    <div class="sc-insta-header">
                        <div class="sc-insta-avatar">
                            <img class="lazy" data-src="'.esc_url($img_url[0]).'" alt="User Avatar">
                        </div>
                        <div class="sc-insta-info">
                            <h4>' . esc_html( $name ) . '</h4>
                            <p>' . esc_html( $username ) . '</p>
                        </div>
                        <div class="sc-insta-icon"></div>
                    </div>
                    <!-- CONTENT -->
                    <div class="sc-insta-content lazy" data-bg="url('.esc_url($story_image_url[0]).')">
                        <div class="sc-insta-overlay slcr_custom_insta_story_css' . $uid2 . '">
                            <div class="sc-insta-caption">
                                <p>' . esc_html( $description ) . '</p>
                                <h5>' . esc_html( $description_2 ) . '</h5>
                            </div>
                        </div>
                    </div>
                </div>';   
            }
            echo '<style>'.$output_css.'</style>'; 
            return $output;
        }
    }
    // Finally initialize code
    new Slcr_Insta_Story;
}