<?php
/** 
 * The SlashCreative VC Element 
 *
 * @author     SlashCreative
 * @copyright  (c) Copyright by SlashCreative
 * @link       http://slashcreative.co
 * @package    SC-CORE
 * @subpackage Core
 * @since      1.0.0
 *
 * Element Description: Slcr Testimonial Item
 */
if ( ! defined( 'ABSPATH' ) ) {
    die( '-1' );
}
 
// Map the block with vc_map()
return array(
    'name' => esc_html__('Testimonial Item','sc-core') ,
    'base' => 'testimonials',
    'show_settings_on_create' => true,
    // 'is_container' => true,
    'description' => esc_html__('Add single testimonial item.','sc-core') ,
    'category' => esc_html__('SC Elements','sc-core') ,
    'icon' => SLCR_CORE_VC_ELEMENT_ICON_URI . 'testimonial-single.png',
    'params' => array(
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Select Testimonials Type','sc-core') ,
            'param_name' => 'testimonials_type',
            'class' => 'title-class',
            'value' => array(
                esc_html__('Testimonials Type 1','sc-core') => 'Testimonials_Type_1',
                esc_html__('Testimonials Type 2','sc-core') => 'Testimonials_Type_2',
                esc_html__('Testimonials Type 3','sc-core') => 'Testimonials_Type_3',
                esc_html__('Testimonials Type 4','sc-core') => 'Testimonials_Type_4',
                esc_html__('Testimonials Type 5','sc-core') => 'Testimonials_Type_5',
                esc_html__('Testimonials Type 6','sc-core') => 'Testimonials_Type_6',
            ) ,
            'save_always' => true,
            'admin_label' => false,
            'group' => esc_html__('General','sc-core'),
            'description' => esc_html__('Select Type of Testimonials section. ( Other Input Fields will automatically open and close according to your selections )','sc-core')
        ) ,
        array(
            'type' => 'attach_image',
            'heading' => esc_html__('Avatar','sc-core') ,
            'param_name' => 'avatar',
            'value' => '',
            'description' => esc_html__('Select Avatar from media library.','sc-core') ,
            'group' => esc_html__('General','sc-core'),
            'admin_label' => false,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'dependency' => array(
                'element' => 'testimonials_type',
                'value' => array(
                    'Testimonials_Type_6',
                    'Testimonials_Type_5',
                    'Testimonials_Type_4',
                    'Testimonials_Type_2',
                    'Testimonials_Type_1'
                ) ,
            ) ,
        ) ,
        array(
            'type' => 'textfield',
            'class' => 'title-class',
            'heading' => esc_html__('Avatar Border Radius','sc-core') ,
            'description' => esc_html__('Change the border radius for avatar. Example - 100px','sc-core') ,
            'param_name' => 'avatar_border_radius',
            'value' => '' ,
            'admin_label' => false,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'weight' => 0,
            'dependency' => array(
                'element' => 'avatar',
                'not_empty' => true,
            ) ,
            'group' => esc_html__('General','sc-core'),
        ) ,
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Avatar Image Switch ','sc-core') ,
            'param_name' => 'avatar_image_switch',
            'class' => 'Text_float',
            'description' => esc_html__('Switch the side of Image','sc-core') ,
            'group' => esc_html__('General','sc-core'),
            'admin_label' => false,
            'value' => array(
                esc_html__('Switch Left ','sc-core') => 'left',
                esc_html__('Switch Right ','sc-core') => 'right',
            ) ,
            'dependency' => array(
                'element' => 'testimonials_type',
                'value' => array(
                    'Testimonials_Type_6'
                ) ,
            ) ,
            'save_always' => true,
        ) ,
        array(
            'type' => 'attach_image',
            'heading' => esc_html__('Company Logo','sc-core') ,
            'param_name' => 'company_logo',
            'value' => '',
            'description' => esc_html__('Select Company Logo from media library.','sc-core') ,
            'group' => esc_html__('General','sc-core'),
            'admin_label' => false,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'dependency' => array(
                'element' => 'testimonials_type',
                'value' => array(
                    'Testimonials_Type_3'
                ) ,
            ) ,
        ) ,
        array(
            'type' => 'textfield',
            'class' => 'title-class',
            'heading' => esc_html__('Company Logo Radius','sc-core') ,
            'description' => esc_html__('Change the border radius of image. Example - 100px or 50%','sc-core') ,
            'param_name' => 'company_logo_border_radius',
            'value' => '' ,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'admin_label' => false,
            'weight' => 0,
            'dependency' => array(
                'element' => 'company_logo',
                'not_empty' => true,
            ) ,
            'group' => esc_html__('General','sc-core'),
        ) ,
        array(
            'admin_label' => false,
            'type' => 'textfield',
            'class' => 'vc_col-xs-6',
            'heading' => esc_html__('Client Name','sc-core') ,
            'param_name' => 'name',
            'description' => esc_html__('Enter name of the Client. Example - John Doe','sc-core') ,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'group' => esc_html__('General','sc-core'),
        ) ,
        array(
            'type' => 'textfield',
            'holder' => 'Font Size',
            'class' => 'title-class',
            'heading' => esc_html__('Client Name Font Size','sc-core') ,
            'description' => esc_html__('Enter custom font size for client name. Example - 15px','sc-core') ,
            'param_name' => 'client_name_font_size',
            'value' => '' ,
            'admin_label' => false,
            'weight' => 0,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'group' => esc_html__('Typography','sc-core'),
            'dependency' => array(
                'element' => 'name',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Client Name Text Transform','sc-core') ,
            'param_name' => 'client_name_text_transform',
            'class' => 'Title_Text_Transform',
            'description' => esc_html__('Transform Client Name. Example - UPPERCASE or lowercase','sc-core') ,
            'group' => esc_html__('Typography','sc-core'),
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'value' => array(
                esc_html__('Default ','sc-core') => 'Default',
                esc_html__('Uppercase ','sc-core') => 'uppercase',
                esc_html__('Lowercase ','sc-core') => 'lowercase',
            ) ,
            'save_always' => true,
            'admin_label' => false,
            'dependency' => array(
                'element' => 'name',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'textfield',
            'holder' => 'Font Padding ',
            'class' => 'title-class',
            'heading' => esc_html__('Client Name Padding Top & Bottom','sc-core') ,
            'description' => esc_html__('Enter custom Top and Bottom padding around client name. Example - 10px','sc-core') ,
            'param_name' => 'client_name_padding_top',
            'value' => '' ,
            'admin_label' => false,
            'weight' => 0,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'group' => esc_html__('Typography','sc-core'),
            'dependency' => array(
                'element' => 'name',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'textfield',
            'holder' => 'Font Padding  ',
            'class' => 'title-class',
            'heading' => esc_html__('Client Name Padding Left & Right','sc-core') ,
            'description' => esc_html__('Enter custom Left and Right padding around client name. Example - 10px','sc-core') ,
            'param_name' => 'client_name_padding_left',
            'value' => '' ,
            'admin_label' => false,
            'weight' => 0,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'group' => esc_html__('Typography','sc-core'),
            'dependency' => array(
                'element' => 'name',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'colorpicker',
            'class' => 'title-class',
            'heading' => esc_html__('Client Name Font Color','sc-core') ,
            'param_name' => 'client_name_font_color',
            'description' => esc_html__('Change font color for client\'s name','sc-core') ,
            'group' => esc_html__('Typography','sc-core'),
            'admin_label' => false,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'dependency' => array(
                'element' => 'name',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'checkbox',
            'class' => 'custom_heading_element_use_theme_fonts',
            'heading' => esc_html__('Use custom Google font ?','sc-core') ,
            'param_name' => 'client_name_use_theme_fonts',
            'value' => array(
                'Yes' => 'Yes',
            ) ,
            'description' => esc_html__('Leave this if you want to use default theme font.','sc-core') ,
            'admin_label' => false,
            'weight' => 0,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'group' => esc_html__('Typography','sc-core'),
            'dependency' => array(
                'element' => 'name',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'google_fonts',
            'class' => 'title-class',
            'heading' => esc_html__('Change Client Name Typography','sc-core') ,
            'param_name' => 'client_name_google_font_select',
            'admin_label' => false,
            'settings' => array(
                'fields' => array(
                    'font_family_description' => esc_html__('Select Font Family.','sc-core') ,
                    'font_style_description' => esc_html__('Select Font Style.','sc-core') ,
                ) ,
            ) ,
            'description' => esc_html__('Select Google Font from the list.','sc-core') ,
            'group' => esc_html__('Typography','sc-core'),
            'dependency' => array(
                'element' => 'client_name_use_theme_fonts',
                'value' => 'Yes',
            ) ,
        ) ,
        array(
            'admin_label' => false,
            'type' => 'textfield',
            'heading' => esc_html__('Description','sc-core') ,
            'param_name' => 'desc',
            'group' => esc_html__('General','sc-core'),
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'description' => esc_html__('Enter description of the Client. eg( Developer, Google Inc. )','sc-core')
        ) ,
        array(
            'type' => 'textfield',
            'holder' => 'Font Size',
            'class' => 'title-class',
            'heading' => esc_html__('Description Font Size','sc-core') ,
            'description' => esc_html__('Change the font size of client description. Example - 15px','sc-core') ,
            'param_name' => 'description_font_size',
            'value' => '' ,
            'admin_label' => false,
            'weight' => 0,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'group' => esc_html__('Typography','sc-core'),
            'dependency' => array(
                'element' => 'desc',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Description Text Transform','sc-core') ,
            'param_name' => 'description_text_transform',
            'class' => 'Title_Text_Transform',
            'description' => esc_html__('Transform the description text. Example - UPPERCASE or lowercase','sc-core') ,
            'group' => esc_html__('Typography','sc-core'),
            'admin_label' => false,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'dependency' => array(
                'element' => 'desc',
                'not_empty' => true,
            ) ,
            'value' => array(
                esc_html__('Default ','sc-core') => 'Default',
                esc_html__('Uppercase ','sc-core') => 'uppercase',
                esc_html__('Lowercase ','sc-core') => 'lowercase',
            ) ,
            'save_always' => true,
        ) ,
        array(
            'type' => 'textfield',
            'holder' => 'Font Padding  ',
            'class' => 'title-class',
            'heading' => esc_html__('Description Padding Top & Bottom','sc-core') ,
            'description' => esc_html__('Enter custom Top and Bottom padding around description. Example - 10px','sc-core') ,
            'param_name' => 'description_padding_top',
            'value' => '' ,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'admin_label' => false,
            'dependency' => array(
                'element' => 'desc',
                'not_empty' => true,
            ) ,
            'weight' => 0,
            'group' => esc_html__('Typography','sc-core'),
        ) ,
        array(
            'type' => 'textfield',
            'holder' => 'Font Padding  ',
            'class' => 'title-class',
            'heading' => esc_html__('Description Padding Left & Right','sc-core') ,
            'description' => esc_html__('Enter custom Left and Right padding around description. Example - 10px','sc-core') ,
            'param_name' => 'description_padding_left',
            'value' => '' ,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'admin_label' => false,
            'dependency' => array(
                'element' => 'desc',
                'not_empty' => true,
            ) ,
            'weight' => 0,
            'group' => esc_html__('Typography','sc-core'),
        ) ,
        array(
            'type' => 'colorpicker',
            'class' => 'title-class',
            'heading' => esc_html__('Description Font color','sc-core') ,
            'param_name' => 'description_font_color',
            'description' => esc_html__('Change Description Font color','sc-core') ,
            'group' => esc_html__('Typography','sc-core'),
            'admin_label' => false,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'dependency' => array(
                'element' => 'desc',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'checkbox',
            'class' => 'custom_heading_element_use_theme_fonts',
            'heading' => esc_html__('Use custom Google Font ?','sc-core') ,
            'param_name' => 'description_use_theme_fonts',
            'value' => array(
                'Yes' => 'Yes',
            ) ,
            'description' => esc_html__('Leave this if you want to use default theme font.','sc-core') ,
            'admin_label' => false,
            'weight' => 0,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'group' => esc_html__('Typography','sc-core'),
            'dependency' => array(
                'element' => 'desc',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'google_fonts',
            'class' => 'title-class',
            'heading' => esc_html__('Change Description Typography','sc-core') ,
            'param_name' => 'description_google_font_select',
            'settings' => array(
                'fields' => array(
                    'font_family_description' => esc_html__('Select Font Family.','sc-core') ,
                    'font_style_description' => esc_html__('Select Font Style.','sc-core') ,
                ) ,
            ) ,
            'description' => esc_html__('Select Google Font from the list.','sc-core') ,
            'group' => esc_html__('Typography','sc-core'),
            'admin_label' => false,
            'dependency' => array(
                'element' => 'description_use_theme_fonts',
                'value' => 'Yes',
            ) ,
        ) ,
        array(
            'admin_label' => false,
            'type' => 'textfield',
            'heading' => esc_html__('Tagline','sc-core') ,
            'param_name' => 'tagline',
            'group' => esc_html__('General','sc-core'),
            'description' => esc_html__('Enter Tagline of the Client. eg( Developer, Google Inc. )','sc-core') ,
            'dependency' => array(
                'element' => 'testimonials_type',
                'value' => array(
                    'Testimonials_Type_2'
                ) ,
            ) ,
        ) ,
        array(
            'type' => 'textfield',
            'holder' => 'Font Size',
            'class' => 'title-class',
            'heading' => esc_html__('Tagline Font Size','sc-core') ,
            'description' => esc_html__('Change the font size of tagline. Example - 25px','sc-core') ,
            'param_name' => 'tagline_font_size',
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'value' => '' ,
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('Typography','sc-core'),
            'dependency' => array(
                'element' => 'tagline',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Tagline Text Transform','sc-core') ,
            'param_name' => 'tagline_text_transform',
            'class' => 'Title_Text_Transform',
            'description' => esc_html__('Transform the tagline text. UPPERCASE or lowercase','sc-core') ,
            'group' => esc_html__('Typography','sc-core'),
            'admin_label' => false,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'dependency' => array(
                'element' => 'tagline',
                'not_empty' => true,
            ) ,
            'value' => array(
                esc_html__('Default ','sc-core') => 'Default',
                esc_html__('Uppercase ','sc-core') => 'uppercase',
                esc_html__('Lowercase ','sc-core') => 'lowercase',
            ) ,
            'save_always' => true,
        ) ,
        array(
            'type' => 'textfield',
            'holder' => 'Font Padding  ',
            'class' => 'title-class',
            'heading' => esc_html__('Tagline Padding Top & Bottom','sc-core') ,
            'description' => esc_html__('Enter custom Top and Bottom padding around tagline. Example - 10px','sc-core') ,
            'param_name' => 'tagline_padding_top',
            'value' => '' ,
            'admin_label' => false,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'dependency' => array(
                'element' => 'tagline',
                'not_empty' => true,
            ) ,
            'weight' => 0,
            'group' => esc_html__('Typography','sc-core'),
        ) ,
        array(
            'type' => 'textfield',
            'holder' => 'Font Padding  ',
            'class' => 'title-class',
            'heading' => esc_html__('Tagline Padding Left & Right','sc-core') ,
            'description' => esc_html__('Enter custom Left and Right padding around tagline. Example - 10px','sc-core') ,
            'param_name' => 'tagline_padding_left',
            'value' => '' ,
            'admin_label' => false,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'dependency' => array(
                'element' => 'tagline',
                'not_empty' => true,
            ) ,
            'weight' => 0,
            'group' => esc_html__('Typography','sc-core'),
        ) ,
        array(
            'type' => 'colorpicker',
            'class' => 'title-class',
            'heading' => esc_html__('Tagline Font color','sc-core') ,
            'param_name' => 'tagline_font_color',
            'description' => esc_html__('Change Tagline Font color','sc-core') ,
            'group' => esc_html__('Typography','sc-core'),
            'admin_label' => false,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'dependency' => array(
                'element' => 'tagline',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'checkbox',
            'class' => 'custom_heading_element_use_theme_fonts',
            'heading' => esc_html__('Use custom Google Font ?','sc-core') ,
            'param_name' => 'tagline_use_theme_fonts',
            'value' => array(
                'Yes' => 'Yes',
            ) ,
            'description' => esc_html__('Leave this if you want to use default theme font.','sc-core') ,
            'admin_label' => false,
            'weight' => 0,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'group' => esc_html__('Typography','sc-core'),
            'dependency' => array(
                'element' => 'tagline',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'google_fonts',
            'class' => 'title-class',
            'heading' => esc_html__('Change Tagline Typography','sc-core') ,
            'param_name' => 'tagline_google_font_select',
            'settings' => array(
                'fields' => array(
                    'font_family_description' => esc_html__('Select Font Family.','sc-core') ,
                    'font_style_description' => esc_html__('Select Font Style.','sc-core') ,
                ) ,
            ) ,
            'description' => esc_html__('Select Google Font from the list.','sc-core') ,
            'group' => esc_html__('Typography','sc-core'),
            'admin_label' => false,
            'dependency' => array(
                'element' => 'tagline_use_theme_fonts',
                'value' => 'Yes',
            ) ,
        ) ,
        array(
            'admin_label' => false,
            'type' => 'textarea',
            'heading' => esc_html__('Review','sc-core') ,
            'param_name' => 'comment',
            'description' => esc_html__('Enter the review from the client.','sc-core') ,
            'group' => esc_html__('General','sc-core'),
            'dependency' => array(
                'element' => 'testimonials_type',
                'value' => array(
                    'Testimonials_Type_1',
                    'Testimonials_Type_2',
                    'Testimonials_Type_3',
                    'Testimonials_Type_5',
                    'Testimonials_Type_6'
                ) ,
            ) ,
        ) ,
        array(
            'type' => 'textfield',
            'holder' => 'Font Size',
            'class' => 'title-class',
            'heading' => esc_html__('Review Font Size','sc-core') ,
            'description' => esc_html__('Change the font size of the review. Example - 10px','sc-core') ,
            'param_name' => 'comment_font_size',
            'value' => '' ,
            'admin_label' => false,
            'weight' => 0,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'group' => esc_html__('Typography','sc-core'),
            'dependency' => array(
                'element' => 'comment',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Review Text Transform','sc-core') ,
            'param_name' => 'comment_text_transform',
            'class' => 'Title_Text_Transform',
            'admin_label' => false,
            'description' => esc_html__('Transform review text. Example - UPPERCASE or lowercase','sc-core') ,
            'group' => esc_html__('Typography','sc-core'),
            'value' => array(
                esc_html__('Default ','sc-core') => 'Default',
                esc_html__('Uppercase ','sc-core') => 'uppercase',
                esc_html__('Lowercase ','sc-core') => 'lowercase',
            ) ,
            'save_always' => true,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'dependency' => array(
                'element' => 'comment',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'textfield',
            'holder' => 'Font Padding  ',
            'class' => 'title-class',
            'heading' => esc_html__('Review Padding Top & Bottom','sc-core') ,
            'description' => esc_html__('Enter custom Top and Bottom padding around review. Example - 10px','sc-core') ,
            'param_name' => 'comment_padding_top',
            'value' => '' ,
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('Typography','sc-core'),
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'dependency' => array(
                'element' => 'comment',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'textfield',
            'holder' => 'Font Padding  ',
            'class' => 'title-class',
            'heading' => esc_html__('Review Padding Left & Right','sc-core') ,
            'description' => esc_html__('Enter custom Left and Right padding around review. Example - 10px','sc-core') ,
            'param_name' => 'comment_padding_left',
            'value' => '' ,
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('Typography','sc-core'),
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'dependency' => array(
                'element' => 'comment',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'colorpicker',
            'class' => 'title-class',
            'heading' => esc_html__('Review Font Color','sc-core') ,
            'param_name' => 'comment_font_color',
            'description' => esc_html__('Change the font color of review text.','sc-core') ,
            'group' => esc_html__('Typography','sc-core'),
            'admin_label' => false,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'dependency' => array(
                'element' => 'comment',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'checkbox',
            'class' => 'custom_heading_element_use_theme_fonts',
            'heading' => esc_html__('Use Custom Google Font ?','sc-core') ,
            'param_name' => 'comment_use_theme_fonts',
            'value' => array(
                'Yes' => 'Yes',
            ) ,
            'description' => esc_html__('Leave this if you want to use default theme font.','sc-core') ,
            'admin_label' => false,
            'weight' => 0,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'group' => esc_html__('Typography','sc-core'),
            'dependency' => array(
                'element' => 'comment',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'google_fonts',
            'class' => 'title-class',
            'heading' => esc_html__('Select Custom Google Font for Comment','sc-core') ,
            'param_name' => 'comment_google_font_select',
            'settings' => array(
                'fields' => array(
                    'font_family_description' => esc_html__('Select Font Family.','sc-core') ,
                    'font_style_description' => esc_html__('Select Font Style.','sc-core') ,
                ) ,
            ) ,
            'description' => esc_html__('Choose Google Font from list','sc-core') ,
            'group' => esc_html__('Typography','sc-core'),
            'admin_label' => false,
            'dependency' => array(
                'element' => 'comment_use_theme_fonts',
                'value' => 'Yes',
            ) ,
        ) ,
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Rating Stars','sc-core') ,
            'param_name' => 'client_rating',
            'class' => 'Text_float',
            'description' => esc_html__('Enter the rating given by client.','sc-core') ,
            'group' => esc_html__('General','sc-core'),
            'admin_label' => false,
            'edit_field_class' => 'vc_column vc_col-sm-4 crum_vc',
            'value' => array(
                esc_html__('1 star ','sc-core') => '1',
                esc_html__('2 star ','sc-core') => '2',
                esc_html__('3 star ','sc-core') => '3',
                esc_html__('4 star ','sc-core') => '4',
                esc_html__('5 star ','sc-core') => '5',
            ) ,
            'dependency' => array(
                'element' => 'testimonials_type',
                'value' => array(
                    'Testimonials_Type_1'
                ) ,
            ) ,
            'save_always' => true,
        ) ,
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Star Size','sc-core') ,
            'param_name' => 'star_size',
            'class' => 'Text_float',
            'admin_label' => false,
            'description' => esc_html__('Select the size of rating stars.','sc-core') ,
            'group' => esc_html__('General','sc-core'),
            'edit_field_class' => 'vc_column vc_col-sm-4 crum_vc',
            'value' => array(
                esc_html__('Small','sc-core') => 'small',
                esc_html__('Medium','sc-core') => 'medium',
                esc_html__('Large ','sc-core') => 'large',
            ) ,
            'dependency' => array(
                'element' => 'testimonials_type',
                'value' => array(
                    'Testimonials_Type_1'
                ) ,
            ) ,
            'save_always' => true,
        ) ,
        array(
            'type' => 'colorpicker',
            'class' => 'title-class',
            'heading' => esc_html__('Stars Color','sc-core') ,
            'param_name' => 'star_color',
            'admin_label' => false,
            'description' => esc_html__('Change the color of rating stars','sc-core') ,
            'group' => esc_html__('General','sc-core'),
            'edit_field_class' => 'vc_column vc_col-sm-4 crum_vc',
            'dependency' => array(
                'element' => 'testimonials_type',
                'value' => array(
                    'Testimonials_Type_1'
                ) ,
            ) ,
        ) ,
        array(
            'type' => 'textarea_html',
            'holder' => 'div',
            'class' => '',
            'heading' => esc_html__('Content','sc-core') ,
            'param_name' => 'content', // Important: Only one textarea_html param per content element allowed and it should have 'content' as a 'param_name'
            'value' => '' ,
            'description' => esc_html__('Enter your content.','sc-core') ,
            'group' => esc_html__('General','sc-core'),
            'admin_label' => false,
            'dependency' => array(
                'element' => 'testimonials_type',
                'value' => array(
                    'Testimonials_Type_4'
                ) ,
            ) ,
        ) ,
        array(
            'type' => 'textfield',
            'holder' => 'Font Size',
            'class' => 'title-class',
            'heading' => esc_html__('Content Font Size','sc-core') ,
            'description' => esc_html__('Enter custom font size for Content. Example - 15px','sc-core') ,
            'param_name' => 'content_font_size',
            'value' => '' ,
            'admin_label' => false,
            'weight' => 0,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'group' => esc_html__('Typography','sc-core'), 
            'dependency' => array(
                'element' => 'testimonials_type',
                'value' => array(
                    'Testimonials_Type_4'
                ) ,
            ) ,
        ) ,
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Content Text Transform','sc-core') ,
            'param_name' => 'content_text_transform',
            'class' => 'Title_Text_Transform',
            'description' => esc_html__('Transform Content. Example - UPPERCASE or lowercase','sc-core') ,
            'group' => esc_html__('Typography','sc-core'),
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'value' => array(
                esc_html__('Default ','sc-core') => 'Default',
                esc_html__('Uppercase ','sc-core') => 'uppercase',
                esc_html__('Lowercase ','sc-core') => 'lowercase',
            ) ,
            'save_always' => true,
            'admin_label' => false, 
            'dependency' => array(
                'element' => 'testimonials_type',
                'value' => array(
                    'Testimonials_Type_4'
                ) ,
            ) ,
        ) ,
        array(
            'type' => 'textfield',
            'holder' => 'Font Padding ',
            'class' => 'title-class',
            'heading' => esc_html__('Content Padding Top & Bottom','sc-core') ,
            'description' => esc_html__('Enter custom Top and Bottom padding around Content. Example - 10px','sc-core') ,
            'param_name' => 'content_padding_top',
            'value' => '' ,
            'admin_label' => false,
            'weight' => 0,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'group' => esc_html__('Typography','sc-core'),
            'dependency' => array(
                'element' => 'testimonials_type',
                'value' => array(
                    'Testimonials_Type_4'
                ) ,
            ) , 
        ) ,
        array(
            'type' => 'textfield',
            'holder' => 'Font Padding  ',
            'class' => 'title-class',
            'heading' => esc_html__('Content Padding Left & Right','sc-core') ,
            'description' => esc_html__('Enter custom Left and Right padding around Content. Example - 10px','sc-core') ,
            'param_name' => 'content_padding_left',
            'value' => '' ,
            'admin_label' => false,
            'weight' => 0,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'group' => esc_html__('Typography','sc-core'),
            'dependency' => array(
                'element' => 'testimonials_type',
                'value' => array(
                    'Testimonials_Type_4'
                ) ,
            ) , 
        ) ,
        array(
            'type' => 'colorpicker',
            'class' => 'title-class',
            'heading' => esc_html__('Content Font Color','sc-core') ,
            'param_name' => 'content_font_color',
            'description' => esc_html__('Change font color for Content','sc-core') ,
            'group' => esc_html__('Typography','sc-core'),
            'admin_label' => false,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc', 
            'dependency' => array(
                'element' => 'testimonials_type',
                'value' => array(
                    'Testimonials_Type_4'
                ) ,
            ) ,
        ) ,
        array(
            'type' => 'checkbox',
            'class' => 'custom_heading_element_use_theme_fonts',
            'heading' => esc_html__('Use custom Google font ?','sc-core') ,
            'param_name' => 'content_use_theme_fonts',
            'value' => array(
                'Yes' => 'Yes',
            ) ,
            'description' => esc_html__('Leave this if you want to use default theme font.','sc-core') ,
            'admin_label' => false,
            'weight' => 0,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'group' => esc_html__('Typography','sc-core'), 
            'dependency' => array(
                'element' => 'testimonials_type',
                'value' => array(
                    'Testimonials_Type_4'
                ) ,
            ) ,
        ) ,
        array(
            'type' => 'google_fonts',
            'class' => 'title-class',
            'heading' => esc_html__('Change Content Typography','sc-core') ,
            'param_name' => 'content_google_font_select',
            'admin_label' => false,
            'settings' => array(
                'fields' => array(
                    'font_family_description' => esc_html__('Select Font Family.','sc-core') ,
                    'font_style_description' => esc_html__('Select Font Style.','sc-core') ,
                ) ,
            ) ,
            'description' => esc_html__('Select Google Font from the list.','sc-core') ,
            'group' => esc_html__('Typography','sc-core'),
            'dependency' => array(
                'element' => 'content_use_theme_fonts',
                'value' => 'Yes',
            ) ,
        ) ,
        array(
            'type' => 'checkbox',
            'class' => 'custom_contaner',
            'heading' => esc_html__('Twitter  Icon','sc-core') ,
            'param_name' => 'twitter_account_icon',
            'value' => array(
                'Yes' => 'Yes',
            ) ,
            'description' => esc_html__('Enable this option if you want to  show   twitter Icon.','sc-core') , 
            'dependency' => array(
                'element' => 'testimonials_type',
                'value' => array(
                    'Testimonials_Type_4'
                ) ,
            ) ,
            'weight' => 0,
            'group' => esc_html__('General','sc-core'),
            'admin_label' => false,
        ) ,
        array(
            'type' => 'checkbox',
            'class' => 'custom_contaner',
            'heading' => esc_html__('verified twitter account','sc-core') ,
            'param_name' => 'verified_twitter_account',
            'value' => array(
                'Yes' => 'Yes',
            ) ,
            'description' => esc_html__('Enable this option if you want to  show verified twitter account.','sc-core') , 
            'dependency' => array(
                'element' => 'testimonials_type',
                'value' => array(
                    'Testimonials_Type_4'
                ) ,
            ) ,
            'weight' => 0,
            'group' => esc_html__('General','sc-core'),
            'admin_label' => false,
        ) ,
        array(
            'type' => 'el_id',
            'heading' => esc_html__('Element ID','sc-core') ,
            'param_name' => 'el_id',
            'description' => sprintf(__('Enter element ID (Note: make sure it is unique and valid according to ','sc-core').'<a href="%s" target="_blank">'.__('w3c specification','sc-core').'</a>).' , 'http://www.w3schools.com/tags/att_global_id.asp') ,
            'admin_label' => false,
            'group' => esc_html__('General','sc-core'),
        ) ,
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Extra class name','sc-core') ,
            'param_name' => 'el_class',
            'description' => esc_html__('Style particular content element differently - add a class name and refer to it in custom CSS.','sc-core') ,
            'admin_label' => false,
            'group' => esc_html__('General','sc-core'),
        ) ,
        array(
            'type' => 'css_editor',
            'heading' => esc_html__('Css','sc-core') ,
            'param_name' => 'css',
            'admin_label' => false,
            'group' => esc_html__('Style','sc-core'),
        ) ,
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'External Image link for Template','sc-core' ),  
            'param_name' => 'slcr_img_link_template',  
            'group' => esc_html__('General','sc-core'),
            'content_element'=>false,
        ),
    ) ,
);
?>