<?php
/** 
 * The SlashCreative VC Element 
 *
 * @author     SlashCreative
 * @copyright  (c) Copyright by SlashCreative
 * @link       http://slashcreative.co
 * @package    SC-CORE
 * @subpackage Core
 * @since      1.1.0
 *
 * Element Description: Memberset Mapping
 */
if ( ! defined( 'ABSPATH' ) ) {
    die( '-1' );
}
 
  
// ************************   Team Member  element setting   ***************************//////
// Element Mapping
 
return array(
    'name' => esc_html__('Team Member Item','sc-core') ,
    'base' => 'team_member_item',
    'show_settings_on_create' => true,
    // 'is_container' => true,
    'description' => esc_html__('Add single team member.','sc-core') ,
    'category' => esc_html__('SC Elements','sc-core') ,
    'icon' => SLCR_CORE_VC_ELEMENT_ICON_URI . 'team-single.png',
    'params' => array(
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Select Team Members Type','sc-core') ,
            'param_name' => 'team_members_type',
            'class' => 'title-class',
            'value' => array(
                esc_html__('Team Members Type 1','sc-core') => 'Team_Members_Type_1',
                esc_html__('Team Members Type 2','sc-core') => 'Team_Members_Type_2',
                esc_html__('Team Members Type 3','sc-core') => 'Team_Members_Type_3',
                esc_html__('Team Members Type 4','sc-core') => 'Team_Members_Type_4',
                esc_html__('Team Members Type 5','sc-core') => 'Team_Members_Type_5',
                esc_html__('Team Members Type 6','sc-core') => 'Team_Members_Type_6',
                esc_html__('Team Members Type 7','sc-core') => 'Team_Members_Type_7',
            ) ,
            'save_always' => true,
            'admin_label' => false,
            'group' => esc_html__('General','sc-core'),
            'description' => esc_html__('Select Type of Team Members section. ( Other Input Fields will automatically open and close according to your selections )','sc-core')
        ) ,
        array(
            'type' => 'attach_image',
            'heading' => esc_html__('Avatar','sc-core') ,
            'param_name' => 'image',
            'value' => '',
            'admin_label' => false,
            'description' => esc_html__('Select an avatar for team member.','sc-core') ,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'group' => esc_html__('General','sc-core'),
        ) ,
        array(
            'type' => 'textfield',
            'class' => 'title-class',
            'heading' => esc_html__('Avatar Border Radius','sc-core') ,
            'description' => esc_html__('Change the border radius for avatar image. Example - 50%','sc-core') ,
            'param_name' => 'member_border_radius',
            'value' => '' ,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'admin_label' => false,
            'weight' => 0, 
            'group' => esc_html__('General','sc-core'),
        ) ,
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Member Image Switch ','sc-core') ,
            'param_name' => 'member_image_switch',
            'class' => 'Text_float',
            'description' => esc_html__('Switch the position of Image','sc-core') ,
            'group' => esc_html__('General','sc-core'),
            'admin_label' => false,
            'value' => array(
                esc_html__('Switch Left ','sc-core') => 'left',
                esc_html__('Switch Right ','sc-core') => 'right',
            ) ,
            'dependency' => array(
                'element' => 'team_members_type',
                'value' => array(
                    'Team_Members_Type_7'
                ) ,
            ) ,
            'save_always' => true,
        ) ,
        array(
            'admin_label' => false,
            'type' => 'textfield',
            'heading' => esc_html__('Team Member Name','sc-core') ,
            'param_name' => 'name',
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'description' => esc_html__('Enter the name of team member.','sc-core') ,
            'group' => esc_html__('General','sc-core'),
        ) , 
        array(
            'type' => 'textfield',
            'holder' => 'Font Size',
            'class' => 'title-class',
            'heading' => esc_html__('Name Font Size','sc-core') ,
            'description' => esc_html__('Change the font size of team member name. Example - 15px','sc-core') ,
            'param_name' => 'member_font_size',
            'value' => '' ,
            'admin_label' => false,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'weight' => 0,
            'group' => esc_html__('Typography','sc-core'),
            'dependency' => array(
                'element' => 'name',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Name Text Transform ','sc-core') ,
            'param_name' => 'member_text_transform',
            'class' => 'Title_Text_Transform',
            'description' => esc_html__('Transform team member name. Example - UPPERCASE, lowercase','sc-core') ,
            'group' => esc_html__('Typography','sc-core'),
            'admin_label' => false,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'value' => array(
                esc_html__('Default ','sc-core') => 'Default',
                esc_html__('Uppercase ','sc-core') => 'uppercase',
                esc_html__('Lowercase ','sc-core') => 'lowercase',
            ) ,
            'save_always' => true,
            'dependency' => array(
                'element' => 'name',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'textfield',
            'holder' => 'Font Padding  ',
            'class' => 'title-class',
            'heading' => esc_html__('Name Padding Top and Bottom','sc-core') ,
            'description' => esc_html__('Change the padding from top and bottom around the team member name.','sc-core') ,
            'param_name' => 'member_padding_top',
            'value' => '' ,
            'admin_label' => false,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'weight' => 0,
            'group' => esc_html__('Typography','sc-core'),
            'dependency' => array(
                'element' => 'name',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'textfield',
            'holder' => 'Font Padding  ',
            'class' => 'title-class',
            'heading' => esc_html__('Name Padding Left and Right','sc-core') ,
            'description' => esc_html__('Change the padding from left and right around the team member name.','sc-core') ,
            'param_name' => 'member_padding_left',
            'value' => '' ,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('Typography','sc-core'),
            'dependency' => array(
                'element' => 'name',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'colorpicker',
            'class' => 'title-class',
            'heading' => esc_html__('Name Font Color','sc-core') ,
            'param_name' => 'member_font_color',
            'description' => esc_html__('Change font color for Member\'s name','sc-core') ,
            'group' => esc_html__('Typography','sc-core'),
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'dependency' => array(
                'element' => 'name',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'checkbox',
            'class' => 'custom_heading_element_use_theme_fonts',
            'heading' => esc_html__('Use custom Google font ?','sc-core') ,
            'param_name' => 'member_use_theme_fonts',
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'value' => array(
                'Yes' => 'Yes',
            ) ,
            'description' => esc_html__('Leave this if you want to use default theme font.','sc-core') ,
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('Typography','sc-core'),
            'dependency' => array(
                'element' => 'name',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'google_fonts',
            'class' => 'title-class',
            'heading' => esc_html__('Change Name Typography','sc-core') ,
            'param_name' => 'member_google_font_select',
            'settings' => array(
                'fields' => array(
                    'font_family_description' => esc_html__('Select Font Family.','sc-core') ,
                    'font_style_description' => esc_html__('Select Font Style.','sc-core') ,
                ) ,
            ) ,
            'description' => esc_html__('Select Google Font from the list.','sc-core') ,
            'group' => esc_html__('Typography','sc-core'),
            'admin_label' => false,
            'dependency' => array(
                'element' => 'member_use_theme_fonts',
                'value' => 'Yes',
            ) ,
        ) ,
        array(
            'admin_label' => false,
            'type' => 'textfield',
            'heading' => esc_html__('Job Title','sc-core') ,
            'param_name' => 'job_position',
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'group' => esc_html__('General','sc-core'),
            'description' => esc_html__('Enter the job title of team member. Example - Developer, Designer','sc-core')
        ) , 
        array(
            'type' => 'textfield',
            'holder' => 'Font Size',
            'class' => 'title-class',
            'heading' => esc_html__('Job Title Font Size','sc-core') ,
            'description' => esc_html__('Change the font size of job title. Example - 15px','sc-core') ,
            'param_name' => 'position_font_size',
            'value' => '' ,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('Typography','sc-core'),
            'dependency' => array(
                'element' => 'job_position',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Job Title Text Transform ','sc-core') ,
            'param_name' => 'position_text_transform',
            'class' => 'Title_Text_Transform',
            'description' => esc_html__('Transform the job title text. Example - UPPERCASE, lowercase.','sc-core') ,
            'group' => esc_html__('Typography','sc-core'),
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'dependency' => array(
                'element' => 'job_position',
                'not_empty' => true,
            ) ,
            'value' => array(
                esc_html__('Default ','sc-core') => 'Default',
                esc_html__('Uppercase ','sc-core') => 'uppercase',
                esc_html__('Lowercase ','sc-core') => 'lowercase',
            ) ,
            'save_always' => true,
            'admin_label' => false,
        ) ,
        array(
            'type' => 'textfield',
            'holder' => 'Font Padding  ',
            'class' => 'title-class',
            'heading' => esc_html__('Job Title Padding Top and Bottom','sc-core') ,
            'description' => esc_html__('Change the padding from top and bottom around job title. Example - 10px','sc-core') ,
            'param_name' => 'position_padding_top',
            'value' => '' ,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'admin_label' => false,
            'dependency' => array(
                'element' => 'job_position',
                'not_empty' => true,
            ) ,
            'weight' => 0,
            'group' => esc_html__('Typography','sc-core'),
        ) ,
        array(
            'type' => 'textfield',
            'holder' => 'Font Padding  ',
            'class' => 'title-class',
            'heading' => esc_html__('Job Title Padding Left and Right','sc-core') ,
            'description' => esc_html__('Change the padding from top and bottom around job title. Example - 10px','sc-core') ,
            'param_name' => 'position_padding_left',
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'value' => '' ,
            'admin_label' => false,
            'dependency' => array(
                'element' => 'job_position',
                'not_empty' => true,
            ) ,
            'weight' => 0,
            'group' => esc_html__('Typography','sc-core'),
        ) ,
        array(
            'type' => 'colorpicker',
            'class' => 'title-class',
            'heading' => esc_html__('Job Title Font color','sc-core') ,
            'param_name' => 'position_font_color',
            'description' => esc_html__('Change the font color of job title.','sc-core') ,
            'group' => esc_html__('Typography','sc-core'),
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'admin_label' => false,
            'dependency' => array(
                'element' => 'job_position',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'checkbox',
            'class' => 'custom_heading_element_use_theme_fonts',
            'heading' => esc_html__('Use custom Google Font ?','sc-core') ,
            'param_name' => 'position_use_theme_fonts',
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'value' => array(
                'Yes' => 'Yes',
            ) ,
            'description' => esc_html__('Leave this if you want to use default theme font.','sc-core') ,
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('Typography','sc-core'),
            'dependency' => array(
                'element' => 'job_position',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'google_fonts',
            'class' => 'title-class',
            'heading' => esc_html__('Change Job Title Typography','sc-core') ,
            'param_name' => 'position_google_font_select',
            'settings' => array(
                'fields' => array(
                    'font_family_description' => esc_html__('Select Font Family.','sc-core') ,
                    'font_style_description' => esc_html__('Select Font Style.','sc-core') ,
                ) ,
            ) ,
            'description' => esc_html__('Select Google Font from the list.','sc-core') ,
            'group' => esc_html__('Typography','sc-core'),
            'admin_label' => false,
            'dependency' => array(
                'element' => 'position_use_theme_fonts',
                'value' => 'Yes',
            ) ,
        ) ,
        array(
            'admin_label' => false,
            'type' => 'textarea',
            'heading' => esc_html__('Description','sc-core') ,
            'param_name' => 'desc',
            'description' => esc_html__('Enter some description about the team member.','sc-core') ,
            'group' => esc_html__('General','sc-core'),
            'dependency' => array(
                'element' => 'team_members_type',
                'value' => array(
                    'Team_Members_Type_3',
                    'Team_Members_Type_4',
                    'Team_Members_Type_7'
                ) ,
            ) ,
        ) ,
        array(
            'type' => 'vc_link',
            'class' => 'custom_heading_element_link',
            'heading' => esc_html__('URL (Link)','sc-core') ,
            'param_name' => 'link',
            'description' => esc_html__('Add an external link to the team member.','sc-core') ,
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('General','sc-core'),
            'dependency' => array(
                'element' => 'team_members_type',
                'value' => array(
                    'Team_Members_Type_3'
                ) ,
            ) ,
        ) , 
        array(
            'type' => 'textfield',
            'holder' => 'Font Size',
            'class' => 'title-class',
            'heading' => esc_html__('Description Font Size','sc-core') ,
            'description' => esc_html__('Change the font size of description text. Example - 15px','sc-core') ,
            'param_name' => 'description_font_size',
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'value' => '' ,
            'admin_label' => false,
            
            'weight' => 0,
            'group' => esc_html__('Typography','sc-core'),
            'dependency' => array(
                'element' => 'desc',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Description Text Transform','sc-core') ,
            'param_name' => 'description_text_transform',
            'class' => 'Title_Text_Transform',
            'description' => esc_html__('Transform the description text. Example - UPPERCASE, lowercase','sc-core') ,
            'group' => esc_html__('Typography','sc-core'),
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'value' => array(
                esc_html__('Default ','sc-core') => 'Default',
                esc_html__('Uppercase ','sc-core') => 'uppercase',
                esc_html__('Lowercase ','sc-core') => 'lowercase',
            ) ,
            'save_always' => true,
            'admin_label' => false,
            'dependency' => array(
                'element' => 'desc',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'textfield',
            'holder' => 'Font Padding  ',
            'class' => 'title-class',
            'heading' => esc_html__('Description Padding Top and Bottom','sc-core') ,
            'description' => esc_html__('Change the padding from top and bottom around the description. Example - 10px','sc-core') ,
            'param_name' => 'description_padding_top',
            'value' => '' ,
            'admin_label' => false,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'weight' => 0,
            'group' => esc_html__('Typography','sc-core'),
            'dependency' => array(
                'element' => 'desc',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'textfield',
            'holder' => 'Font Padding  ',
            'class' => 'title-class',
            'heading' => esc_html__('Description Padding Left and Right','sc-core') ,
            'description' => esc_html__('Change the padding from left and right around the description. Example - 10px','sc-core') ,
            'param_name' => 'description_padding_left',
            'value' => '' ,
            'admin_label' => false,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'weight' => 0,
            'group' => esc_html__('Typography','sc-core'),
            'dependency' => array(
                'element' => 'desc',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'colorpicker',
            'class' => 'title-class',
            'heading' => esc_html__('Description Font Color','sc-core') ,
            'param_name' => 'description_font_color',
            'description' => esc_html__('Choose custom Font Color for Description','sc-core') ,
            'group' => esc_html__('Typography','sc-core'),
            'admin_label' => false,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'dependency' => array(
                'element' => 'team_members_type',
                'value' => array(
                    'Team_Members_Type_3',
                    'Team_Members_Type_4',
                    'Team_Members_Type_7'
                ) ,
            ) ,
        ) ,
        array(
            'type' => 'checkbox',
            'class' => 'custom_heading_element_use_theme_fonts',
            'heading' => esc_html__('Use Custom Google Font ?','sc-core') ,
            'param_name' => 'description_use_theme_fonts',
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'value' => array(
                'Yes' => 'Yes',
            ) ,
            'description' => esc_html__('Leave this if you want to use default theme font.','sc-core') ,
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('Typography','sc-core'),
            'dependency' => array(
                'element' => 'desc',
                'not_empty' => true,
            ) ,
        ) ,
        array(
            'type' => 'google_fonts',
            'class' => 'title-class',
            'heading' => esc_html__('Select Custom Google Font for Description','sc-core') ,
            'param_name' => 'description_google_font_select',
            'settings' => array(
                'fields' => array(
                    'font_family_description' => esc_html__('Select Font Family.','sc-core') ,
                    'font_style_description' => esc_html__('Select Font Style.','sc-core') ,
                ) ,
            ) ,
            'description' => esc_html__('Choose Google Font from list','sc-core') ,
            'group' => esc_html__('Typography','sc-core'),
            'admin_label' => false,
            'dependency' => array(
                'element' => 'description_use_theme_fonts',
                'value' => 'Yes',
            ) ,
        ) , 
        array(
            'type' => 'colorpicker',
            'class' => 'title-class',
            'heading' => esc_html__('Social Links Font color','sc-core') ,
            'param_name' => 'social_link_color',
            'description' => esc_html__('Change the color of social link text.','sc-core') ,
            'group' => esc_html__('social','sc-core'),
            'admin_label' => false,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'dependency' => array(
                'element' => 'team_members_type',
                'value' => array(
                    'Team_Members_Type_4'
                ) ,
            ) ,
        ) ,
        array(
            'type' => 'colorpicker',
            'class' => 'title-class',
            'heading' => esc_html__('Social Icon color','sc-core') ,
            'param_name' => 'social_icon_color',
            'description' => esc_html__('Change the color of social icons.','sc-core') ,
            'group' => esc_html__('social','sc-core'),
            'admin_label' => false,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'dependency' => array(
                'element' => 'team_members_type',
                'value' => array(
                    'Team_Members_Type_1',
                    'Team_Members_Type_2',
                    'Team_Members_Type_5',
                    'Team_Members_Type_6',
                    'Team_Members_Type_7', 
                ) ,
            ) ,
        ) , 

        array(
            'type' => 'textfield',
            'holder' => 'Font Size',
            'class' => 'title-class',
            'heading' => esc_html__('Social Icon Size','sc-core') ,
            'description' => esc_html__('Change the font size of social icons. Example - 15px','sc-core') ,
            'param_name' => 'social_icon_font_size',
            'value' => '' ,
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('social','sc-core'),
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'dependency' => array(
                'element' => 'team_members_type',
                'value' => array(
                    'Team_Members_Type_1',
                    'Team_Members_Type_2',
                    'Team_Members_Type_5',
                    'Team_Members_Type_6',
                    'Team_Members_Type_7', 
                ) ,
            ) ,
        ) ,
        array(
            'type' => 'textfield',
            'class' => ' ',
            'heading' => esc_html__('Social Icon 1','sc-core') ,
            'description' => esc_html__('Just enter the name of desired social website in lowercase. Example - facebook','sc-core') ,
            'param_name' => 'social_link_icon_1',
            'value' => '' ,
            'admin_label' => false,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'weight' => 0,
            'group' => esc_html__('social','sc-core'),
            'dependency' => array(
                'element' => 'team_members_type',
                'value' => array(
                    'Team_Members_Type_1',
                    'Team_Members_Type_2',
                    'Team_Members_Type_5',
                    'Team_Members_Type_6',
                    'Team_Members_Type_7', 
                ) ,
            ) , 
        ) ,
        array(
            'type' => 'textfield',
            'class' => 'title-class',
            'heading' => esc_html__('Social Link Text 1  ','sc-core') ,
            'description' => esc_html__('Enter the name of desired social website to show as link. Example - Twitter','sc-core') ,
            'param_name' => 'social_link_text_1',
            'value' => '' ,
            'admin_label' => false,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'weight' => 0,
            'group' => esc_html__('social','sc-core'),
            'dependency' => array(
                'element' => 'team_members_type',
                'value' => array(
                    'Team_Members_Type_4'
                ) ,
            ) ,
        ) ,
        array(
            'type' => 'vc_link',
            'class' => 'title-class',
            'heading' => esc_html__('Social Link 1','sc-core') ,
            'param_name' => 'social_link_1',
            'description' => esc_html__('Add link to social profile','sc-core') ,
            'admin_label' => false,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'weight' => 0,
            'group' => esc_html__('social','sc-core'), 
            'dependency' => array(
                'element' => 'team_members_type',
                'value' => array(
                    'Team_Members_Type_1',
                    'Team_Members_Type_2',
                    'Team_Members_Type_4',
                    'Team_Members_Type_5',
                    'Team_Members_Type_6',
                    'Team_Members_Type_7', 
                ) ,
            ) ,
        ) ,
        array(
            'type' => 'textfield',
            'class' => 'title-class',
            'heading' => esc_html__('Social Icon 2','sc-core') ,
            'description' => esc_html__('Just enter the name of desired social website in lowercase. eg( facebook )','sc-core') ,
            'param_name' => 'social_link_icon_2',
            'value' => '' ,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('social','sc-core'), 
            'dependency' => array(
                'element' => 'team_members_type',
                'value' => array(
                    'Team_Members_Type_1',
                    'Team_Members_Type_2',
                    'Team_Members_Type_5',
                    'Team_Members_Type_6',
                    'Team_Members_Type_7', 
                ) ,
            ) ,
        ) ,
        array(
            'type' => 'textfield',
            'class' => 'title-class',
            'heading' => esc_html__('Social Link Text 2  ','sc-core') ,
            'description' => esc_html__('Enter the name of desired social website to show as link.  eg( Twitter )','sc-core') ,
            'param_name' => 'social_link_text_2',
            'value' => '' ,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'admin_label' => false,
            'weight' => 0,
            'group' => esc_html__('social','sc-core'),
            'dependency' => array(
                'element' => 'team_members_type',
                'value' => array(
                    'Team_Members_Type_4'
                ) ,
            ) ,
        ) ,
        array(
            'type' => 'vc_link',
            'class' => 'title-class',
            'heading' => esc_html__('Social Link 2','sc-core') ,
            'param_name' => 'social_link_2',
            'description' => esc_html__('Add link to social profile','sc-core') ,
            'admin_label' => false,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'weight' => 0,
            'group' => esc_html__('social','sc-core'),
            'dependency' => array(
                'element' => 'team_members_type',
                'value' => array(
                    'Team_Members_Type_1',
                    'Team_Members_Type_2',
                    'Team_Members_Type_4',
                    'Team_Members_Type_5',
                    'Team_Members_Type_6',
                    'Team_Members_Type_7', 
                ) ,
            ) , 
        ) ,
        array(
            'type' => 'textfield',
            'class' => 'title-class',
            'heading' => esc_html__('Social Icon 3','sc-core') ,
            'description' => esc_html__('Just enter the name of desired social website in lowercase. eg( facebook )','sc-core') ,
            'param_name' => 'social_link_icon_3',
            'value' => '' ,
            'admin_label' => false,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'weight' => 0,
            'group' => esc_html__('social','sc-core'), 
            'dependency' => array(
                'element' => 'team_members_type',
                'value' => array(
                    'Team_Members_Type_1',
                    'Team_Members_Type_2',
                    'Team_Members_Type_5',
                    'Team_Members_Type_6',
                    'Team_Members_Type_7', 
                ) ,
            ) ,
        ) ,
        array(
            'type' => 'textfield',
            'class' => 'title-class',
            'heading' => esc_html__('social link text 3  ','sc-core') ,
            'description' => esc_html__('Enter the name of desired social website to show as link.  eg( Twitter )','sc-core') ,
            'param_name' => 'social_link_text_3',
            'value' => '' ,
            'admin_label' => false,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'weight' => 0,
            'group' => esc_html__('social','sc-core'),
            'dependency' => array(
                'element' => 'team_members_type',
                'value' => array(
                    'Team_Members_Type_4'
                ) ,
            ) ,
        ) ,
        array(
            'type' => 'vc_link',
            'class' => 'title-class',
            'heading' => esc_html__('Social Link 3','sc-core') ,
            'param_name' => 'social_link_3',
            'description' => esc_html__('Add link to social profile','sc-core') ,
            'admin_label' => false,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'weight' => 0,
            'group' => esc_html__('social','sc-core'), 
            'dependency' => array(
                'element' => 'team_members_type',
                'value' => array(
                    'Team_Members_Type_1',
                    'Team_Members_Type_2',
                    'Team_Members_Type_4',
                    'Team_Members_Type_5',
                    'Team_Members_Type_6',
                    'Team_Members_Type_7', 
                ) ,
            ) ,
        ) ,
        array(
            'type' => 'textfield',
            'class' => 'title-class',
            'heading' => esc_html__('Social Icon 4','sc-core') ,
            'description' => esc_html__('Just enter the name of desired social website in lowercase. eg( facebook )','sc-core') ,
            'param_name' => 'social_link_icon_4',
            'value' => '' ,
            'admin_label' => false,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'weight' => 0,
            'group' => esc_html__('social','sc-core'), 'dependency' => array(
                'element' => 'team_members_type',
                'value' => array(
                    'Team_Members_Type_1',
                    'Team_Members_Type_2',
                    'Team_Members_Type_5',
                    'Team_Members_Type_6',
                    'Team_Members_Type_7', 
                ) ,
            ) ,
        ) ,
        array(
            'type' => 'textfield',
            'class' => 'title-class',
            'heading' => esc_html__('social link text 4  ','sc-core') ,
            'description' => esc_html__('Enter the name of desired social website to show as link.  eg( Twitter )','sc-core') ,
            'param_name' => 'social_link_text_4',
            'value' => '' ,
            'admin_label' => false,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'weight' => 0,
            'group' => esc_html__('social','sc-core'),
            'dependency' => array(
                'element' => 'team_members_type',
                'value' => array(
                    'Team_Members_Type_4'
                ) ,
            ) ,
        ) ,
        array(
            'type' => 'vc_link',
            'class' => 'title-class',
            'heading' => esc_html__('Social Link 4','sc-core') ,
            'param_name' => 'social_link_4',
            'description' => esc_html__('Add link to social profile','sc-core') ,
            'admin_label' => false,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'weight' => 0,
            'group' => esc_html__('social','sc-core'), 
            'dependency' => array(
                'element' => 'team_members_type',
                'value' => array(
                    'Team_Members_Type_1',
                    'Team_Members_Type_2',
                    'Team_Members_Type_4',
                    'Team_Members_Type_5',
                    'Team_Members_Type_6',
                    'Team_Members_Type_7', 
                ) ,
            ) ,
        ) ,
        array(
            'type' => 'textfield',
            'class' => 'title-class',
            'heading' => esc_html__('Social Icon 5','sc-core') ,
            'description' => esc_html__('Just enter the name of desired social website in lowercase. eg( facebook )','sc-core') ,
            'param_name' => 'social_link_icon_5',
            'value' => '' ,
            'admin_label' => false,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'weight' => 0,
            'group' => esc_html__('social','sc-core'), 
            'dependency' => array(
                'element' => 'team_members_type',
                'value' => array(
                    'Team_Members_Type_1',
                    'Team_Members_Type_2',
                    'Team_Members_Type_5',
                    'Team_Members_Type_6',
                    'Team_Members_Type_7', 
                ) ,
            ) ,
        ) ,
        array(
            'type' => 'textfield',
            'class' => 'title-class',
            'heading' => esc_html__('social link text 5  ','sc-core') ,
            'description' => esc_html__('Enter the name of desired social website to show as link.  eg( Twitter )','sc-core') ,
            'param_name' => 'social_link_text_5',
            'value' => '' ,
            'admin_label' => false,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'weight' => 0,
            'group' => esc_html__('social','sc-core'),
            'dependency' => array(
                'element' => 'team_members_type',
                'value' => array(
                    'Team_Members_Type_4'
                ) ,
            ) ,
        ) ,
        array(
            'type' => 'vc_link',
            'class' => 'title-class',
            'heading' => esc_html__('Social Link 5','sc-core') ,
            'param_name' => 'social_link_5',
            'description' => esc_html__('Add link to social profile','sc-core') ,
            'admin_label' => false,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'weight' => 0,
            'group' => esc_html__('social','sc-core'), 
            'dependency' => array(
                'element' => 'team_members_type',
                'value' => array(
                    'Team_Members_Type_1',
                    'Team_Members_Type_2',
                    'Team_Members_Type_4',
                    'Team_Members_Type_5',
                    'Team_Members_Type_6',
                    'Team_Members_Type_7', 
                ) ,
            ) ,
        ) ,
        array(
            'type' => 'textfield',
            'class' => 'title-class',
            'heading' => esc_html__('Social Icon 6','sc-core') ,
            'description' => esc_html__('Just enter the name of desired social website in lowercase. eg( facebook )','sc-core') ,
            'param_name' => 'social_link_icon_6',
            'value' => '' ,
            'admin_label' => false,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'weight' => 0,
            'group' => esc_html__('social','sc-core'), 
            'dependency' => array(
                'element' => 'team_members_type',
                'value' => array(
                    'Team_Members_Type_1',
                    'Team_Members_Type_2',
                    'Team_Members_Type_5',
                    'Team_Members_Type_6',
                    'Team_Members_Type_7', 
                ) ,
            ) ,
        ) ,
        array(
            'type' => 'textfield',
            'class' => 'title-class',
            'heading' => esc_html__('social link text 6  ','sc-core') ,
            'description' => esc_html__('Enter the name of desired social website to show as link.  eg( Twitter )','sc-core') ,
            'param_name' => 'social_link_text_6',
            'value' => '' ,
            'admin_label' => false,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'weight' => 0,
            'group' => esc_html__('social','sc-core'),
            'dependency' => array(
                'element' => 'team_members_type',
                'value' => array(
                    'Team_Members_Type_4'
                ) ,
            ) ,
        ) ,
        array(
            'type' => 'vc_link',
            'class' => 'title-class',
            'heading' => esc_html__('Social Link 6','sc-core') ,
            'param_name' => 'social_link_6',
            'description' => esc_html__('Add link to social profile','sc-core') ,
            'admin_label' => false,
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'weight' => 0,
            'group' => esc_html__('social','sc-core'), 
            'dependency' => array(
                'element' => 'team_members_type',
                'value' => array(
                    'Team_Members_Type_1',
                    'Team_Members_Type_2',
                    'Team_Members_Type_4',
                    'Team_Members_Type_5',
                    'Team_Members_Type_6',
                    'Team_Members_Type_7', 
                ) ,
            ) ,
        ) , 
        array(
            'type' => 'checkbox',
            'class' => 'custom_heading_element_use_theme_fonts',
            'heading' => esc_html__('Avatar Effect On Hover','sc-core') ,
            'param_name' => 'member_avatar_scale',
            'value' => array(
                'Yes' => 'Yes',
            ) ,
            'description' => esc_html__('Enable the scale effect on hover.','sc-core') , 
            'weight' => 0,
            'group' => esc_html__('General','sc-core'), 
            'admin_label' => false,
            'dependency' => array(
                'element' => 'team_members_type',
                'value' => array(
                    'Team_Members_Type_2',
                    'Team_Members_Type_6',
                    'Team_Members_Type_1'
                ) ,
            ) ,
        ) ,
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Extra class name','sc-core') ,
            'param_name' => 'el_class',
            'description' => esc_html__('If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.','sc-core') ,
            'group' => esc_html__('General','sc-core'),
            'admin_label' => false,
        ) ,
        array(
            'type' => 'css_editor',
            'heading' => esc_html__('Css','sc-core') ,
            'param_name' => 'css',
            'admin_label' => false,
            'group' => esc_html__('Style','sc-core'),
        ) ,
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'External Image link for Template','sc-core' ),  
            'param_name' => 'slcr_img_link_template',  
            'group' => esc_html__('General','sc-core'),
            'content_element'=>false,
        ),
    ) ,
);
       
?>