<?php
/** 
 * The SlashCreative VC Element 
 *
 * @author     SlashCreative
 * @copyright  (c) Copyright by SlashCreative
 * @link       http://slashcreative.co
 * @package    SC-CORE
 * @subpackage Core
 * @since      1.0.0
 *
 * Element Description: Slcr Carousel
 */
if ( ! defined( 'ABSPATH' ) ) {
    die( '-1' );
}
return array(
    'name' => esc_html__('Carousel','sc-core') ,
    'base' => 'slcr_carousel',
    'icon' => SLCR_CORE_VC_ELEMENT_ICON_URI . 'carousel.png',
    'class' => 'vc_icon_content_box',
    'as_parent' => array(
        'except' => 'slcr_carousel'
    ) ,
    // 'as_parent' => '',
    // /'content_element' => true,
    'controls' => 'full',
    'show_settings_on_create' => true,
    // 'is_container'    => true,
    'category' => esc_html__('SC Elements','sc-core') ,
    'description' => esc_html__('Content carousel powered by OWL.','sc-core') ,
    'js_view' => 'VcColumnView',
    'params' => array(
        array(
            'type' => 'checkbox',
            'class' => '',
            'heading' => esc_html__('Enable Loop','sc-core') ,
            'param_name' => 'slcr_carousel_loop', 
            'description' => esc_html__('Enable this option turn on the loop.','sc-core') , 
            'edit_field_class' => 'vc_column vc_col-sm-4 crum_vc',
            'weight' => 0,
            'admin_label' => false,
            'group' => esc_html__('General','sc-core'), 
        ) , 
        array(
            'type' => 'checkbox',
            'class' => '',
            'heading' => esc_html__('Autoplay','sc-core') ,
            'param_name' => 'slcr_carousel_autoplay', 
            'description' => esc_html__('Check this option to enable autoplay.','sc-core') , 
            'edit_field_class' => 'vc_column vc_col-sm-4 crum_vc padding-custom',
            'weight' => 0,
            'group' => esc_html__('General','sc-core'), 
            'admin_label' => false,
        ) ,
        array(
            'type' => 'textfield', 
            'class' => 'count-class',
            'heading' => esc_html__('Items Margin','sc-core') ,
            'description' => __('Add a margin between carousel items.','sc-core').'<br/>'.__(' Example - 15 "Note - Do not use px here"','sc-core') ,
            'param_name' => 'slcr_carousel_margin', 
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'weight' => 0,
            'group' => esc_html__('General','sc-core'), 
            'admin_label' => false,
        ) ,
        array(
            'type' => 'textfield', 
            'class' => 'count-class',
            'heading' => esc_html__('Stage Padding','sc-core') ,
            'description' => __('Enter the stage padding if you want to use.','sc-core').'<br/>'.__(' Example - 100 "Note - Do not use px here"','sc-core') ,
            'param_name' => 'slcr_carousel_stage_padding', 
            'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
            'weight' => 0,
            'group' => esc_html__('General','sc-core'), 
            'admin_label' => false,
        ) , 
        array(
            'type' => 'textfield', 
            'class' => 'count-class',
            'heading' => esc_html__('Carousel Speed','sc-core') ,
            'description' => esc_html__('Change the animation speed of carousel. Example - 1000','sc-core') ,
            'param_name' => 'slcr_carousel_smartspeed', 
            'weight' => 0,
            'group' => esc_html__('General','sc-core'), 
            'admin_label' => false,
        ) ,
        array(
            'type' => 'animation_style', 
            'class' => 'custom_heading_element_css_animation',
            'heading' => esc_html__( 'Animation In','sc-core'),
            'param_name' => 'slcr_carousel_css_animation_in', 
            'description' => __( 'Select type of animation for element to be animated when it \"enters\" the browsers viewport (Note: works only in modern browsers).','sc-core'), 
            'weight' => 0,
            'group' => esc_html__('General','sc-core'),
            'admin_label' => false,
        ) , 
        array(
            'type' => 'animation_style', 
            'class' => 'custom_heading_element_css_animation',
            'heading' => esc_html__( 'Animation Out','sc-core'),
            'param_name' => 'slcr_carousel_css_animation_out', 
            'description' => __( 'Select type of animation for element to be animated when it \"enters\" the browsers viewport (Note: works only in modern browsers).','sc-core'), 
            'weight' => 0,
            'group' => esc_html__('General','sc-core'),
            'admin_label' => false,
        ) ,
        array(
            'type' => 'textfield', 
            'class' => 'count-class',
            'heading' => esc_html__('Items on Desktop','sc-core') ,
            'description' => esc_html__('Number of visible items on desktop. Example - 3','sc-core') ,
            'param_name' => 'slcr_carousel_no_item_pc', 
            'weight' => 0,
            'edit_field_class' => 'vc_column vc_col-sm-4 crum_vc',
            'group' => esc_html__('Responsive','sc-core'),
            'admin_label' => false, 
        ) , 
        array(
            'type' => 'checkbox',
            'class' => '',
            'heading' => esc_html__('Arrow Nav on Desktop','sc-core') ,
            'param_name' => 'slcr_carousel_nav_pc', 
            'description' => esc_html__('Enable arrows nav on desktop view.','sc-core') , 
            'weight' => 0,
            'edit_field_class' => 'vc_column vc_col-sm-4 crum_vc padding-custom',
            'group' => esc_html__('Responsive','sc-core'),
            'admin_label' => false,  
        ) ,
        array(
            'type' => 'checkbox',
            'class' => '',
            'heading' => esc_html__('Dots Nav on Desktop','sc-core') ,
            'param_name' => 'slcr_carousel_dots_pc', 
            'description' => esc_html__('Enable dots nav on desktop view.','sc-core') , 
            'weight' => 0,
            'edit_field_class' => 'vc_column vc_col-sm-4 crum_vc padding-custom',
            'group' => esc_html__('Responsive','sc-core'),
            'admin_label' => false,  
        ) ,
        array(
            'type' => 'textfield', 
            'class' => 'count-class',
            'heading' => esc_html__('Items on Tablet','sc-core') ,
            'description' => esc_html__('Number of visible items on tablet. Example - 3','sc-core') ,
            'param_name' => 'slcr_carousel_no_item_tab', 
            'weight' => 0,
            'edit_field_class' => 'vc_column vc_col-sm-4 crum_vc',
            'group' => esc_html__('Responsive','sc-core'), 
            'admin_label' => false,
        ) , 
        array(
            'type' => 'checkbox',
            'class' => '',
            'heading' => esc_html__('Arrow Nav on Tablet','sc-core') ,
            'param_name' => 'slcr_carousel_nav_tab', 
            'description' => esc_html__('Enable arrows nav on tablet view.','sc-core') , 
            'weight' => 0,
            'edit_field_class' => 'vc_column vc_col-sm-4 crum_vc',
            'group' => esc_html__('Responsive','sc-core'), 
            'admin_label' => false,  
        ) ,
        array(
            'type' => 'checkbox',
            'class' => '',
            'heading' => esc_html__('Dots Nav on Tablet','sc-core') ,
            'param_name' => 'slcr_carousel_dots_tab', 
            'description' => esc_html__('Enable dots nav on tablet view.','sc-core') , 
            'weight' => 0,
            'edit_field_class' => 'vc_column vc_col-sm-4 crum_vc',
            'group' => esc_html__('Responsive','sc-core'), 
            'admin_label' => false, 
        ) ,
        array(
            'type' => 'textfield', 
            'class' => 'count-class',
            'heading' => esc_html__('Items on Mobile','sc-core') ,
            'description' => esc_html__('Number of visible items on mobile. Example - 3','sc-core') ,
            'param_name' => 'slcr_carousel_no_item_mob', 
            'edit_field_class' => 'vc_column vc_col-sm-4 crum_vc',
            'weight' => 0,
            'group' => esc_html__('Responsive','sc-core'),
            'admin_label' => false,  
        ) , 
        array(
            'type' => 'checkbox',
            'class' => '',
            'heading' => esc_html__('Arrow Nav on Mobile','sc-core') ,
            'param_name' => 'slcr_carousel_nav_mob', 
            'description' => esc_html__('Enable arrows nav on mobile view.','sc-core') , 
            'weight' => 0,
            'edit_field_class' => 'vc_column vc_col-sm-4 crum_vc',
            'group' => esc_html__('Responsive','sc-core'),
            'admin_label' => false, 
        ) ,
        array(
            'type' => 'checkbox',
            'class' => '',
            'heading' => esc_html__('Dots Nav on Mobile','sc-core') ,
            'param_name' => 'slcr_carousel_dots_mob', 
            'description' => esc_html__('Enable dots nav on mobile view.','sc-core') , 
            'weight' => 0,
            'edit_field_class' => 'vc_column vc_col-sm-4 crum_vc',
            'group' => esc_html__('Responsive','sc-core'), 
            'admin_label' => false, 
        ) ,
        array(
            'type' => 'el_id',
            'heading' => esc_html__('Element ID','sc-core') ,
            'param_name' => 'el_id',
            'description' => sprintf(__('Enter element ID (Note: make sure it is unique and valid according to ','sc-core').'<a href="%s" target="_blank">'.__('w3c specification','sc-core').'</a>).' , 'http://www.w3schools.com/tags/att_global_id.asp') ,
            'admin_label' => false,
            'group'       => esc_html__('General','sc-core'),
        ) ,
        array(
            'type' => 'textfield',
            'heading' => esc_html__('Extra class name','sc-core') ,
            'param_name' => 'el_class',
            'description' => esc_html__('Style particular content element differently - add a class name and refer to it in custom CSS.','sc-core') ,
            'admin_label' => false,
            'group'       => esc_html__('General','sc-core'),
        ) ,
         array(
            'type' => 'css_editor',
            'heading' => esc_html__('CSS box','sc-core') ,
            'param_name' => 'css',
            'admin_label' => false,
            'group' => esc_html__('Design Options','sc-core') ,
        ) ,
    ) ,
); 